/*
 * Copyright 2016-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at:
 *
 *    http://aws.amazon.com/apache2.0
 *
 * This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
 * OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and
 * limitations under the License.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

/**
 * Generator interface for generating attribute values.
 *
 * Use in combination with {@link DynamoDBAutoGenerated}.
 *
 * @param <T> The object's field/property value type.
 *
 * @see com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated
 */
public interface DynamoDBAutoGenerator<T extends Object> {

    /**
     * Gets the auto-generate strategy.
     */
    public DynamoDBAutoGenerateStrategy getGenerateStrategy();

    /**
     * Generates a new value given the current value (or null) if applicable.
     */
    public T generate(T currentValue);

}
