/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class DynamoDBMapperTableModel<T>
implements DynamoDBTypeConverter<Map<String, AttributeValue>, T> {
    private final Map<String, DynamoDBMapperFieldModel<T, Object>> fields;
    private final Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys;
    private final Map<String, GlobalSecondaryIndex> gsis;
    private final Map<String, LocalSecondaryIndex> lsis;
    private final Properties<T> properties;

    private DynamoDBMapperTableModel(Builder<T> builder) {
        this.properties = ((Builder)builder).properties;
        this.fields = ((Builder)builder).fields;
        this.keys = ((Builder)builder).keys;
        this.gsis = builder.globalSecondaryIndexes();
        this.lsis = builder.localSecondaryIndexes();
    }

    public Class<T> targetType() {
        return this.properties.targetType();
    }

    public String tableName() {
        return this.properties.tableName();
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> fields() {
        return this.fields.values();
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(String attributeName) {
        if (!this.fields.containsKey(attributeName)) {
            throw new DynamoDBMappingException(new DynamoDBMapperFieldModel.Id<T>(this.targetType(), attributeName).format("not mapped on object model", new Object[0]));
        }
        return this.fields.get(attributeName);
    }

    public <V> DynamoDBMapperFieldModel<T, V> field(KeyType keyType) {
        if (!this.keys.containsKey((Object)keyType)) {
            throw new DynamoDBMappingException(new DynamoDBMapperFieldModel.Id<T>(this.targetType(), keyType.name()).format("not mapped on object model", new Object[0]));
        }
        return this.keys.get((Object)keyType);
    }

    public Collection<DynamoDBMapperFieldModel<T, Object>> keys() {
        return this.keys.values();
    }

    public <H> DynamoDBMapperFieldModel<T, H> hashKey() {
        return this.field(KeyType.HASH);
    }

    public <R> DynamoDBMapperFieldModel<T, R> rangeKey() {
        return this.field(KeyType.RANGE);
    }

    public <R> DynamoDBMapperFieldModel<T, R> rangeKeyIfExists() {
        return this.keys.get((Object)KeyType.RANGE);
    }

    public Collection<GlobalSecondaryIndex> globalSecondaryIndexes() {
        if (this.gsis.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GlobalSecondaryIndex> copies = new ArrayList<GlobalSecondaryIndex>(this.gsis.size());
        for (String indexName : this.gsis.keySet()) {
            copies.add(this.globalSecondaryIndex(indexName));
        }
        return copies;
    }

    public GlobalSecondaryIndex globalSecondaryIndex(String indexName) {
        if (!this.gsis.containsKey(indexName)) {
            return null;
        }
        GlobalSecondaryIndex gsi = this.gsis.get(indexName);
        GlobalSecondaryIndex copy = new GlobalSecondaryIndex().withIndexName(gsi.getIndexName());
        copy.withProjection(new Projection().withProjectionType(gsi.getProjection().getProjectionType()));
        for (KeySchemaElement key : gsi.getKeySchema()) {
            copy.withKeySchema(new KeySchemaElement(key.getAttributeName(), key.getKeyType()));
        }
        return copy;
    }

    public Collection<LocalSecondaryIndex> localSecondaryIndexes() {
        if (this.lsis.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocalSecondaryIndex> copies = new ArrayList<LocalSecondaryIndex>(this.lsis.size());
        for (String indexName : this.lsis.keySet()) {
            copies.add(this.localSecondaryIndex(indexName));
        }
        return copies;
    }

    public LocalSecondaryIndex localSecondaryIndex(String indexName) {
        if (!this.lsis.containsKey(indexName)) {
            return null;
        }
        LocalSecondaryIndex lsi = this.lsis.get(indexName);
        LocalSecondaryIndex copy = new LocalSecondaryIndex().withIndexName(lsi.getIndexName());
        copy.withProjection(new Projection().withProjectionType(lsi.getProjection().getProjectionType()));
        for (KeySchemaElement key : lsi.getKeySchema()) {
            copy.withKeySchema(new KeySchemaElement(key.getAttributeName(), key.getKeyType()));
        }
        return copy;
    }

    @Override
    public Map<String, AttributeValue> convert(T object) {
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, AttributeValue> map = new LinkedHashMap<String, AttributeValue>();
        for (DynamoDBMapperFieldModel<T, Object> field : this.fields()) {
            AttributeValue value = field.getAndConvert(object);
            if (value == null) continue;
            map.put(field.name(), value);
        }
        return map;
    }

    @Override
    public T unconvert(Map<String, AttributeValue> object) {
        T result;
        try {
            result = this.targetType().newInstance();
        }
        catch (Exception e) {
            throw new DynamoDBMappingException("could not instantiate " + this.targetType(), e);
        }
        if (object != null && !object.isEmpty()) {
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields()) {
                AttributeValue value = object.get(field.name());
                if (value == null) continue;
                field.unconvertAndSet(result, value);
            }
        }
        return result;
    }

    public <H, R> T newKey(H hashKey, R rangeKey) {
        T key;
        try {
            key = this.targetType().newInstance();
        }
        catch (Exception e) {
            throw new DynamoDBMappingException("could not instantiate " + this.targetType(), e);
        }
        if (hashKey != null) {
            DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
            hk.set(key, hashKey);
        }
        if (rangeKey != null) {
            DynamoDBMapperFieldModel<T, R> rk = this.rangeKey();
            rk.set(key, rangeKey);
        }
        return key;
    }

    public <H, R> Map<String, AttributeValue> mapKey(H hashKey, R rangeKey) {
        LinkedHashMap<String, AttributeValue> key = new LinkedHashMap<String, AttributeValue>(4);
        if (hashKey != null) {
            DynamoDBMapperFieldModel<T, H> hk = this.hashKey();
            key.put(hk.name(), (AttributeValue)hk.convert((Object)hashKey));
        }
        if (rangeKey != null) {
            DynamoDBMapperFieldModel<T, R> rk = this.rangeKey();
            key.put(rk.name(), (AttributeValue)rk.convert((Object)rangeKey));
        }
        if (key.isEmpty()) {
            throw new DynamoDBMappingException("no key(s) present on " + this.targetType());
        }
        return key;
    }

    public <H, R> Map<String, AttributeValue> mapKey(T object) {
        LinkedHashMap<String, AttributeValue> key = new LinkedHashMap<String, AttributeValue>(4);
        for (DynamoDBMapperFieldModel<T, Object> field : this.keys()) {
            AttributeValue value = field.getAndConvert(object);
            if (value == null) {
                throw new DynamoDBMappingException(field.id().format("must not have null value for %s key", new Object[]{field.keyType()}));
            }
            key.put(field.name(), value);
        }
        if (key.isEmpty()) {
            throw new DynamoDBMappingException("no key(s) present on " + this.targetType());
        }
        return key;
    }

    public boolean anyKeyGeneratable(T object, DynamoDBMapperConfig.SaveBehavior saveBehavior) {
        if (this.keys().isEmpty()) {
            throw new DynamoDBMappingException("no key(s) present on " + this.targetType());
        }
        for (DynamoDBMapperFieldModel<T, Object> field : this.keys()) {
            if (!field.canGenerate(object, saveBehavior, null)) continue;
            return true;
        }
        return false;
    }

    static class Builder<T> {
        private final Map<String, DynamoDBMapperFieldModel<T, Object>> fields = new LinkedHashMap<String, DynamoDBMapperFieldModel<T, Object>>();
        private final Map<KeyType, DynamoDBMapperFieldModel<T, Object>> keys = new LinkedHashMap<KeyType, DynamoDBMapperFieldModel<T, Object>>(4);
        private final Properties.Builder<T> properties;

        public Builder(Properties<T> defaults) {
            this.properties = new Properties.Builder<T>().with(defaults);
        }

        public Builder<T> withTableName(String tableName) {
            this.properties.withTableName(tableName);
            return this;
        }

        public Builder<T> with(DynamoDBMapperFieldModel field) {
            if (this.fields.put(field.name(), field) != null) {
                throw new DynamoDBMappingException(field.id().format("must not duplicate attribute name", new Object[0]));
            }
            if (field.keyType() != null && this.keys.put(field.keyType(), field) != null) {
                throw new DynamoDBMappingException(field.id().format("must not specify multiple %s key(s)", new Object[]{field.keyType()}));
            }
            return this;
        }

        public Map<String, GlobalSecondaryIndex> globalSecondaryIndexes() {
            GlobalSecondaryIndex gsi;
            LinkedHashMap<String, GlobalSecondaryIndex> map = new LinkedHashMap<String, GlobalSecondaryIndex>();
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.HASH)) {
                    if (map.put(indexName, gsi = new GlobalSecondaryIndex().withIndexName(indexName)) != null) {
                        throw new DynamoDBMappingException(field.id().format("must not contain duplicate GSI named %s", indexName));
                    }
                    gsi.withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                    gsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.HASH));
                }
            }
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.globalSecondaryIndexNames(KeyType.RANGE)) {
                    gsi = (GlobalSecondaryIndex)map.get(indexName);
                    if (gsi == null) {
                        throw new DynamoDBMappingException(field.id().format("no HASH key present for GSI named %s", indexName));
                    }
                    gsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.RANGE));
                }
            }
            return Collections.unmodifiableMap(map);
        }

        public Map<String, LocalSecondaryIndex> localSecondaryIndexes() {
            LinkedHashMap<String, LocalSecondaryIndex> map = new LinkedHashMap<String, LocalSecondaryIndex>();
            for (DynamoDBMapperFieldModel<T, Object> field : this.fields.values()) {
                for (String indexName : field.localSecondaryIndexNames()) {
                    LocalSecondaryIndex lsi;
                    if (map.put(indexName, lsi = new LocalSecondaryIndex().withIndexName(indexName)) != null) {
                        throw new DynamoDBMappingException(field.id().format("must not contain duplicate LocalSecondaryIndexes named %s", indexName));
                    }
                    lsi.withProjection(new Projection().withProjectionType(ProjectionType.KEYS_ONLY));
                    lsi.withKeySchema(new KeySchemaElement(this.keys.get((Object)KeyType.HASH).name(), KeyType.HASH));
                    lsi.withKeySchema(new KeySchemaElement(field.name(), KeyType.RANGE));
                }
            }
            return Collections.unmodifiableMap(map);
        }

        public final DynamoDBMapperTableModel<T> build() {
            return new DynamoDBMapperTableModel(this);
        }
    }

    static interface Properties<T> {
        public Class<T> targetType();

        public String tableName();

        public static final class Builder<T>
        implements Properties<T> {
            private Class<T> targetType;
            private String tableName;

            public Builder<T> with(Properties<T> defaults) {
                this.targetType = defaults.targetType();
                this.tableName = defaults.tableName();
                return this;
            }

            public Builder<T> withTargetType(Class<T> targetType) {
                this.targetType = targetType;
                return this;
            }

            public Builder<T> withTableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            @Override
            public Class<T> targetType() {
                return this.targetType;
            }

            @Override
            public String tableName() {
                return this.tableName;
            }
        }
    }
}

