/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDB
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.ANNOTATION_TYPE})
public @interface DynamoDBTypeConverted {
    public Class<? extends DynamoDBTypeConverter> converter();

    public static final class Converters {
        static <S, T> DynamoDBTypeConverter<S, T> of(Class<T> targetType, Annotation annotation) {
            DynamoDBTypeConverted converted;
            if (annotation.annotationType() == DynamoDBTypeConverted.class) {
                converted = (DynamoDBTypeConverted)annotation;
            } else {
                converted = annotation.annotationType().getAnnotation(DynamoDBTypeConverted.class);
                if (converted == null) {
                    throw new DynamoDBMappingException("could not resolve type-converter: " + annotation);
                }
            }
            DynamoDBTypeConverter converter = null;
            try {
                if (annotation != converted) {
                    try {
                        converter = converted.converter().getConstructor(Class.class, annotation.annotationType()).newInstance(targetType, annotation);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (converter == null) {
                    try {
                        converter = converted.converter().getConstructor(Class.class).newInstance(targetType);
                    }
                    catch (NoSuchMethodException no) {
                        converter = converted.converter().newInstance();
                    }
                }
            }
            catch (Exception e) {
                throw new DynamoDBMappingException("could not create type-converter: " + annotation, e);
            }
            return converter;
        }
    }
}

