/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDBTypeConverted(converter=Converter.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBTypeConvertedEnum {

    public static final class Converter<T extends Enum<T>>
    implements DynamoDBTypeConverter<String, T> {
        private final DynamoDBTypeConverter<String, T> converter;

        public Converter(Class<T> targetType, DynamoDBTypeConvertedEnum annotation) {
            this.converter = StandardTypeConverters.converter(String.class, targetType);
        }

        @Override
        public final String convert(T object) {
            return this.converter.convert(object);
        }

        @Override
        public final T unconvert(String object) {
            return (T)((Enum)this.converter.unconvert(object));
        }
    }
}

