/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperModelFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAnnotationMaps;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardParameterTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SdkInternalApi
final class StandardAttributeTypes {
    StandardAttributeTypes() {
    }

    static interface Conversion<T> {
        public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> var1);

        public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> var1);
    }

    static final class Conversions<T>
    extends DynamoDBTypeConverterFactory.OverrideFactory<Object, T> {
        private final Set<Conversion<T>> conversions = new LinkedHashSet<Conversion<T>>();
        private final DynamoDBMapperModelFactory models;

        Conversions(DynamoDBTypeConverterFactory<Object, T> scalars, DynamoDBMapperModelFactory models) {
            super(scalars);
            this.models = models;
        }

        final Conversions<T> with(Conversion<T> conversion) {
            this.conversions.add(conversion);
            return this;
        }

        final DynamoDBTypeConverter<AttributeValue, T> getConverter(final StandardParameterTypes.ParamType<T> type) {
            for (Conversion<T> conversion : this.conversions) {
                if (!conversion.isAssignableFrom(type)) continue;
                return conversion.getConverter(type);
            }
            return new DynamoDBTypeConverter<AttributeValue, T>(){

                @Override
                public final AttributeValue convert(T o) {
                    throw new DynamoDBMappingException("type [" + type + "] is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                }

                @Override
                public final T unconvert(AttributeValue o) {
                    throw new DynamoDBMappingException("type [" + type + "] is not supported; requires @DynamoDBDocument or @DynamoDBTypeConverted");
                }
            };
        }

        final DynamoDBTypeConverter<AttributeValue, T> nativeBoolean(StandardParameterTypes.ParamType<T> type) {
            return AttributeType.BOOL.join(StandardTypeConverters.converter(AttributeType.BOOL.type().type(), type.type()));
        }

        final class AnyDocumentObject
        implements Conversion<T> {
            AnyDocumentObject() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardAnnotationMaps.of(type.type()).document() != null;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(final StandardParameterTypes.ParamType<T> type) {
                return AttributeType.M.join(new DynamoDBTypeConverter<Map<String, AttributeValue>, T>(){

                    @Override
                    public final Map<String, AttributeValue> convert(T o) {
                        return Conversions.this.models.getTableModel(type.type()).convert(o);
                    }

                    @Override
                    public final T unconvert(Map<String, AttributeValue> o) {
                        return Conversions.this.models.getTableModel(type.type()).unconvert(o);
                    }
                });
            }
        }

        final class AnyMap
        implements Conversion<T> {
            AnyMap() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.MAP.is(type.type()) && type.param(1) != null && StandardTypeConverters.Scalar.STRING.is(type.param(0).type());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                return AttributeType.M.join(StandardTypeConverters.Scalar.MAP.wrap(AttributeType.NULL.join(Conversions.this.getConverter(type.param(1)))));
            }
        }

        final class AnyList
        implements Conversion<T> {
            AnyList() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.LIST.is(type.type()) && type.param(0) != null;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                return AttributeType.L.join(StandardTypeConverters.Scalar.LIST.wrap(AttributeType.NULL.join(Conversions.this.getConverter(type.param(0)))));
            }
        }

        final class AnySet
        implements Conversion<T> {
            AnySet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.SET.is(type.type());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                return AttributeType.L.join(StandardTypeConverters.Scalar.SET.wrap(AttributeType.NULL.join(Conversions.this.getConverter(type.param(0)))));
            }
        }

        final class NativeBoolSet
        implements Conversion<T> {
            NativeBoolSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.SET.is(type.type()) && StandardTypeConverters.Scalar.BOOLEAN.is(type.param(0).type());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.join(new StandardTypeConverters.DelegateConverter<AttributeValue, List<AttributeValue>>(AttributeType.L.converter()){

                    @Override
                    public final List<AttributeValue> unconvert(AttributeValue o) {
                        if (o.getL() == null && o.getNS() != null) {
                            return StandardTypeConverters.convertAll(o.getNS(), AttributeType.BOOL.join(StandardTypeConverters.converter(Boolean.class, String.class)));
                        }
                        return (List)super.unconvert(o);
                    }
                }, StandardTypeConverters.Scalar.SET.wrap(AttributeType.NULL.join(AttributeType.BOOL.converter())));
            }
        }

        final class AnyObjectStringSet
        implements Conversion<T> {
            AnyObjectStringSet() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.SET.is(type.type());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                return AttributeType.SS.join(StandardTypeConverters.Scalar.SET.wrap(StandardTypeConverters.converter(String.class, Object.class)));
            }
        }

        final class AllScalarSets
        implements Conversion<T> {
            AllScalarSets() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.SET.is(type.type()) && type.param(0).scalar().scalarAttributeType() != null;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                AttributeType attribute = AttributeType.of(type.param(0).scalar().scalarAttributeType(), "S");
                return attribute.join(StandardTypeConverters.Scalar.SET.wrap(Conversions.this.getConverter(attribute.type().param(0).type(), type.param(0).type())));
            }
        }

        final class AllScalars
        implements Conversion<T> {
            AllScalars() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return type.scalar().scalarAttributeType() != null;
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                AttributeType attribute = AttributeType.of(type.scalar().scalarAttributeType(), new String[0]);
                return attribute.join(Conversions.this.getConverter(attribute.type().type(), type.type()));
            }
        }

        final class NativeBool
        implements Conversion<T> {
            NativeBool() {
            }

            @Override
            public boolean isAssignableFrom(StandardParameterTypes.ParamType<T> type) {
                return StandardTypeConverters.Scalar.BOOLEAN.is(type.type());
            }

            @Override
            public DynamoDBTypeConverter<AttributeValue, T> getConverter(StandardParameterTypes.ParamType<T> type) {
                return Conversions.this.nativeBoolean(type);
            }
        }
    }

    static enum AttributeType implements DynamoDBTypeConverter<AttributeValue, Object>
    {
        BOOL((StandardParameterTypes.ParamType)StandardParameterTypes.ParamType.of(Boolean.class, new Type[0]), (DynamoDBMapperFieldModel.Reflect)new DynamoDBMapperFieldModel.Reflect<AttributeValue, Boolean>(){

            @Override
            public final void set(AttributeValue o, Boolean value) {
                o.setBOOL(value);
            }

            @Override
            public final Boolean get(AttributeValue o) {
                return o.getBOOL();
            }
        }){

            @Override
            public final Object unconvert(AttributeValue o) {
                if (o.getBOOL() == null && o.getN() != null) {
                    return StandardTypeConverters.unconvert(o.getN(), Boolean.class);
                }
                return super.unconvert(o);
            }
        }
        ,
        S((StandardParameterTypes.ParamType)StandardParameterTypes.ParamType.of(String.class, new Type[0]), (DynamoDBMapperFieldModel.Reflect)new DynamoDBMapperFieldModel.Reflect<AttributeValue, String>(){

            @Override
            public final void set(AttributeValue o, String value) {
                o.setS(value);
            }

            @Override
            public final String get(AttributeValue o) {
                return o.getS();
            }
        }){

            @Override
            public final AttributeValue convert(Object o) {
                return ((String)o).length() == 0 ? null : super.convert(o);
            }
        }
        ,
        N(StandardParameterTypes.ParamType.of(String.class, new Type[0]), new DynamoDBMapperFieldModel.Reflect<AttributeValue, String>(){

            @Override
            public final void set(AttributeValue o, String value) {
                o.setN(value);
            }

            @Override
            public final String get(AttributeValue o) {
                return o.getN();
            }
        }),
        B(StandardParameterTypes.ParamType.of(ByteBuffer.class, new Type[0]), new DynamoDBMapperFieldModel.Reflect<AttributeValue, ByteBuffer>(){

            @Override
            public final void set(AttributeValue o, ByteBuffer value) {
                o.setB(value);
            }

            @Override
            public final ByteBuffer get(AttributeValue o) {
                return o.getB();
            }
        }),
        SS(StandardParameterTypes.ParamType.of(Set.class, new Type[]{String.class}), new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<String>>(){

            @Override
            public final void set(AttributeValue o, List<String> value) {
                o.setSS(value);
            }

            @Override
            public final List<String> get(AttributeValue o) {
                return o.getSS();
            }
        }),
        NS(StandardParameterTypes.ParamType.of(Set.class, new Type[]{String.class}), new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<String>>(){

            @Override
            public final void set(AttributeValue o, List<String> value) {
                o.setNS(value);
            }

            @Override
            public final List<String> get(AttributeValue o) {
                return o.getNS();
            }
        }),
        BS(StandardParameterTypes.ParamType.of(Set.class, new Type[]{ByteBuffer.class}), new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<ByteBuffer>>(){

            @Override
            public final void set(AttributeValue o, List<ByteBuffer> value) {
                o.setBS(value);
            }

            @Override
            public final List<ByteBuffer> get(AttributeValue o) {
                return o.getBS();
            }
        }),
        L(StandardParameterTypes.ParamType.of(List.class, new Type[]{AttributeValue.class}), new DynamoDBMapperFieldModel.Reflect<AttributeValue, List<AttributeValue>>(){

            @Override
            public final void set(AttributeValue o, List<AttributeValue> value) {
                o.setL(value);
            }

            @Override
            public final List<AttributeValue> get(AttributeValue o) {
                return o.getL();
            }
        }),
        M(StandardParameterTypes.ParamType.of(Map.class, new Type[]{String.class, AttributeValue.class}), new DynamoDBMapperFieldModel.Reflect<AttributeValue, Map<String, AttributeValue>>(){

            @Override
            public final void set(AttributeValue o, Map<String, AttributeValue> value) {
                o.setM(value);
            }

            @Override
            public final Map<String, AttributeValue> get(AttributeValue o) {
                return o.getM();
            }
        }),
        NULL((StandardParameterTypes.ParamType)StandardParameterTypes.ParamType.of(AttributeValue.class, new Type[0]), (DynamoDBMapperFieldModel.Reflect)new DynamoDBMapperFieldModel.Reflect<AttributeValue, Boolean>(){

            @Override
            public final void set(AttributeValue o, Boolean value) {
                o.setNULL(value);
            }

            @Override
            public final Boolean get(AttributeValue o) {
                return o.getNULL();
            }
        }){

            @Override
            final <T, U> DynamoDBTypeConverter<AttributeValue, U> join(DynamoDBTypeConverter<T, U> target) {
                return new StandardTypeConverters.DelegateConverter<AttributeValue, U>(target){

                    @Override
                    public final AttributeValue convert(U o) {
                        return o == null ? new AttributeValue().withNULL(true) : (AttributeValue)super.convert(o);
                    }
                };
            }
        };

        private final DynamoDBMapperFieldModel.Reflect<AttributeValue, Object> reflect;
        private final StandardParameterTypes.ParamType<Object> type;

        private AttributeType(StandardParameterTypes.ParamType<?> type, DynamoDBMapperFieldModel.Reflect<AttributeValue, ?> reflect) {
            this.reflect = reflect;
            this.type = type;
        }

        <T, U> DynamoDBTypeConverter<AttributeValue, U> join(DynamoDBTypeConverter<T, U> target) {
            return StandardTypeConverters.join(this.converter(), target);
        }

        final <T> DynamoDBTypeConverter<AttributeValue, T> converter() {
            return this;
        }

        final ScalarAttributeType scalarAttributeType() {
            return this.name().matches("[BNS]") ? ScalarAttributeType.valueOf(this.name()) : null;
        }

        final <T> StandardParameterTypes.ParamType<T> type() {
            return this.type;
        }

        @Override
        public AttributeValue convert(Object o) {
            AttributeValue value = new AttributeValue();
            this.reflect.set(value, o);
            return value;
        }

        @Override
        public Object unconvert(AttributeValue o) {
            Object value = this.reflect.get(o);
            if (value == null && o.isNULL() == null) {
                throw new DynamoDBMappingException("expected " + this.name() + " in value " + o);
            }
            return value;
        }

        static final AttributeValue copyAll(AttributeValue from, AttributeValue into) {
            for (AttributeType attribute : AttributeType.values()) {
                attribute.reflect.set(into, attribute.reflect.get(from));
            }
            return into;
        }

        static final AttributeType of(ScalarAttributeType scalarAttributeType, String ... suffix) {
            if (scalarAttributeType != null) {
                return AttributeType.valueOf(scalarAttributeType.name() + (suffix.length == 0 ? "" : suffix[0]));
            }
            return null;
        }
    }
}

