/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverterFactory;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

@SdkInternalApi
final class StandardTypeConverters<S, T>
implements DynamoDBTypeConverterFactory<S, T> {
    private static final DynamoDBTypeConverterFactory<?, ?> FACTORY = new StandardTypeConverters();

    StandardTypeConverters() {
    }

    static final <S, T> DynamoDBTypeConverterFactory<S, T> factory() {
        return FACTORY;
    }

    @Override
    public DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
        Scalar source = Scalar.of(sourceType);
        Scalar target = Scalar.of(targetType);
        final ConvertTo sourceFromTarget = source.from(sourceType, ((ConvertToMap)target.map).types[0]);
        final ConvertTo targetFromSource = target.from(targetType, ((ConvertToMap)source.map).types[0]);
        return new DynamoDBTypeConverter<S, T>(){

            @Override
            public final S convert(T o) {
                return sourceFromTarget.convertTo(o);
            }

            @Override
            public final T unconvert(S o) {
                return targetFromSource.convertTo(o);
            }
        };
    }

    static final <S, T> DynamoDBTypeConverter<S, T> converter(Class<S> sourceType, Class<T> targetType) {
        return StandardTypeConverters.factory().getConverter(sourceType, targetType);
    }

    static final <S, T> S convert(T o, Class<S> sourceType) {
        return StandardTypeConverters.converter(sourceType, o.getClass()).convert(o);
    }

    static final <S, T> T unconvert(S o, Class<T> targetType) {
        return StandardTypeConverters.converter(o.getClass(), targetType).unconvert(o);
    }

    static final <S, T> List<S> convertAll(Collection<T> o, DynamoDBTypeConverter<S, T> scalar) {
        ArrayList<S> vector = new ArrayList<S>(o.size());
        for (T t : o) {
            vector.add(scalar.convert(t));
        }
        return vector;
    }

    static final <S, T> List<T> unconvertAll(Collection<S> o, DynamoDBTypeConverter<S, T> scalar) {
        ArrayList<T> vector = new ArrayList<T>(o.size());
        for (S s : o) {
            vector.add(scalar.unconvert(s));
        }
        return vector;
    }

    static final <K, S, T> Map<K, S> convertAll(Map<K, T> o, DynamoDBTypeConverter<S, T> scalar) {
        LinkedHashMap<K, S> vector = new LinkedHashMap<K, S>();
        for (Map.Entry<K, T> t : o.entrySet()) {
            vector.put(t.getKey(), scalar.convert(t.getValue()));
        }
        return vector;
    }

    static final <K, S, T> Map<K, T> unconvertAll(Map<K, S> o, DynamoDBTypeConverter<S, T> scalar) {
        LinkedHashMap<K, T> vector = new LinkedHashMap<K, T>();
        for (Map.Entry<K, S> s : o.entrySet()) {
            vector.put(s.getKey(), scalar.unconvert(s.getValue()));
        }
        return vector;
    }

    static final <S, T, U> DynamoDBTypeConverter<S, U> join(final DynamoDBTypeConverter<S, T> source, final DynamoDBTypeConverter<T, U> target) {
        return new DynamoDBTypeConverter<S, U>(){

            @Override
            public final S convert(U o) {
                Object object = o == null ? null : (Object)target.convert(o);
                return object == null ? null : (Object)source.convert(object);
            }

            @Override
            public final U unconvert(S o) {
                Object object = o == null ? null : (Object)source.unconvert(o);
                return object == null ? null : (Object)target.unconvert(object);
            }
        };
    }

    static class DelegateConverter<S, T>
    implements DynamoDBTypeConverter<S, T> {
        private final DynamoDBTypeConverter<S, T> delegate;

        public DelegateConverter(DynamoDBTypeConverter<S, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public S convert(T o) {
            return this.delegate.convert(o);
        }

        @Override
        public T unconvert(S o) {
            return this.delegate.unconvert(o);
        }
    }

    static class ConvertTo<S, T> {
        private static final ConvertTo<?, ?> ANY = new ConvertTo();

        ConvertTo() {
        }

        public S convertTo(T o) {
            return (S)o;
        }
    }

    private static class ConvertToMap<S, T>
    extends LinkedHashMap<Class<?>, ConvertTo<S, T>> {
        private final Class<S>[] types;

        private ConvertToMap(Class<S> ... sourceTypes) {
            this.types = sourceTypes;
        }

        final <s extends S, t extends T> ConvertToMap<S, T> with(Class<t> targetType, ConvertTo<s, t> converter) {
            this.put(targetType, converter);
            return this;
        }

        final boolean isAssignableFrom(Class<?> sourceType) {
            for (Class<S> type : this.types) {
                if (!type.isAssignableFrom(sourceType)) continue;
                return true;
            }
            return false;
        }

        public ConvertTo<S, T> getConverter(Class<?> targetType) {
            for (Map.Entry entry : this.entrySet()) {
                if (!((Class)entry.getKey()).isAssignableFrom(targetType)) continue;
                return (ConvertTo)entry.getValue();
            }
            if (this.isAssignableFrom(targetType)) {
                return ConvertTo.ANY;
            }
            throw new DynamoDBMappingException("type [" + targetType + "] is not supported; no conversion from " + Arrays.toString(this.types));
        }
    }

    static enum Scalar {
        BIG_DECIMAL(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{BigDecimal.class}).with(String.class, new ConvertTo<BigDecimal, String>(){

            @Override
            public final BigDecimal convertTo(String o) {
                return new BigDecimal(o);
            }
        })),
        BIG_INTEGER(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{BigInteger.class}).with(String.class, new ConvertTo<BigInteger, String>(){

            @Override
            public final BigInteger convertTo(String o) {
                return new BigInteger(o);
            }
        })),
        BOOLEAN(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Boolean.class, Boolean.TYPE}).with(String.class, new ConvertTo<Boolean, String>(){

            @Override
            public final Boolean convertTo(String o) {
                return "0".equals(o) ? Boolean.FALSE : ("1".equals(o) ? Boolean.TRUE : Boolean.valueOf(o));
            }
        })),
        BYTE(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Byte.class, Byte.TYPE}).with(String.class, new ConvertTo<Byte, String>(){

            @Override
            public final Byte convertTo(String o) {
                return Byte.valueOf(o);
            }
        })),
        BYTE_ARRAY(ScalarAttributeType.B, new ConvertToMap<S, T>(new Class[]{byte[].class}).with(ByteBuffer.class, new ConvertTo<byte[], ByteBuffer>(){

            @Override
            public final byte[] convertTo(ByteBuffer o) {
                if (o.hasArray()) {
                    return o.array();
                }
                byte[] value = new byte[o.remaining()];
                o.get(value);
                return value;
            }
        })),
        BYTE_BUFFER(ScalarAttributeType.B, new ConvertToMap<S, T>(new Class[]{ByteBuffer.class}).with(byte[].class, new ConvertTo<ByteBuffer, byte[]>(){

            @Override
            public final ByteBuffer convertTo(byte[] o) {
                return ByteBuffer.wrap(o);
            }
        }).with(UUID.class, new ConvertTo<ByteBuffer, UUID>(){

            @Override
            public final ByteBuffer convertTo(UUID o) {
                ByteBuffer value = ByteBuffer.allocate(16);
                value.putLong(o.getMostSignificantBits());
                value.putLong(o.getLeastSignificantBits());
                value.position(0);
                return value;
            }
        })),
        CALENDAR(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{Calendar.class}).with(Date.class, new ConvertTo<Calendar, Date>(){

            @Override
            public final Calendar convertTo(Date o) {
                Calendar value = Calendar.getInstance();
                value.setTime(o);
                return value;
            }
        }).with(String.class, new ConvertTo<Calendar, String>(){

            @Override
            public final Calendar convertTo(String o) {
                Calendar value = Calendar.getInstance();
                value.setTime(DateUtils.parseISO8601Date((String)o));
                return value;
            }
        })),
        CHARACTER(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{Character.class, Character.TYPE}).with(String.class, new ConvertTo<Character, String>(){

            @Override
            public final Character convertTo(String o) {
                if (o.length() != 1) {
                    throw new DynamoDBMappingException("expected single character string");
                }
                return Character.valueOf(o.charAt(0));
            }
        })),
        CURRENCY(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{Currency.class}).with(String.class, new ConvertTo<Currency, String>(){

            @Override
            public final Currency convertTo(String o) {
                return Currency.getInstance(o);
            }
        })),
        DATE(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{Date.class}).with(Calendar.class, new ConvertTo<Date, Calendar>(){

            @Override
            public final Date convertTo(Calendar o) {
                return o.getTime();
            }
        }).with(Long.class, new ConvertTo<Date, Long>(){

            @Override
            public final Date convertTo(Long o) {
                return new Date(o);
            }
        }).with(String.class, new ConvertTo<Date, String>(){

            @Override
            public final Date convertTo(String o) {
                return DateUtils.parseISO8601Date((String)o);
            }
        })),
        DOUBLE(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Double.class, Double.TYPE}).with(String.class, new ConvertTo<Double, String>(){

            @Override
            public final Double convertTo(String o) {
                return Double.valueOf(o);
            }
        })),
        ENUM(null, (ConvertToMap)new ConvertToMap<S, T>(new Class[]{Enum.class})){

            @Override
            final <S, T> ConvertTo<S, T> from(final Class<S> sourceType, Class<T> targetType) {
                if (sourceType.isEnum() && STRING.is(targetType)) {
                    return new ConvertTo<Enum, String>(){

                        @Override
                        public final Enum convertTo(String o) {
                            return Enum.valueOf(sourceType, o);
                        }
                    };
                }
                return super.from(sourceType, targetType);
            }
        }
        ,
        FLOAT(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Float.class, Float.TYPE}).with(String.class, new ConvertTo<Float, String>(){

            @Override
            public final Float convertTo(String o) {
                return Float.valueOf(o);
            }
        })),
        INTEGER(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Integer.class, Integer.TYPE}).with(String.class, new ConvertTo<Integer, String>(){

            @Override
            public final Integer convertTo(String o) {
                return Integer.valueOf(o);
            }
        })),
        LIST(null, (ConvertToMap)new ConvertToMap<S, T>(new Class[]{List.class})){

            @Override
            final <S, T> DynamoDBTypeConverter<S, T> wrap(final DynamoDBTypeConverter<S, T> converter) {
                return new DynamoDBTypeConverter<Collection<S>, Collection<T>>(){

                    @Override
                    public final Collection<S> convert(Collection<T> o) {
                        return StandardTypeConverters.convertAll(o, converter);
                    }

                    @Override
                    public final Collection<T> unconvert(Collection<S> o) {
                        return StandardTypeConverters.unconvertAll(o, converter);
                    }
                };
            }
        }
        ,
        LONG(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Long.class, Long.TYPE}).with(Date.class, new ConvertTo<Long, Date>(){

            @Override
            public final Long convertTo(Date o) {
                return o.getTime();
            }
        }).with(String.class, new ConvertTo<Long, String>(){

            @Override
            public final Long convertTo(String o) {
                return Long.valueOf(o);
            }
        })),
        MAP(null, (ConvertToMap)new ConvertToMap<S, T>(new Class[]{Map.class})){

            @Override
            final <S, T> DynamoDBTypeConverter<S, T> wrap(final DynamoDBTypeConverter<S, T> converter) {
                return new DynamoDBTypeConverter<Map<Object, S>, Map<Object, T>>(){

                    @Override
                    public final Map<Object, S> convert(Map<Object, T> o) {
                        return StandardTypeConverters.convertAll(o, converter);
                    }

                    @Override
                    public final Map<Object, T> unconvert(Map<Object, S> o) {
                        return StandardTypeConverters.unconvertAll(o, converter);
                    }
                };
            }
        }
        ,
        S3_LINK(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{S3Link.class}).with(String.class, new ConvertTo<S3Link, String>(){

            @Override
            public final S3Link convertTo(String o) {
                return S3Link.fromJson(null, o);
            }
        })),
        SET(null, (ConvertToMap)new ConvertToMap<S, T>(new Class[]{Set.class})){

            @Override
            final <S, T> DynamoDBTypeConverter<S, T> wrap(final DynamoDBTypeConverter<S, T> converter) {
                return new DynamoDBTypeConverter<Collection<S>, Collection<T>>(){

                    @Override
                    public final Collection<S> convert(Collection<T> o) {
                        return StandardTypeConverters.convertAll(o, converter);
                    }

                    @Override
                    public final Collection<T> unconvert(Collection<S> o) {
                        LinkedHashSet vector = new LinkedHashSet();
                        for (Object s : o) {
                            if (vector.add(converter.unconvert(s))) continue;
                            throw new DynamoDBMappingException("duplicate value (" + s + ")");
                        }
                        return vector;
                    }
                };
            }
        }
        ,
        SHORT(ScalarAttributeType.N, new ConvertToMap<S, T>(new Class[]{Short.class, Short.TYPE}).with(String.class, new ConvertTo<Short, String>(){

            @Override
            public final Short convertTo(String o) {
                return Short.valueOf(o);
            }
        })),
        STRING(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{String.class}).with(Boolean.class, new ConvertTo<String, Boolean>(){

            @Override
            public final String convertTo(Boolean o) {
                return Boolean.TRUE.equals(o) ? "1" : "0";
            }
        }).with(Calendar.class, new ConvertTo<String, Calendar>(){

            @Override
            public final String convertTo(Calendar o) {
                return DateUtils.formatISO8601Date((Date)o.getTime());
            }
        }).with(Date.class, new ConvertTo<String, Date>(){

            @Override
            public final String convertTo(Date o) {
                return DateUtils.formatISO8601Date((Date)o);
            }
        }).with(Enum.class, new ConvertTo<String, Enum>(){

            @Override
            public final String convertTo(Enum o) {
                return o.name();
            }
        }).with(S3Link.class, new ConvertTo<String, S3Link>(){

            @Override
            public final String convertTo(S3Link o) {
                return o.getBucketName() == null || o.getKey() == null ? null : o.toJson();
            }
        }).with(TimeZone.class, new ConvertTo<String, TimeZone>(){

            @Override
            public final String convertTo(TimeZone o) {
                return o.getID();
            }
        }).with(Object.class, new ConvertTo<String, Object>(){

            @Override
            public final String convertTo(Object o) {
                return o.toString();
            }
        })),
        TIME_ZONE(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{TimeZone.class}).with(String.class, new ConvertTo<TimeZone, String>(){

            @Override
            public final TimeZone convertTo(String o) {
                return TimeZone.getTimeZone(o);
            }
        })),
        UUID(ScalarAttributeType.S, new ConvertToMap<S, T>(new Class[]{UUID.class}).with(ByteBuffer.class, new ConvertTo<UUID, ByteBuffer>(){

            @Override
            public final UUID convertTo(ByteBuffer o) {
                return new UUID(o.getLong(), o.getLong());
            }
        }).with(String.class, new ConvertTo<UUID, String>(){

            @Override
            public final UUID convertTo(String o) {
                return java.util.UUID.fromString(o);
            }
        })),
        DEFAULT(null, new ConvertToMap<S, T>(new Class[]{Object.class}));

        private final ScalarAttributeType scalarAttributeType;
        private final ConvertToMap<?, ?> map;

        private Scalar(ScalarAttributeType scalarAttributeType, ConvertToMap<?, ?> map) {
            this.scalarAttributeType = scalarAttributeType;
            this.map = map;
        }

        <S, T> DynamoDBTypeConverter<S, T> wrap(DynamoDBTypeConverter<S, T> converter) {
            return converter;
        }

        <S, T> ConvertTo<S, T> from(Class<S> sourceType, Class<T> targetType) {
            return this.map.getConverter(targetType);
        }

        final ScalarAttributeType scalarAttributeType() {
            return this.scalarAttributeType;
        }

        final boolean is(Class<?> sourceType) {
            return this.map.isAssignableFrom(sourceType);
        }

        static final Scalar of(Class<?> sourceType) {
            for (Scalar scalar : Scalar.values()) {
                if (!scalar.is(sourceType)) continue;
                return scalar;
            }
            return DEFAULT;
        }
    }
}

