/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class DynamoDBTypeConverterFactory {
    public abstract <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> var1, Class<T> var2);

    public final Builder override() {
        return new Builder(this);
    }

    public static final DynamoDBTypeConverterFactory standard() {
        return StandardTypeConverters.factory();
    }

    private static final class OverrideFactory
    extends AbstractDelegateFactory {
        private final Map<Map.Entry<Class<?>, Class<?>>, DynamoDBTypeConverter<?, ?>> overrides;

        private OverrideFactory(Builder builder) {
            super(builder.defaults);
            this.overrides = builder.overrides;
        }

        @Override
        public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            for (Map.Entry<Map.Entry<Class<?>, Class<?>>, DynamoDBTypeConverter<?, ?>> entry : this.overrides.entrySet()) {
                if (!entry.getKey().getKey().isAssignableFrom(sourceType) || !entry.getKey().getValue().isAssignableFrom(targetType)) continue;
                return entry.getValue();
            }
            return super.getConverter(sourceType, targetType);
        }
    }

    public static abstract class AbstractDelegateFactory
    extends DynamoDBTypeConverterFactory {
        private final DynamoDBTypeConverterFactory delegate;

        public AbstractDelegateFactory(DynamoDBTypeConverterFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public <S, T> DynamoDBTypeConverter<S, T> getConverter(Class<S> sourceType, Class<T> targetType) {
            return this.delegate.getConverter(sourceType, targetType);
        }
    }

    public static final class Builder {
        private final Map<Map.Entry<Class<?>, Class<?>>, DynamoDBTypeConverter<?, ?>> overrides = new LinkedHashMap();
        private final DynamoDBTypeConverterFactory defaults;

        private Builder(DynamoDBTypeConverterFactory defaults) {
            this.defaults = defaults;
        }

        public <S, T> Builder with(Class<S> sourceType, Class<T> targetType, DynamoDBTypeConverter<? extends S, ? extends T> converter) {
            if (StandardTypeConverters.Vector.SET.is(sourceType) || StandardTypeConverters.Vector.LIST.is(sourceType) || StandardTypeConverters.Vector.MAP.is(sourceType)) {
                throw new DynamoDBMappingException("type [" + sourceType + "] is not supported; type-converter factory only supports scalar conversions");
            }
            this.overrides.put(new AbstractMap.SimpleImmutableEntry<Class<S>, Class<T>>(sourceType, targetType), converter);
            return this;
        }

        public DynamoDBTypeConverterFactory build() {
            return new OverrideFactory(this);
        }
    }
}

