/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBDocument;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBFlattened;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperFieldModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBNativeBoolean;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBScalarAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverted;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardAttributeTypes;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@SdkInternalApi
final class StandardAnnotationMaps {
    StandardAnnotationMaps() {
    }

    static final <T> TableMap<T> of(Class<T> clazz) {
        DynamoDBMapperTableModel.Properties.Buildable<T> defaults = new DynamoDBMapperTableModel.Properties.Buildable<T>(new DynamoDBMapperTableModel.Properties[0]);
        defaults.withId(new DynamoDBMapperTableModel.Id<T>(clazz));
        defaults.withTargetType(clazz);
        TableMap map = new TableMap(defaults);
        map.putAll(clazz);
        return map;
    }

    static final <T, V> FieldMap<T, V> of(Class<T> clazz, Method getter) {
        String name = getter.getName().replaceFirst("^(get|is)", "");
        name = StringUtils.lowerCase((String)name.substring(0, 1)) + name.substring(1);
        DynamoDBMapperFieldModel.Properties.Buildable defaults = new DynamoDBMapperFieldModel.Properties.Buildable(new DynamoDBMapperFieldModel.Properties[0]);
        defaults.withId(new DynamoDBMapperFieldModel.Id<T>(clazz, name));
        defaults.withTargetType(getter.getReturnType());
        defaults.withAttributeName(name);
        Field declaredField = null;
        try {
            declaredField = getter.getDeclaringClass().getDeclaredField(name);
        }
        catch (SecurityException e) {
            throw new DynamoDBMappingException(defaults.id().err("no access to field for " + getter, new Object[0]), e);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        FieldMap map = new FieldMap(defaults);
        map.putAll(defaults.targetType());
        map.putAll(declaredField);
        map.putAll(getter);
        return map;
    }

    static final class FieldMap<T, V>
    extends AnnotationMap
    implements DynamoDBMapperFieldModel.Properties<T, V> {
        private final DynamoDBMapperFieldModel.Properties<T, V> defaults;

        private FieldMap(DynamoDBMapperFieldModel.Properties<T, V> defaults) {
            this.defaults = defaults;
        }

        final Annotation autoGenerated() {
            return this.get(DynamoDBAutoGenerated.class, true);
        }

        final Annotation typeConverted() {
            return this.get(DynamoDBTypeConverted.class, true);
        }

        final DynamoDBAttribute attribute() {
            return this.get(DynamoDBAttribute.class);
        }

        final DynamoDBDocument document() {
            return this.get(DynamoDBDocument.class);
        }

        final DynamoDBFlattened flattened() {
            return this.get(DynamoDBFlattened.class);
        }

        final DynamoDBHashKey hashKey() {
            return this.get(DynamoDBHashKey.class);
        }

        final DynamoDBIgnore ignore() {
            return this.get(DynamoDBIgnore.class);
        }

        final DynamoDBIndexHashKey indexHashKey() {
            return this.get(DynamoDBIndexHashKey.class);
        }

        final DynamoDBIndexRangeKey indexRangeKey() {
            return this.get(DynamoDBIndexRangeKey.class);
        }

        final DynamoDBNativeBoolean nativeBoolean() {
            return this.get(DynamoDBNativeBoolean.class);
        }

        final DynamoDBRangeKey rangeKey() {
            return this.get(DynamoDBRangeKey.class);
        }

        final DynamoDBScalarAttribute scalarAttribute() {
            return this.get(DynamoDBScalarAttribute.class);
        }

        final DynamoDBVersionAttribute version() {
            return this.get(DynamoDBVersionAttribute.class);
        }

        final boolean ignored() {
            return this.ignore() != null;
        }

        final Map<String, String> attributes() {
            if (this.flattened() != null) {
                if (this.flattened().attributes().length == 0) {
                    throw new DynamoDBMappingException(this.id().err("must specify one or more attributes", new Object[0]));
                }
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                for (DynamoDBAttribute a : this.flattened().attributes()) {
                    if (a.mappedBy().isEmpty() || a.attributeName().isEmpty()) {
                        throw new DynamoDBMappingException(this.id().err("must specify mappedBy and attributeName", new Object[0]));
                    }
                    if (attributes.put(a.mappedBy(), a.attributeName()) == null) continue;
                    throw new DynamoDBMappingException(this.id().err("must not duplicate mappedBy=" + a.mappedBy(), new Object[0]));
                }
                return attributes;
            }
            return Collections.emptyMap();
        }

        @Override
        public DynamoDBMapperFieldModel.Id<T> id() {
            return this.defaults.id();
        }

        @Override
        public Class<V> targetType() {
            return this.defaults.targetType();
        }

        @Override
        public final String attributeName() {
            if (this.hashKey() != null && !this.hashKey().attributeName().isEmpty()) {
                return this.hashKey().attributeName();
            }
            if (this.indexHashKey() != null && !this.indexHashKey().attributeName().isEmpty()) {
                return this.indexHashKey().attributeName();
            }
            if (this.rangeKey() != null && !this.rangeKey().attributeName().isEmpty()) {
                return this.rangeKey().attributeName();
            }
            if (this.indexRangeKey() != null && !this.indexRangeKey().attributeName().isEmpty()) {
                return this.indexRangeKey().attributeName();
            }
            if (this.attribute() != null && !this.attribute().attributeName().isEmpty()) {
                return this.attribute().attributeName();
            }
            if (this.version() != null && !this.version().attributeName().isEmpty()) {
                return this.version().attributeName();
            }
            if (this.scalarAttribute() != null && !this.scalarAttribute().attributeName().isEmpty()) {
                return this.scalarAttribute().attributeName();
            }
            return this.defaults.attributeName();
        }

        @Override
        public final DynamoDBMapperFieldModel.DynamoDBAttributeType attributeType() {
            if (this.nativeBoolean() != null) {
                return StandardAttributeTypes.AttributeType.BOOL.attributeType();
            }
            if (this.document() != null) {
                return StandardAttributeTypes.AttributeType.M.attributeType();
            }
            if (this.scalarAttribute() != null) {
                String name = this.scalarAttribute().type().name();
                if (StandardTypeConverters.Vector.SET.is(this.targetType())) {
                    name = name + "S";
                }
                return StandardAttributeTypes.AttributeType.valueOf(name).attributeType();
            }
            return this.defaults.attributeType();
        }

        @Override
        public final KeyType keyType() {
            if (this.hashKey() != null) {
                return KeyType.HASH;
            }
            if (this.rangeKey() != null) {
                return KeyType.RANGE;
            }
            return this.defaults.keyType();
        }

        @Override
        public final boolean versioned() {
            if (this.version() != null) {
                return Boolean.TRUE;
            }
            return this.defaults.versioned();
        }

        @Override
        public final Map<KeyType, List<String>> globalSecondaryIndexNames() {
            if (this.indexHashKey() != null || this.indexRangeKey() != null) {
                EnumMap<KeyType, List<String>> gsis = new EnumMap<KeyType, List<String>>(KeyType.class);
                if (this.indexHashKey() != null) {
                    if (!this.indexHashKey().globalSecondaryIndexName().isEmpty()) {
                        if (this.indexHashKey().globalSecondaryIndexNames().length > 0) {
                            throw new DynamoDBMappingException(this.id().err("must not specify both HASH GSI name/names", new Object[0]));
                        }
                        gsis.put(KeyType.HASH, Collections.singletonList(this.indexHashKey().globalSecondaryIndexName()));
                    } else if (this.indexHashKey().globalSecondaryIndexNames().length > 0) {
                        gsis.put(KeyType.HASH, Collections.unmodifiableList(Arrays.asList(this.indexHashKey().globalSecondaryIndexNames())));
                    } else {
                        throw new DynamoDBMappingException(this.id().err("must specify one of HASH GSI name/names", new Object[0]));
                    }
                }
                if (this.indexRangeKey() != null) {
                    if (!this.indexRangeKey().globalSecondaryIndexName().isEmpty()) {
                        if (this.indexRangeKey().globalSecondaryIndexNames().length > 0) {
                            throw new DynamoDBMappingException(this.id().err("must not specify both RANGE GSI name/names", new Object[0]));
                        }
                        gsis.put(KeyType.RANGE, Collections.singletonList(this.indexRangeKey().globalSecondaryIndexName()));
                    } else if (this.indexRangeKey().globalSecondaryIndexNames().length > 0) {
                        gsis.put(KeyType.RANGE, Collections.unmodifiableList(Arrays.asList(this.indexRangeKey().globalSecondaryIndexNames())));
                    } else if (this.localSecondaryIndexNames().isEmpty()) {
                        throw new DynamoDBMappingException(this.id().err("must specify RANGE GSI and/or LSI name/names", new Object[0]));
                    }
                }
                if (!gsis.isEmpty()) {
                    return Collections.unmodifiableMap(gsis);
                }
            }
            return this.defaults.globalSecondaryIndexNames();
        }

        @Override
        public final List<String> localSecondaryIndexNames() {
            if (this.indexRangeKey() != null) {
                if (!this.indexRangeKey().localSecondaryIndexName().isEmpty()) {
                    if (this.indexRangeKey().localSecondaryIndexNames().length > 0) {
                        throw new DynamoDBMappingException(this.id().err("must not specify both LSI name/names", new Object[0]));
                    }
                    return Collections.singletonList(this.indexRangeKey().localSecondaryIndexName());
                }
                if (this.indexRangeKey().localSecondaryIndexNames().length > 0) {
                    return Collections.unmodifiableList(Arrays.asList(this.indexRangeKey().localSecondaryIndexNames()));
                }
            }
            return this.defaults.localSecondaryIndexNames();
        }

        @Override
        public final DynamoDBAutoGenerator<V> autoGenerator() {
            if (this.autoGenerated() != null) {
                return DynamoDBAutoGenerated.Generators.of(this.targetType(), this.autoGenerated());
            }
            return this.defaults.autoGenerator();
        }

        @Override
        public final <S> DynamoDBTypeConverter<S, V> typeConverter() {
            if (this.typeConverted() != null) {
                return DynamoDBTypeConverted.Converters.of(this.targetType(), this.typeConverted());
            }
            return this.defaults.typeConverter();
        }
    }

    static final class TableMap<T>
    extends AnnotationMap
    implements DynamoDBMapperTableModel.Properties<T> {
        private final DynamoDBMapperTableModel.Properties<T> defaults;

        private TableMap(DynamoDBMapperTableModel.Properties<T> defaults) {
            this.defaults = defaults;
        }

        final DynamoDBDocument document() {
            return this.get(DynamoDBDocument.class);
        }

        final DynamoDBTable table() {
            return this.get(DynamoDBTable.class);
        }

        final boolean typed() {
            return this.table() != null || this.document() != null;
        }

        @Override
        public DynamoDBMapperTableModel.Id<T> id() {
            return this.defaults.id();
        }

        @Override
        public Class<T> targetType() {
            return this.defaults.targetType();
        }

        @Override
        public final String tableName() {
            if (this.table() != null && !this.table().tableName().isEmpty()) {
                return this.table().tableName();
            }
            return this.defaults.tableName();
        }
    }

    static abstract class AnnotationMap {
        private final Map<Class<? extends Annotation>, Annotation> map = new LinkedHashMap<Class<? extends Annotation>, Annotation>();

        AnnotationMap() {
        }

        final AnnotationMap putAll(AnnotatedElement annotated) {
            if (annotated != null && annotated.getAnnotations().length > 0) {
                LinkedHashMap<Class<? extends Annotation>, Annotation> tmp = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
                for (Annotation a1 : annotated.getAnnotations()) {
                    if (a1.annotationType().isAnnotationPresent(DynamoDB.class)) {
                        if (tmp.containsKey(a1.annotationType())) {
                            throw new DynamoDBMappingException("conflicting annotations " + a1 + " and " + tmp.get(a1.annotationType()) + "; allowed only one of @" + a1.annotationType().getSimpleName());
                        }
                        tmp.put(a1.annotationType(), a1);
                    }
                    for (Annotation a2 : a1.annotationType().getAnnotations()) {
                        if (!a2.annotationType().isAnnotationPresent(DynamoDB.class)) continue;
                        if (tmp.containsKey(a2.annotationType())) {
                            throw new DynamoDBMappingException("conflicting annotations " + a1 + " and " + tmp.get(a2.annotationType()) + "; allowed only one of @" + a2.annotationType().getSimpleName());
                        }
                        tmp.put(a2.annotationType(), a1);
                    }
                }
                this.map.putAll(tmp);
            }
            return this;
        }

        final <A extends Annotation> A get(Class<A> annotationType, boolean mappedBy) {
            Annotation annotation = this.map.get(annotationType);
            if (!mappedBy && annotation != null && annotation.annotationType() != annotationType) {
                return annotation.annotationType().getAnnotation(annotationType);
            }
            return (A)annotation;
        }

        final <A extends Annotation> A get(Class<A> annotationType) {
            return this.get(annotationType, false);
        }
    }
}

