/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

@SdkInternalApi
enum StandardTypeConverters {
    DATE_TO_CALENDAR(Date.class, Calendar.class, null, new DynamoDBTypeConverter<Date, Calendar>(){

        @Override
        public final Date convert(Calendar object) {
            return object.getTime();
        }

        @Override
        public final Calendar unconvert(Date object) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(object);
            return calendar;
        }
    }),
    DATE_TO_LONG(Date.class, Long.class, null, new DynamoDBTypeConverter<Date, Long>(){

        @Override
        public final Date convert(Long object) {
            return new Date(object);
        }

        @Override
        public final Long unconvert(Date object) {
            return object.getTime();
        }
    }),
    STRING_TO_BIGDECIMAL(String.class, BigDecimal.class, null, new DynamoDBTypeConverter<String, BigDecimal>(){

        @Override
        public final String convert(BigDecimal object) {
            return object.toString();
        }

        @Override
        public final BigDecimal unconvert(String object) {
            return new BigDecimal(object);
        }
    }),
    STRING_TO_BIGINTEGER(String.class, BigInteger.class, null, new DynamoDBTypeConverter<String, BigInteger>(){

        @Override
        public final String convert(BigInteger object) {
            return object.toString();
        }

        @Override
        public final BigInteger unconvert(String object) {
            return new BigInteger(object);
        }
    }),
    STRING_TO_BOOLEAN(String.class, Boolean.class, Boolean.TYPE, new DynamoDBTypeConverter<String, Boolean>(){

        @Override
        public final String convert(Boolean object) {
            return Boolean.TRUE.equals(object) ? "1" : "0";
        }

        @Override
        public final Boolean unconvert(String object) {
            return "0".equals(object) ? Boolean.FALSE : ("1".equals(object) ? Boolean.TRUE : Boolean.valueOf(object));
        }
    }),
    STRING_TO_BYTE(String.class, Byte.class, Byte.TYPE, new DynamoDBTypeConverter<String, Byte>(){

        @Override
        public final String convert(Byte object) {
            return object.toString();
        }

        @Override
        public final Byte unconvert(String object) {
            return Byte.valueOf(object);
        }
    }),
    STRING_TO_CALENDAR(String.class, Calendar.class, null, new DynamoDBTypeConverter<String, Calendar>(){

        @Override
        public final String convert(Calendar object) {
            return DateUtils.formatISO8601Date((Date)object.getTime());
        }

        @Override
        public final Calendar unconvert(String object) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(DateUtils.parseISO8601Date((String)object));
            return calendar;
        }
    }),
    STRING_TO_CHARACTER(String.class, Character.class, Character.TYPE, new DynamoDBTypeConverter<String, Character>(){

        @Override
        public final String convert(Character object) {
            return object.toString();
        }

        @Override
        public final Character unconvert(String object) {
            return Character.valueOf(object.charAt(0));
        }
    }),
    STRING_TO_DATE(String.class, Date.class, null, new DynamoDBTypeConverter<String, Date>(){

        @Override
        public final String convert(Date object) {
            return DateUtils.formatISO8601Date((Date)object);
        }

        @Override
        public final Date unconvert(String object) {
            return DateUtils.parseISO8601Date((String)object);
        }
    }),
    STRING_TO_DOUBLE(String.class, Double.class, Double.TYPE, new DynamoDBTypeConverter<String, Double>(){

        @Override
        public final String convert(Double object) {
            return object.toString();
        }

        @Override
        public final Double unconvert(String object) {
            return Double.valueOf(object);
        }
    }),
    STRING_TO_FLOAT(String.class, Float.class, Float.TYPE, new DynamoDBTypeConverter<String, Float>(){

        @Override
        public final String convert(Float object) {
            return object.toString();
        }

        @Override
        public final Float unconvert(String object) {
            return Float.valueOf(object);
        }
    }),
    STRING_TO_INTEGER(String.class, Integer.class, Integer.TYPE, new DynamoDBTypeConverter<String, Integer>(){

        @Override
        public final String convert(Integer object) {
            return object.toString();
        }

        @Override
        public final Integer unconvert(String object) {
            return Integer.valueOf(object);
        }
    }),
    STRING_TO_LONG(String.class, Long.class, Long.TYPE, new DynamoDBTypeConverter<String, Long>(){

        @Override
        public final String convert(Long object) {
            return object.toString();
        }

        @Override
        public final Long unconvert(String object) {
            return Long.valueOf(object);
        }
    }),
    STRING_TO_SHORT(String.class, Short.class, Short.TYPE, new DynamoDBTypeConverter<String, Short>(){

        @Override
        public final String convert(Short object) {
            return object.toString();
        }

        @Override
        public final Short unconvert(String object) {
            return Short.valueOf(object);
        }
    }),
    STRING_TO_UUID(String.class, UUID.class, null, new DynamoDBTypeConverter<String, UUID>(){

        @Override
        public final String convert(UUID object) {
            return object.toString();
        }

        @Override
        public final UUID unconvert(String object) {
            return UUID.fromString(object);
        }
    }),
    DEFAULT(Object.class, Object.class, null, new DynamoDBTypeConverter<Object, Object>(){

        @Override
        public final Object convert(Object object) {
            return object;
        }

        @Override
        public final Object unconvert(Object object) {
            return object;
        }
    });

    private final DynamoDBTypeConverter<?, ?> converter;
    private final Class<?> sourceType;
    private final Class<?> targetType;
    private final Class<?> targetPrimitiveType;

    private StandardTypeConverters(Class<?> sourceType, Class<?> targetType, Class<?> targetPrimitiveType, DynamoDBTypeConverter<?, ?> converter) {
        this.converter = converter;
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.targetPrimitiveType = targetPrimitiveType;
    }

    final <S, T> DynamoDBTypeConverter<S, T> converter() {
        return this.converter;
    }

    final <S> Class<S> sourceType() {
        return this.sourceType;
    }

    final <T> Class<T> targetType() {
        return this.targetType;
    }

    final <T> Class<T> targetPrimitiveType() {
        return this.targetPrimitiveType;
    }

    final <S, T> boolean isAssignableFrom(Class<S> sourceType, Class<T> targetType, boolean primitive) {
        if (this != DEFAULT && this.sourceType().isAssignableFrom(sourceType)) {
            if (!targetType.isPrimitive()) {
                return this.targetType().isAssignableFrom(targetType);
            }
            if (primitive && this.targetPrimitiveType() != null) {
                return this.targetPrimitiveType().isAssignableFrom(targetType);
            }
        }
        return false;
    }

    static final <S, T> DynamoDBTypeConverter<S, T> of(Class<S> sourceType, Class<T> targetType, boolean primitive) {
        if (targetType.isEnum()) {
            return new StringToEnum(targetType);
        }
        if (sourceType == targetType) {
            return DEFAULT.converter();
        }
        for (StandardTypeConverters standard : StandardTypeConverters.values()) {
            if (!standard.isAssignableFrom(sourceType, targetType, primitive)) continue;
            return standard.converter();
        }
        throw new DynamoDBMappingException("unsupported " + sourceType + " to " + targetType);
    }

    private static final class StringToEnum<T extends Enum<T>>
    implements DynamoDBTypeConverter<String, T> {
        private final Class<T> targetType;

        private StringToEnum(Class<T> targetType) {
            this.targetType = targetType;
        }

        @Override
        public final String convert(T object) {
            return ((Enum)object).name();
        }

        @Override
        public final T unconvert(String object) {
            return Enum.valueOf(this.targetType, object);
        }
    }
}

