/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import java.util.List;
import java.util.Map;

public class ItemCollectionMetricsJsonMarshaller {
    private static ItemCollectionMetricsJsonMarshaller instance;

    public void marshall(ItemCollectionMetrics itemCollectionMetrics, StructuredJsonGenerator jsonGenerator) {
        if (itemCollectionMetrics == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Double> sizeEstimateRangeGBList;
            jsonGenerator.writeStartObject();
            Map<String, AttributeValue> itemCollectionKeyMap = itemCollectionMetrics.getItemCollectionKey();
            if (itemCollectionKeyMap != null) {
                jsonGenerator.writeFieldName("ItemCollectionKey");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> itemCollectionKeyMapValue : itemCollectionKeyMap.entrySet()) {
                    if (itemCollectionKeyMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(itemCollectionKeyMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(itemCollectionKeyMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((sizeEstimateRangeGBList = itemCollectionMetrics.getSizeEstimateRangeGB()) != null) {
                jsonGenerator.writeFieldName("SizeEstimateRangeGB");
                jsonGenerator.writeStartArray();
                for (Double sizeEstimateRangeGBListValue : sizeEstimateRangeGBList) {
                    if (sizeEstimateRangeGBListValue == null) continue;
                    jsonGenerator.writeValue(sizeEstimateRangeGBListValue.doubleValue());
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ItemCollectionMetricsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ItemCollectionMetricsJsonMarshaller();
        }
        return instance;
    }
}

