/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementMarshaller;
import java.io.Serializable;

public class KeySchemaElement
implements Serializable,
Cloneable,
StructuredPojo {
    private String attributeName;
    private String keyType;

    public KeySchemaElement() {
    }

    public KeySchemaElement(String attributeName, String keyType) {
        this.setAttributeName(attributeName);
        this.setKeyType(keyType);
    }

    public KeySchemaElement(String attributeName, KeyType keyType) {
        this.setAttributeName(attributeName);
        this.setKeyType(keyType.toString());
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public KeySchemaElement withAttributeName(String attributeName) {
        this.setAttributeName(attributeName);
        return this;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public KeySchemaElement withKeyType(String keyType) {
        this.setKeyType(keyType);
        return this;
    }

    public void setKeyType(KeyType keyType) {
        this.keyType = keyType.toString();
    }

    public KeySchemaElement withKeyType(KeyType keyType) {
        this.setKeyType(keyType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeName() != null) {
            sb.append("AttributeName: ").append(this.getAttributeName()).append(",");
        }
        if (this.getKeyType() != null) {
            sb.append("KeyType: ").append(this.getKeyType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySchemaElement)) {
            return false;
        }
        KeySchemaElement other = (KeySchemaElement)obj;
        if (other.getAttributeName() == null ^ this.getAttributeName() == null) {
            return false;
        }
        if (other.getAttributeName() != null && !other.getAttributeName().equals(this.getAttributeName())) {
            return false;
        }
        if (other.getKeyType() == null ^ this.getKeyType() == null) {
            return false;
        }
        return other.getKeyType() == null || other.getKeyType().equals(this.getKeyType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeName() == null ? 0 : this.getAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getKeyType() == null ? 0 : this.getKeyType().hashCode());
        return hashCode;
    }

    public KeySchemaElement clone() {
        try {
            return (KeySchemaElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeySchemaElementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

