/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dynamodbv2.model.ParameterizedStatement;
import java.util.List;

@SdkInternalApi
public class ParameterizedStatementMarshaller {
    private static final MarshallingInfo<String> STATEMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statement").build();
    private static final MarshallingInfo<List> PARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final ParameterizedStatementMarshaller instance = new ParameterizedStatementMarshaller();

    public static ParameterizedStatementMarshaller getInstance() {
        return instance;
    }

    public void marshall(ParameterizedStatement parameterizedStatement, ProtocolMarshaller protocolMarshaller) {
        if (parameterizedStatement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)parameterizedStatement.getStatement(), STATEMENT_BINDING);
            protocolMarshaller.marshall(parameterizedStatement.getParameters(), PARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

