/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dynamodbv2;

import javax.annotation.Generated;

import com.amazonaws.*;
import com.amazonaws.regions.*;

import com.amazonaws.services.dynamodbv2.model.*;
import com.amazonaws.services.dynamodbv2.waiters.AmazonDynamoDBWaiters;

/**
 * Interface for accessing DynamoDB.
 * <p>
 * <b>Note:</b> Do not directly implement this interface, new methods are added to it regularly. Extend from
 * {@link com.amazonaws.services.dynamodbv2.AbstractAmazonDynamoDB} instead.
 * </p>
 * <p>
 * <fullname>Amazon DynamoDB</fullname>
 * <p>
 * Amazon DynamoDB is a fully managed NoSQL database service that provides fast and predictable performance with
 * seamless scalability. DynamoDB lets you offload the administrative burdens of operating and scaling a distributed
 * database, so that you don't have to worry about hardware provisioning, setup and configuration, replication, software
 * patching, or cluster scaling.
 * </p>
 * <p>
 * With DynamoDB, you can create database tables that can store and retrieve any amount of data, and serve any level of
 * request traffic. You can scale up or scale down your tables' throughput capacity without downtime or performance
 * degradation, and use the Amazon Web Services Management Console to monitor resource utilization and performance
 * metrics.
 * </p>
 * <p>
 * DynamoDB automatically spreads the data and traffic for your tables over a sufficient number of servers to handle
 * your throughput and storage requirements, while maintaining consistent and fast performance. All of your data is
 * stored on solid state disks (SSDs) and automatically replicated across multiple Availability Zones in an Amazon Web
 * Services Region, providing built-in high availability and data durability.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public interface AmazonDynamoDB {

    /**
     * The region metadata service name for computing region endpoints. You can use this value to retrieve metadata
     * (such as supported regions) of the service.
     *
     * @see RegionUtils#getRegionsForService(String)
     */
    String ENDPOINT_PREFIX = "dynamodb";

    /**
     * Overrides the default endpoint for this client ("https://dynamodb.us-east-1.amazonaws.com"). Callers can use this
     * method to control which AWS region they want to work with.
     * <p>
     * Callers can pass in just the endpoint (ex: "dynamodb.us-east-1.amazonaws.com") or a full URL, including the
     * protocol (ex: "https://dynamodb.us-east-1.amazonaws.com"). If the protocol is not specified here, the default
     * protocol from this client's {@link ClientConfiguration} will be used, which by default is HTTPS.
     * <p>
     * For more information on using AWS regions with the AWS SDK for Java, and a complete list of all available
     * endpoints for all AWS services, see: <a href=
     * "https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/java-dg-region-selection.html#region-selection-choose-endpoint"
     * > https://docs.aws.amazon.com/sdk-for-java/v1/developer-guide/java-dg-region-selection.html#region-selection-
     * choose-endpoint</a>
     * <p>
     * <b>This method is not threadsafe. An endpoint should be configured when the client is created and before any
     * service requests are made. Changing it afterwards creates inevitable race conditions for any service requests in
     * transit or retrying.</b>
     *
     * @param endpoint
     *        The endpoint (ex: "dynamodb.us-east-1.amazonaws.com") or a full URL, including the protocol (ex:
     *        "https://dynamodb.us-east-1.amazonaws.com") of the region specific AWS endpoint this client will
     *        communicate with.
     * @deprecated use {@link AwsClientBuilder#setEndpointConfiguration(AwsClientBuilder.EndpointConfiguration)} for
     *             example:
     *             {@code builder.setEndpointConfiguration(new EndpointConfiguration(endpoint, signingRegion));}
     */
    @Deprecated
    void setEndpoint(String endpoint);

    /**
     * An alternative to {@link AmazonDynamoDB#setEndpoint(String)}, sets the regional endpoint for this client's
     * service calls. Callers can use this method to control which AWS region they want to work with.
     * <p>
     * By default, all service endpoints in all regions use the https protocol. To use http instead, specify it in the
     * {@link ClientConfiguration} supplied at construction.
     * <p>
     * <b>This method is not threadsafe. A region should be configured when the client is created and before any service
     * requests are made. Changing it afterwards creates inevitable race conditions for any service requests in transit
     * or retrying.</b>
     *
     * @param region
     *        The region this client will communicate with. See {@link Region#getRegion(com.amazonaws.regions.Regions)}
     *        for accessing a given region. Must not be null and must be a region where the service is available.
     *
     * @see Region#getRegion(com.amazonaws.regions.Regions)
     * @see Region#createClient(Class, com.amazonaws.auth.AWSCredentialsProvider, ClientConfiguration)
     * @see Region#isServiceSupported(String)
     * @deprecated use {@link AwsClientBuilder#setRegion(String)}
     */
    @Deprecated
    void setRegion(Region region);

    /**
     * <p>
     * This operation allows you to perform batch reads or writes on data stored in DynamoDB, using PartiQL. Each read
     * statement in a <code>BatchExecuteStatement</code> must specify an equality condition on all key attributes. This
     * enforces that each <code>SELECT</code> statement in a batch returns at most a single item.
     * </p>
     * <note>
     * <p>
     * The entire batch must consist of either read statements or write statements, you cannot mix both in one batch.
     * </p>
     * </note> <important>
     * <p>
     * A HTTP 200 response does not mean that all statements in the BatchExecuteStatement succeeded. Error details for
     * individual statements can be found under the <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_BatchStatementResponse.html#DDB-Type-BatchStatementResponse-Error"
     * >Error</a> field of the <code>BatchStatementResponse</code> for each statement.
     * </p>
     * </important>
     * 
     * @param batchExecuteStatementRequest
     * @return Result of the BatchExecuteStatement operation returned by the service.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.BatchExecuteStatement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchExecuteStatement" target="_top">AWS
     *      API Documentation</a>
     */
    BatchExecuteStatementResult batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest);

    /**
     * <p>
     * The <code>BatchGetItem</code> operation returns the attributes of one or more items from one or more tables. You
     * identify requested items by primary key.
     * </p>
     * <p>
     * A single operation can retrieve up to 16 MB of data, which can contain as many as 100 items.
     * <code>BatchGetItem</code> returns a partial result if the response size limit is exceeded, the table's
     * provisioned throughput is exceeded, more than 1MB per partition is requested, or an internal processing failure
     * occurs. If a partial result is returned, the operation returns a value for <code>UnprocessedKeys</code>. You can
     * use this value to retry the operation starting with the next item to get.
     * </p>
     * <important>
     * <p>
     * If you request more than 100 items, <code>BatchGetItem</code> returns a <code>ValidationException</code> with the
     * message "Too many items requested for the BatchGetItem call."
     * </p>
     * </important>
     * <p>
     * For example, if you ask to retrieve 100 items, but each individual item is 300 KB in size, the system returns 52
     * items (so as not to exceed the 16 MB limit). It also returns an appropriate <code>UnprocessedKeys</code> value so
     * you can get the next page of results. If desired, your application can include its own logic to assemble the
     * pages of results into one dataset.
     * </p>
     * <p>
     * If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in
     * the request, then <code>BatchGetItem</code> returns a <code>ProvisionedThroughputExceededException</code>. If
     * <i>at least one</i> of the items is successfully processed, then <code>BatchGetItem</code> completes
     * successfully, while returning the keys of the unread items in <code>UnprocessedKeys</code>.
     * </p>
     * <important>
     * <p>
     * If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we
     * strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation
     * immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If
     * you delay the batch operation using exponential backoff, the individual requests in the batch are much more
     * likely to succeed.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#BatchOperations">Batch
     * Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * By default, <code>BatchGetItem</code> performs eventually consistent reads on every table in the request. If you
     * want strongly consistent reads instead, you can set <code>ConsistentRead</code> to <code>true</code> for any or
     * all tables.
     * </p>
     * <p>
     * In order to minimize response latency, <code>BatchGetItem</code> may retrieve items in parallel.
     * </p>
     * <p>
     * When designing your application, keep in mind that DynamoDB does not return items in any particular order. To
     * help parse the response by item, include the primary key values for the items in your request in the
     * <code>ProjectionExpression</code> parameter.
     * </p>
     * <p>
     * If a requested item does not exist, it is not returned in the result. Requests for nonexistent items consume the
     * minimum read capacity units according to the type of read. For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#CapacityUnitCalculations"
     * >Working with Tables</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @param batchGetItemRequest
     *        Represents the input of a <code>BatchGetItem</code> operation.
     * @return Result of the BatchGetItem operation returned by the service.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.BatchGetItem
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchGetItem" target="_top">AWS API
     *      Documentation</a>
     */
    BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest);

    /**
     * Simplified method form for invoking the BatchGetItem operation.
     *
     * @see #batchGetItem(BatchGetItemRequest)
     */
    BatchGetItemResult batchGetItem(java.util.Map<String, KeysAndAttributes> requestItems, String returnConsumedCapacity);

    /**
     * Simplified method form for invoking the BatchGetItem operation.
     *
     * @see #batchGetItem(BatchGetItemRequest)
     */
    BatchGetItemResult batchGetItem(java.util.Map<String, KeysAndAttributes> requestItems);

    /**
     * <p>
     * The <code>BatchWriteItem</code> operation puts or deletes multiple items in one or more tables. A single call to
     * <code>BatchWriteItem</code> can transmit up to 16MB of data over the network, consisting of up to 25 item put or
     * delete operations. While individual items can be up to 400 KB once stored, it's important to note that an item's
     * representation might be greater than 400KB while being sent in DynamoDB's JSON format for the API call. For more
     * details on this distinction, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html"
     * >Naming Rules and Data Types</a>.
     * </p>
     * <note>
     * <p>
     * <code>BatchWriteItem</code> cannot update items. If you perform a <code>BatchWriteItem</code> operation on an
     * existing item, that item's values will be overwritten by the operation and it will appear like it was updated. To
     * update items, we recommend you use the <code>UpdateItem</code> action.
     * </p>
     * </note>
     * <p>
     * The individual <code>PutItem</code> and <code>DeleteItem</code> operations specified in
     * <code>BatchWriteItem</code> are atomic; however <code>BatchWriteItem</code> as a whole is not. If any requested
     * operations fail because the table's provisioned throughput is exceeded or an internal processing failure occurs,
     * the failed operations are returned in the <code>UnprocessedItems</code> response parameter. You can investigate
     * and optionally resend the requests. Typically, you would call <code>BatchWriteItem</code> in a loop. Each
     * iteration would check for unprocessed items and submit a new <code>BatchWriteItem</code> request with those
     * unprocessed items until all items have been processed.
     * </p>
     * <p>
     * If <i>none</i> of the items can be processed due to insufficient provisioned throughput on all of the tables in
     * the request, then <code>BatchWriteItem</code> returns a <code>ProvisionedThroughputExceededException</code>.
     * </p>
     * <important>
     * <p>
     * If DynamoDB returns any unprocessed items, you should retry the batch operation on those items. However, <i>we
     * strongly recommend that you use an exponential backoff algorithm</i>. If you retry the batch operation
     * immediately, the underlying read or write requests can still fail due to throttling on the individual tables. If
     * you delay the batch operation using exponential backoff, the individual requests in the batch are much more
     * likely to succeed.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ErrorHandling.html#Programming.Errors.BatchOperations"
     * >Batch Operations and Error Handling</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * With <code>BatchWriteItem</code>, you can efficiently write or delete large amounts of data, such as from Amazon
     * EMR, or copy data from another database into DynamoDB. In order to improve performance with these large-scale
     * operations, <code>BatchWriteItem</code> does not behave in the same way as individual <code>PutItem</code> and
     * <code>DeleteItem</code> calls would. For example, you cannot specify conditions on individual put and delete
     * requests, and <code>BatchWriteItem</code> does not return deleted items in the response.
     * </p>
     * <p>
     * If you use a programming language that supports concurrency, you can use threads to write items in parallel. Your
     * application must include the necessary logic to manage the threads. With languages that don't support threading,
     * you must update or delete the specified items one at a time. In both situations, <code>BatchWriteItem</code>
     * performs the specified put and delete operations in parallel, giving you the power of the thread pool approach
     * without having to introduce complexity into your application.
     * </p>
     * <p>
     * Parallel processing reduces latency, but each specified put and delete request consumes the same number of write
     * capacity units whether it is processed in parallel or not. Delete operations on nonexistent items consume one
     * write capacity unit.
     * </p>
     * <p>
     * If one or more of the following is true, DynamoDB rejects the entire batch write operation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One or more tables specified in the <code>BatchWriteItem</code> request does not exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * Primary key attributes specified on an item in the request do not match those in the corresponding table's
     * primary key schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * You try to perform multiple operations on the same item in the same <code>BatchWriteItem</code> request. For
     * example, you cannot put and delete the same item in the same <code>BatchWriteItem</code> request.
     * </p>
     * </li>
     * <li>
     * <p>
     * Your request contains at least two items with identical hash and range keys (which essentially is two put
     * operations).
     * </p>
     * </li>
     * <li>
     * <p>
     * There are more than 25 requests in the batch.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any individual item in a batch exceeds 400 KB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The total request size exceeds 16 MB.
     * </p>
     * </li>
     * </ul>
     * 
     * @param batchWriteItemRequest
     *        Represents the input of a <code>BatchWriteItem</code> operation.
     * @return Result of the BatchWriteItem operation returned by the service.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws ItemCollectionSizeLimitExceededException
     *         An item collection is too large. This exception is only returned for tables that have one or more local
     *         secondary indexes.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.BatchWriteItem
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/BatchWriteItem" target="_top">AWS API
     *      Documentation</a>
     */
    BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest);

    /**
     * Simplified method form for invoking the BatchWriteItem operation.
     *
     * @see #batchWriteItem(BatchWriteItemRequest)
     */
    BatchWriteItemResult batchWriteItem(java.util.Map<String, java.util.List<WriteRequest>> requestItems);

    /**
     * <p>
     * Creates a backup for an existing table.
     * </p>
     * <p>
     * Each time you create an on-demand backup, the entire table data is backed up. There is no limit to the number of
     * on-demand backups that can be taken.
     * </p>
     * <p>
     * When you create an on-demand backup, a time marker of the request is cataloged, and the backup is created
     * asynchronously, by applying all changes until the time of the request to the last full table snapshot. Backup
     * requests are processed instantaneously and become available for restore within minutes.
     * </p>
     * <p>
     * You can call <code>CreateBackup</code> at a maximum rate of 50 times per second.
     * </p>
     * <p>
     * All backups in DynamoDB work without consuming any provisioned throughput on the table.
     * </p>
     * <p>
     * If you submit a backup request on 2018-12-14 at 14:25:00, the backup is guaranteed to contain all data committed
     * to the table up to 14:24:00, and data committed after 14:26:00 will not be. The backup might contain data
     * modifications made between 14:24:00 and 14:26:00. On-demand backup does not support causal consistency.
     * </p>
     * <p>
     * Along with data, the following are also included on the backups:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global secondary indexes (GSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Local secondary indexes (LSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Streams
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned read and write capacity
     * </p>
     * </li>
     * </ul>
     * 
     * @param createBackupRequest
     * @return Result of the CreateBackup operation returned by the service.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @throws TableInUseException
     *         A target table with the specified name is either being created or deleted.
     * @throws ContinuousBackupsUnavailableException
     *         Backups have not yet been enabled for this table.
     * @throws BackupInUseException
     *         There is another ongoing conflicting backup control plane operation on the table. The backup is either
     *         being created, deleted or restored to a table.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.CreateBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateBackup" target="_top">AWS API
     *      Documentation</a>
     */
    CreateBackupResult createBackup(CreateBackupRequest createBackupRequest);

    /**
     * <p>
     * Creates a global table from an existing table. A global table creates a replication relationship between two or
     * more DynamoDB tables with the same table name in the provided Regions.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29
     * (Legacy)</a> of global tables. We recommend using <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> when creating new global tables, as it provides greater flexibility, higher efficiency and consumes
     * less write capacity than 2017.11.29 (Legacy). To determine which version you are using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the version</a>. To update existing global tables from version 2017.11.29 (Legacy) to version
     * 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html"> Updating
     * global tables</a>.
     * </p>
     * </important>
     * <p>
     * If you want to add a new replica table to a global table, each of the following conditions must be true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The table must have the same primary key as all of the other replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The table must have the same name as all of the other replicas.
     * </p>
     * </li>
     * <li>
     * <p>
     * The table must have DynamoDB Streams enabled, with the stream containing both the new and the old images of the
     * item.
     * </p>
     * </li>
     * <li>
     * <p>
     * None of the replica tables in the global table can contain any data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If global secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The global secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If local secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The local secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The local secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * Write capacity settings should be set consistently across your replica tables and secondary indexes. DynamoDB
     * strongly recommends enabling auto scaling to manage the write capacity settings for all of your global tables
     * replicas and indexes.
     * </p>
     * <p>
     * If you prefer to manage write capacity settings manually, you should provision equal replicated write capacity
     * units to your replica tables. You should also provision equal replicated write capacity units to matching
     * secondary indexes across your global table.
     * </p>
     * </important>
     * 
     * @param createGlobalTableRequest
     * @return Result of the CreateGlobalTable operation returned by the service.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws GlobalTableAlreadyExistsException
     *         The specified global table already exists.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @sample AmazonDynamoDB.CreateGlobalTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateGlobalTable" target="_top">AWS API
     *      Documentation</a>
     */
    CreateGlobalTableResult createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest);

    /**
     * <p>
     * The <code>CreateTable</code> operation adds a new table to your account. In an Amazon Web Services account, table
     * names must be unique within each Region. That is, you can have two tables with same name if you create the tables
     * in different Regions.
     * </p>
     * <p>
     * <code>CreateTable</code> is an asynchronous operation. Upon receiving a <code>CreateTable</code> request,
     * DynamoDB immediately returns a response with a <code>TableStatus</code> of <code>CREATING</code>. After the table
     * is created, DynamoDB sets the <code>TableStatus</code> to <code>ACTIVE</code>. You can perform read and write
     * operations only on an <code>ACTIVE</code> table.
     * </p>
     * <p>
     * You can optionally define secondary indexes on the new table, as part of the <code>CreateTable</code> operation.
     * If you want to create multiple tables with secondary indexes on them, you must create the tables sequentially.
     * Only one table with secondary indexes can be in the <code>CREATING</code> state at any given time.
     * </p>
     * <p>
     * You can use the <code>DescribeTable</code> action to check the table status.
     * </p>
     * 
     * @param createTableRequest
     *        Represents the input of a <code>CreateTable</code> operation.
     * @return Result of the CreateTable operation returned by the service.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.CreateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/CreateTable" target="_top">AWS API
     *      Documentation</a>
     */
    CreateTableResult createTable(CreateTableRequest createTableRequest);

    /**
     * Simplified method form for invoking the CreateTable operation.
     *
     * @see #createTable(CreateTableRequest)
     */
    CreateTableResult createTable(java.util.List<AttributeDefinition> attributeDefinitions, String tableName, java.util.List<KeySchemaElement> keySchema,
            ProvisionedThroughput provisionedThroughput);

    /**
     * <p>
     * Deletes an existing backup of a table.
     * </p>
     * <p>
     * You can call <code>DeleteBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * 
     * @param deleteBackupRequest
     * @return Result of the DeleteBackup operation returned by the service.
     * @throws BackupNotFoundException
     *         Backup not found for the given BackupARN.
     * @throws BackupInUseException
     *         There is another ongoing conflicting backup control plane operation on the table. The backup is either
     *         being created, deleted or restored to a table.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DeleteBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteBackup" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteBackupResult deleteBackup(DeleteBackupRequest deleteBackupRequest);

    /**
     * <p>
     * Deletes a single item in a table by primary key. You can perform a conditional delete operation that deletes the
     * item if it exists, or if it has an expected attribute value.
     * </p>
     * <p>
     * In addition to deleting an item, you can also return the item's attribute values in the same operation, using the
     * <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * Unless you specify conditions, the <code>DeleteItem</code> is an idempotent operation; running it multiple times
     * on the same item or attribute does <i>not</i> result in an error response.
     * </p>
     * <p>
     * Conditional deletes are useful for deleting items only if specific conditions are met. If those conditions are
     * met, DynamoDB performs the delete. Otherwise, the item is not deleted.
     * </p>
     * 
     * @param deleteItemRequest
     *        Represents the input of a <code>DeleteItem</code> operation.
     * @return Result of the DeleteItem operation returned by the service.
     * @throws ConditionalCheckFailedException
     *         A condition specified in the operation could not be evaluated.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws ItemCollectionSizeLimitExceededException
     *         An item collection is too large. This exception is only returned for tables that have one or more local
     *         secondary indexes.
     * @throws TransactionConflictException
     *         Operation was rejected because there is an ongoing transaction for the item.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DeleteItem
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteItem" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest);

    /**
     * Simplified method form for invoking the DeleteItem operation.
     *
     * @see #deleteItem(DeleteItemRequest)
     */
    DeleteItemResult deleteItem(String tableName, java.util.Map<String, AttributeValue> key);

    /**
     * Simplified method form for invoking the DeleteItem operation.
     *
     * @see #deleteItem(DeleteItemRequest)
     */
    DeleteItemResult deleteItem(String tableName, java.util.Map<String, AttributeValue> key, String returnValues);

    /**
     * <p>
     * The <code>DeleteTable</code> operation deletes a table and all of its items. After a <code>DeleteTable</code>
     * request, the specified table is in the <code>DELETING</code> state until DynamoDB completes the deletion. If the
     * table is in the <code>ACTIVE</code> state, you can delete it. If a table is in <code>CREATING</code> or
     * <code>UPDATING</code> states, then DynamoDB returns a <code>ResourceInUseException</code>. If the specified table
     * does not exist, DynamoDB returns a <code>ResourceNotFoundException</code>. If table is already in the
     * <code>DELETING</code> state, no error is returned.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> of global tables.
     * </p>
     * </important> <note>
     * <p>
     * DynamoDB might continue to accept data read and write operations, such as <code>GetItem</code> and
     * <code>PutItem</code>, on a table in the <code>DELETING</code> state until the table deletion is complete.
     * </p>
     * </note>
     * <p>
     * When you delete a table, any indexes on that table are also deleted.
     * </p>
     * <p>
     * If you have DynamoDB Streams enabled on the table, then the corresponding stream on that table goes into the
     * <code>DISABLED</code> state, and the stream is automatically deleted after 24 hours.
     * </p>
     * <p>
     * Use the <code>DescribeTable</code> action to check the status of the table.
     * </p>
     * 
     * @param deleteTableRequest
     *        Represents the input of a <code>DeleteTable</code> operation.
     * @return Result of the DeleteTable operation returned by the service.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DeleteTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DeleteTable" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest);

    /**
     * Simplified method form for invoking the DeleteTable operation.
     *
     * @see #deleteTable(DeleteTableRequest)
     */
    DeleteTableResult deleteTable(String tableName);

    /**
     * <p>
     * Describes an existing backup of a table.
     * </p>
     * <p>
     * You can call <code>DescribeBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * 
     * @param describeBackupRequest
     * @return Result of the DescribeBackup operation returned by the service.
     * @throws BackupNotFoundException
     *         Backup not found for the given BackupARN.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeBackup" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeBackupResult describeBackup(DescribeBackupRequest describeBackupRequest);

    /**
     * <p>
     * Checks the status of continuous backups and point in time recovery on the specified table. Continuous backups are
     * <code>ENABLED</code> on all tables at table creation. If point in time recovery is enabled,
     * <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.
     * </p>
     * <p>
     * After continuous backups and point in time recovery are enabled, you can restore to any point in time within
     * <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
     * </p>
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table
     * to any point in time during the last 35 days.
     * </p>
     * <p>
     * You can call <code>DescribeContinuousBackups</code> at a maximum rate of 10 times per second.
     * </p>
     * 
     * @param describeContinuousBackupsRequest
     * @return Result of the DescribeContinuousBackups operation returned by the service.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeContinuousBackups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContinuousBackups"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeContinuousBackupsResult describeContinuousBackups(DescribeContinuousBackupsRequest describeContinuousBackupsRequest);

    /**
     * <p>
     * Returns information about contributor insights for a given table or global secondary index.
     * </p>
     * 
     * @param describeContributorInsightsRequest
     * @return Result of the DescribeContributorInsights operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeContributorInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeContributorInsightsResult describeContributorInsights(DescribeContributorInsightsRequest describeContributorInsightsRequest);

    /**
     * <p>
     * Returns the regional endpoint information. For more information on policy permissions, please see <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/inter-network-traffic-privacy.html#inter-network-traffic-DescribeEndpoints"
     * >Internetwork traffic privacy</a>.
     * </p>
     * 
     * @param describeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @sample AmazonDynamoDB.DescribeEndpoints
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeEndpointsResult describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest);

    /**
     * <p>
     * Describes an existing table export.
     * </p>
     * 
     * @param describeExportRequest
     * @return Result of the DescribeExport operation returned by the service.
     * @throws ExportNotFoundException
     *         The specified export was not found.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeExport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeExport" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeExportResult describeExport(DescribeExportRequest describeExportRequest);

    /**
     * <p>
     * Returns information about the specified global table.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29
     * (Legacy)</a> of global tables. We recommend using <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> when creating new global tables, as it provides greater flexibility, higher efficiency and consumes
     * less write capacity than 2017.11.29 (Legacy). To determine which version you are using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the version</a>. To update existing global tables from version 2017.11.29 (Legacy) to version
     * 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html"> Updating
     * global tables</a>.
     * </p>
     * </important>
     * 
     * @param describeGlobalTableRequest
     * @return Result of the DescribeGlobalTable operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws GlobalTableNotFoundException
     *         The specified global table does not exist.
     * @sample AmazonDynamoDB.DescribeGlobalTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTable" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeGlobalTableResult describeGlobalTable(DescribeGlobalTableRequest describeGlobalTableRequest);

    /**
     * <p>
     * Describes Region-specific settings for a global table.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29
     * (Legacy)</a> of global tables. We recommend using <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> when creating new global tables, as it provides greater flexibility, higher efficiency and consumes
     * less write capacity than 2017.11.29 (Legacy). To determine which version you are using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the version</a>. To update existing global tables from version 2017.11.29 (Legacy) to version
     * 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html"> Updating
     * global tables</a>.
     * </p>
     * </important>
     * 
     * @param describeGlobalTableSettingsRequest
     * @return Result of the DescribeGlobalTableSettings operation returned by the service.
     * @throws GlobalTableNotFoundException
     *         The specified global table does not exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeGlobalTableSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeGlobalTableSettings"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeGlobalTableSettingsResult describeGlobalTableSettings(DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest);

    /**
     * <p>
     * Represents the properties of the import.
     * </p>
     * 
     * @param describeImportRequest
     * @return Result of the DescribeImport operation returned by the service.
     * @throws ImportNotFoundException
     *         The specified import was not found.
     * @sample AmazonDynamoDB.DescribeImport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeImport" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeImportResult describeImport(DescribeImportRequest describeImportRequest);

    /**
     * <p>
     * Returns information about the status of Kinesis streaming.
     * </p>
     * 
     * @param describeKinesisStreamingDestinationRequest
     * @return Result of the DescribeKinesisStreamingDestination operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeKinesisStreamingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeKinesisStreamingDestinationResult describeKinesisStreamingDestination(
            DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest);

    /**
     * <p>
     * Returns the current provisioned-capacity quotas for your Amazon Web Services account in a Region, both for the
     * Region as a whole and for any one DynamoDB table that you create there.
     * </p>
     * <p>
     * When you establish an Amazon Web Services account, the account has initial quotas on the maximum read capacity
     * units and write capacity units that you can provision across all of your DynamoDB tables in a given Region. Also,
     * there are per-table quotas that apply when you create a table there. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html">Service, Account, and Table
     * Quotas</a> page in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * Although you can increase these quotas by filing a case at <a
     * href="https://console.aws.amazon.com/support/home#/">Amazon Web Services Support Center</a>, obtaining the
     * increase is not instantaneous. The <code>DescribeLimits</code> action lets you write code to compare the capacity
     * you are currently using to those quotas imposed by your account so that you have enough time to apply for an
     * increase before you hit a quota.
     * </p>
     * <p>
     * For example, you could use one of the Amazon Web Services SDKs to do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>DescribeLimits</code> for a particular Region to obtain your current account quotas on provisioned
     * capacity there.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a variable to hold the aggregate read capacity units provisioned for all your tables in that Region, and
     * one to hold the aggregate write capacity units. Zero them both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>ListTables</code> to obtain a list of all your DynamoDB tables.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each table name listed by <code>ListTables</code>, do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Call <code>DescribeTable</code> with the table name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use the data returned by <code>DescribeTable</code> to add the read capacity units and write capacity units
     * provisioned for the table itself to your variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the table has one or more global secondary indexes (GSIs), loop over these GSIs and add their provisioned
     * capacity values to your variables as well.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Report the account quotas for that Region returned by <code>DescribeLimits</code>, along with the total current
     * provisioned capacity levels you have calculated.
     * </p>
     * </li>
     * </ol>
     * <p>
     * This will let you see whether you are getting close to your account-level quotas.
     * </p>
     * <p>
     * The per-table quotas apply only when you are creating a new table. They restrict the sum of the provisioned
     * capacity of the new table itself and all its global secondary indexes.
     * </p>
     * <p>
     * For existing tables and their GSIs, DynamoDB doesn't let you increase provisioned capacity extremely rapidly, but
     * the only quota that applies is that the aggregate provisioned capacity over all your tables and GSIs cannot
     * exceed either of the per-account quotas.
     * </p>
     * <note>
     * <p>
     * <code>DescribeLimits</code> should only be called periodically. You can expect throttling errors if you call it
     * more than once in a minute.
     * </p>
     * </note>
     * <p>
     * The <code>DescribeLimits</code> Request element has no content.
     * </p>
     * 
     * @param describeLimitsRequest
     *        Represents the input of a <code>DescribeLimits</code> operation. Has no content.
     * @return Result of the DescribeLimits operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeLimitsResult describeLimits(DescribeLimitsRequest describeLimitsRequest);

    /**
     * <p>
     * Returns information about the table, including the current status of the table, when it was created, the primary
     * key schema, and any indexes on the table.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> of global tables.
     * </p>
     * </important> <note>
     * <p>
     * If you issue a <code>DescribeTable</code> request immediately after a <code>CreateTable</code> request, DynamoDB
     * might return a <code>ResourceNotFoundException</code>. This is because <code>DescribeTable</code> uses an
     * eventually consistent query, and the metadata for your table might not be available at that moment. Wait for a
     * few seconds, and then try the <code>DescribeTable</code> request again.
     * </p>
     * </note>
     * 
     * @param describeTableRequest
     *        Represents the input of a <code>DescribeTable</code> operation.
     * @return Result of the DescribeTable operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTable" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeTableResult describeTable(DescribeTableRequest describeTableRequest);

    /**
     * Simplified method form for invoking the DescribeTable operation.
     *
     * @see #describeTable(DescribeTableRequest)
     */
    DescribeTableResult describeTable(String tableName);

    /**
     * <p>
     * Describes auto scaling settings across replicas of the global table at once.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> of global tables.
     * </p>
     * </important>
     * 
     * @param describeTableReplicaAutoScalingRequest
     * @return Result of the DescribeTableReplicaAutoScaling operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeTableReplicaAutoScaling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTableReplicaAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeTableReplicaAutoScalingResult describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest);

    /**
     * <p>
     * Gives a description of the Time to Live (TTL) status on the specified table.
     * </p>
     * 
     * @param describeTimeToLiveRequest
     * @return Result of the DescribeTimeToLive operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.DescribeTimeToLive
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DescribeTimeToLive" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeTimeToLiveResult describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest);

    /**
     * <p>
     * Stops replication from the DynamoDB table to the Kinesis data stream. This is done without deleting either of the
     * resources.
     * </p>
     * 
     * @param disableKinesisStreamingDestinationRequest
     * @return Result of the DisableKinesisStreamingDestination operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @sample AmazonDynamoDB.DisableKinesisStreamingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/DisableKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    DisableKinesisStreamingDestinationResult disableKinesisStreamingDestination(
            DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest);

    /**
     * <p>
     * Starts table data replication to the specified Kinesis data stream at a timestamp chosen during the enable
     * workflow. If this operation doesn't return results immediately, use DescribeKinesisStreamingDestination to check
     * if streaming to the Kinesis data stream is ACTIVE.
     * </p>
     * 
     * @param enableKinesisStreamingDestinationRequest
     * @return Result of the EnableKinesisStreamingDestination operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @sample AmazonDynamoDB.EnableKinesisStreamingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/EnableKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    EnableKinesisStreamingDestinationResult enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest);

    /**
     * <p>
     * This operation allows you to perform reads and singleton writes on data stored in DynamoDB, using PartiQL.
     * </p>
     * <p>
     * For PartiQL reads (<code>SELECT</code> statement), if the total number of processed items exceeds the maximum
     * dataset size limit of 1 MB, the read stops and results are returned to the user as a
     * <code>LastEvaluatedKey</code> value to continue the read in a subsequent operation. If the filter criteria in
     * <code>WHERE</code> clause does not match any data, the read will return an empty result set.
     * </p>
     * <p>
     * A single <code>SELECT</code> statement response can return up to the maximum number of items (if using the Limit
     * parameter) or a maximum of 1 MB of data (and then apply any filtering to the results using <code>WHERE</code>
     * clause). If <code>LastEvaluatedKey</code> is present in the response, you need to paginate the result set. If
     * <code>NextToken</code> is present, you need to paginate the result set and include <code>NextToken</code>.
     * </p>
     * 
     * @param executeStatementRequest
     * @return Result of the ExecuteStatement operation returned by the service.
     * @throws ConditionalCheckFailedException
     *         A condition specified in the operation could not be evaluated.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws ItemCollectionSizeLimitExceededException
     *         An item collection is too large. This exception is only returned for tables that have one or more local
     *         secondary indexes.
     * @throws TransactionConflictException
     *         Operation was rejected because there is an ongoing transaction for the item.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DuplicateItemException
     *         There was an attempt to insert an item with the same primary key as an item that already exists in the
     *         DynamoDB table.
     * @sample AmazonDynamoDB.ExecuteStatement
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExecuteStatement" target="_top">AWS API
     *      Documentation</a>
     */
    ExecuteStatementResult executeStatement(ExecuteStatementRequest executeStatementRequest);

    /**
     * <p>
     * This operation allows you to perform transactional reads or writes on data stored in DynamoDB, using PartiQL.
     * </p>
     * <note>
     * <p>
     * The entire transaction must consist of either read statements or write statements, you cannot mix both in one
     * transaction. The EXISTS function is an exception and can be used to check the condition of specific attributes of
     * the item in a similar manner to <code>ConditionCheck</code> in the <a href=
     * "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/transaction-apis.html#transaction-apis-txwriteitems"
     * >TransactWriteItems</a> API.
     * </p>
     * </note>
     * 
     * @param executeTransactionRequest
     * @return Result of the ExecuteTransaction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws TransactionCanceledException
     *         The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property.
     *         This property is not set for other languages. Transaction cancellation reasons are ordered in the order
     *         of requested items, if an item has no error it will have <code>None</code> code and <code>Null</code>
     *         message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @throws TransactionInProgressException
     *         The transaction with the given request token is already in progress.</p>
     *         <p>
     *         Recommended Settings
     *         </p>
     *         <note>
     *         <p>
     *         This is a general recommendation for handling the <code>TransactionInProgressException</code>. These
     *         settings help ensure that the client retries will trigger completion of the ongoing <code>
     *         TransactWriteItems</code> request.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>clientExecutionTimeout</code> to a value that allows at least one retry to be processed after 5
     *         seconds have elapsed since the first attempt for the <code>TransactWriteItems</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>socketTimeout</code> to a value a little lower than the <code>requestTimeout</code> setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requestTimeout</code> should be set based on the time taken for the individual retries of a single
     *         HTTP request for your use case, but setting it to 1 second or higher should work well to reduce chances
     *         of retries and <code>TransactionInProgressException</code> errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use exponential backoff when retrying and tune backoff if needed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Assuming <a href=
     *         "https://github.com/aws/aws-sdk-java/blob/fd409dee8ae23fb8953e0bb4dbde65536a7e0514/aws-java-sdk-core/src/main/java/com/amazonaws/retry/PredefinedRetryPolicies.java#L97"
     *         >default retry policy</a>, example timeout settings based on the guidelines above are as follows:
     *         </p>
     *         <p>
     *         Example timeline:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0-1000 first attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1000-1500 first sleep/delay (default retry policy uses 500 ms as base delay for 4xx errors)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1500-2500 second attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2500-3500 second sleep/delay (500 * 2, exponential backoff)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3500-4500 third attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4500-6500 third sleep/delay (500 * 2^2)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         6500-7500 fourth attempt (this can trigger inline recovery since 5 seconds have elapsed since the first
     *         attempt reached TC)
     *         </p>
     *         </li>
     * @throws IdempotentParameterMismatchException
     *         DynamoDB rejected the request because you retried a request with a different payload but with an
     *         idempotent token that was already used.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ExecuteTransaction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExecuteTransaction" target="_top">AWS
     *      API Documentation</a>
     */
    ExecuteTransactionResult executeTransaction(ExecuteTransactionRequest executeTransactionRequest);

    /**
     * <p>
     * Exports table data to an S3 bucket. The table must have point in time recovery enabled, and you can export data
     * from any time within the point in time recovery window.
     * </p>
     * 
     * @param exportTableToPointInTimeRequest
     * @return Result of the ExportTableToPointInTime operation returned by the service.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @throws PointInTimeRecoveryUnavailableException
     *         Point in time recovery has not yet been enabled for this source table.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InvalidExportTimeException
     *         The specified <code>ExportTime</code> is outside of the point in time recovery window.
     * @throws ExportConflictException
     *         There was a conflict when writing to the specified S3 bucket.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ExportTableToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ExportTableToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    ExportTableToPointInTimeResult exportTableToPointInTime(ExportTableToPointInTimeRequest exportTableToPointInTimeRequest);

    /**
     * <p>
     * The <code>GetItem</code> operation returns a set of attributes for the item with the given primary key. If there
     * is no matching item, <code>GetItem</code> does not return any data and there will be no <code>Item</code> element
     * in the response.
     * </p>
     * <p>
     * <code>GetItem</code> provides an eventually consistent read by default. If your application requires a strongly
     * consistent read, set <code>ConsistentRead</code> to <code>true</code>. Although a strongly consistent read might
     * take more time than an eventually consistent read, it always returns the last updated value.
     * </p>
     * 
     * @param getItemRequest
     *        Represents the input of a <code>GetItem</code> operation.
     * @return Result of the GetItem operation returned by the service.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.GetItem
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/GetItem" target="_top">AWS API
     *      Documentation</a>
     */
    GetItemResult getItem(GetItemRequest getItemRequest);

    /**
     * Simplified method form for invoking the GetItem operation.
     *
     * @see #getItem(GetItemRequest)
     */
    GetItemResult getItem(String tableName, java.util.Map<String, AttributeValue> key);

    /**
     * Simplified method form for invoking the GetItem operation.
     *
     * @see #getItem(GetItemRequest)
     */
    GetItemResult getItem(String tableName, java.util.Map<String, AttributeValue> key, Boolean consistentRead);

    /**
     * <p>
     * Imports table data from an S3 bucket.
     * </p>
     * 
     * @param importTableRequest
     * @return Result of the ImportTable operation returned by the service.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ImportConflictException
     *         There was a conflict when importing from the specified S3 source. This can occur when the current import
     *         conflicts with a previous import request that had the same client token.
     * @sample AmazonDynamoDB.ImportTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ImportTable" target="_top">AWS API
     *      Documentation</a>
     */
    ImportTableResult importTable(ImportTableRequest importTableRequest);

    /**
     * <p>
     * List DynamoDB backups that are associated with an Amazon Web Services account and weren't made with Amazon Web
     * Services Backup. To list these backups for a given table, specify <code>TableName</code>.
     * <code>ListBackups</code> returns a paginated list of results with at most 1 MB worth of items in a page. You can
     * also specify a maximum number of entries to be returned in a page.
     * </p>
     * <p>
     * In the request, start time is inclusive, but end time is exclusive. Note that these boundaries are for the time
     * at which the original backup was requested.
     * </p>
     * <p>
     * You can call <code>ListBackups</code> a maximum of five times per second.
     * </p>
     * <p>
     * If you want to retrieve the complete list of backups made with Amazon Web Services Backup, use the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListBackupJobs.html">Amazon Web Services Backup
     * list API.</a>
     * </p>
     * 
     * @param listBackupsRequest
     * @return Result of the ListBackups operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ListBackups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListBackups" target="_top">AWS API
     *      Documentation</a>
     */
    ListBackupsResult listBackups(ListBackupsRequest listBackupsRequest);

    /**
     * <p>
     * Returns a list of ContributorInsightsSummary for a table and all its global secondary indexes.
     * </p>
     * 
     * @param listContributorInsightsRequest
     * @return Result of the ListContributorInsights operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ListContributorInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    ListContributorInsightsResult listContributorInsights(ListContributorInsightsRequest listContributorInsightsRequest);

    /**
     * <p>
     * Lists completed exports within the past 90 days.
     * </p>
     * 
     * @param listExportsRequest
     * @return Result of the ListExports operation returned by the service.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ListExports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    ListExportsResult listExports(ListExportsRequest listExportsRequest);

    /**
     * <p>
     * Lists all global tables that have a replica in the specified Region.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29
     * (Legacy)</a> of global tables. We recommend using <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> when creating new global tables, as it provides greater flexibility, higher efficiency and consumes
     * less write capacity than 2017.11.29 (Legacy). To determine which version you are using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the version</a>. To update existing global tables from version 2017.11.29 (Legacy) to version
     * 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html"> Updating
     * global tables</a>.
     * </p>
     * </important>
     * 
     * @param listGlobalTablesRequest
     * @return Result of the ListGlobalTables operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ListGlobalTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListGlobalTables" target="_top">AWS API
     *      Documentation</a>
     */
    ListGlobalTablesResult listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest);

    /**
     * <p>
     * Lists completed imports within the past 90 days.
     * </p>
     * 
     * @param listImportsRequest
     * @return Result of the ListImports operation returned by the service.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @sample AmazonDynamoDB.ListImports
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    ListImportsResult listImports(ListImportsRequest listImportsRequest);

    /**
     * <p>
     * Returns an array of table names associated with the current account and endpoint. The output from
     * <code>ListTables</code> is paginated, with each page returning a maximum of 100 table names.
     * </p>
     * 
     * @param listTablesRequest
     *        Represents the input of a <code>ListTables</code> operation.
     * @return Result of the ListTables operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ListTables
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    ListTablesResult listTables(ListTablesRequest listTablesRequest);

    /**
     * Simplified method form for invoking the ListTables operation.
     *
     * @see #listTables(ListTablesRequest)
     */
    ListTablesResult listTables();

    /**
     * Simplified method form for invoking the ListTables operation.
     *
     * @see #listTables(ListTablesRequest)
     */
    ListTablesResult listTables(String exclusiveStartTableName);

    /**
     * Simplified method form for invoking the ListTables operation.
     *
     * @see #listTables(ListTablesRequest)
     */
    ListTablesResult listTables(String exclusiveStartTableName, Integer limit);

    /**
     * Simplified method form for invoking the ListTables operation.
     *
     * @see #listTables(ListTablesRequest)
     */
    ListTablesResult listTables(Integer limit);

    /**
     * <p>
     * List all tags on an Amazon DynamoDB resource. You can call ListTagsOfResource up to 10 times per second, per
     * account.
     * </p>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @param listTagsOfResourceRequest
     * @return Result of the ListTagsOfResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.ListTagsOfResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/ListTagsOfResource" target="_top">AWS
     *      API Documentation</a>
     */
    ListTagsOfResourceResult listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest);

    /**
     * <p>
     * Creates a new item, or replaces an old item with a new item. If an item that has the same primary key as the new
     * item already exists in the specified table, the new item completely replaces the existing item. You can perform a
     * conditional put operation (add a new item if one with the specified primary key doesn't exist), or replace an
     * existing item if it has certain attribute values. You can return the item's attribute values in the same
     * operation, using the <code>ReturnValues</code> parameter.
     * </p>
     * <p>
     * When you add an item, the primary key attributes are the only required attributes.
     * </p>
     * <p>
     * Empty String and Binary attribute values are allowed. Attribute values of type String and Binary must have a
     * length greater than zero if the attribute is used as a key attribute for a table or index. Set type attributes
     * cannot be empty.
     * </p>
     * <p>
     * Invalid Requests with empty values will be rejected with a <code>ValidationException</code> exception.
     * </p>
     * <note>
     * <p>
     * To prevent a new item from replacing an existing item, use a conditional expression that contains the
     * <code>attribute_not_exists</code> function with the name of the attribute being used as the partition key for the
     * table. Since every record must contain that attribute, the <code>attribute_not_exists</code> function will only
     * succeed if no matching item exists.
     * </p>
     * </note>
     * <p>
     * For more information about <code>PutItem</code>, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithItems.html">Working with
     * Items</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @param putItemRequest
     *        Represents the input of a <code>PutItem</code> operation.
     * @return Result of the PutItem operation returned by the service.
     * @throws ConditionalCheckFailedException
     *         A condition specified in the operation could not be evaluated.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws ItemCollectionSizeLimitExceededException
     *         An item collection is too large. This exception is only returned for tables that have one or more local
     *         secondary indexes.
     * @throws TransactionConflictException
     *         Operation was rejected because there is an ongoing transaction for the item.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.PutItem
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/PutItem" target="_top">AWS API
     *      Documentation</a>
     */
    PutItemResult putItem(PutItemRequest putItemRequest);

    /**
     * Simplified method form for invoking the PutItem operation.
     *
     * @see #putItem(PutItemRequest)
     */
    PutItemResult putItem(String tableName, java.util.Map<String, AttributeValue> item);

    /**
     * Simplified method form for invoking the PutItem operation.
     *
     * @see #putItem(PutItemRequest)
     */
    PutItemResult putItem(String tableName, java.util.Map<String, AttributeValue> item, String returnValues);

    /**
     * <p>
     * You must provide the name of the partition key attribute and a single value for that attribute.
     * <code>Query</code> returns all items with that partition key value. Optionally, you can provide a sort key
     * attribute and use a comparison operator to refine the search results.
     * </p>
     * <p>
     * Use the <code>KeyConditionExpression</code> parameter to provide a specific value for the partition key. The
     * <code>Query</code> operation will return all of the items from the table or index with that partition key value.
     * You can optionally narrow the scope of the <code>Query</code> operation by specifying a sort key value and a
     * comparison operator in <code>KeyConditionExpression</code>. To further refine the <code>Query</code> results, you
     * can optionally provide a <code>FilterExpression</code>. A <code>FilterExpression</code> determines which items
     * within the results should be returned to you. All of the other results are discarded.
     * </p>
     * <p>
     * A <code>Query</code> operation always returns a result set. If no matching items are found, the result set will
     * be empty. Queries that do not return results consume the minimum number of read capacity units for that type of
     * read operation.
     * </p>
     * <note>
     * <p>
     * DynamoDB calculates the number of read capacity units consumed based on item size, not on the amount of data that
     * is returned to an application. The number of capacity units consumed will be the same whether you request all of
     * the attributes (the default behavior) or just some of them (using a projection expression). The number will also
     * be the same whether or not you use a <code>FilterExpression</code>.
     * </p>
     * </note>
     * <p>
     * <code>Query</code> results are always sorted by the sort key value. If the data type of the sort key is Number,
     * the results are returned in numeric order; otherwise, the results are returned in order of UTF-8 bytes. By
     * default, the sort order is ascending. To reverse the order, set the <code>ScanIndexForward</code> parameter to
     * false.
     * </p>
     * <p>
     * A single <code>Query</code> operation will read up to the maximum number of items set (if using the
     * <code>Limit</code> parameter) or a maximum of 1 MB of data and then apply any filtering to the results using
     * <code>FilterExpression</code>. If <code>LastEvaluatedKey</code> is present in the response, you will need to
     * paginate the result set. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Query.html#Query.Pagination">Paginating
     * the Results</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * <code>FilterExpression</code> is applied after a <code>Query</code> finishes, but before the results are
     * returned. A <code>FilterExpression</code> cannot contain partition key or sort key attributes. You need to
     * specify those attributes in the <code>KeyConditionExpression</code>.
     * </p>
     * <note>
     * <p>
     * A <code>Query</code> operation can return an empty result set and a <code>LastEvaluatedKey</code> if all the
     * items read for the page of results are filtered out.
     * </p>
     * </note>
     * <p>
     * You can query a table, a local secondary index, or a global secondary index. For a query on a table or on a local
     * secondary index, you can set the <code>ConsistentRead</code> parameter to <code>true</code> and obtain a strongly
     * consistent result. Global secondary indexes support eventually consistent reads only, so do not specify
     * <code>ConsistentRead</code> when querying a global secondary index.
     * </p>
     * 
     * @param queryRequest
     *        Represents the input of a <code>Query</code> operation.
     * @return Result of the Query operation returned by the service.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.Query
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Query" target="_top">AWS API
     *      Documentation</a>
     */
    QueryResult query(QueryRequest queryRequest);

    /**
     * <p>
     * Creates a new table from an existing backup. Any number of users can execute up to 50 concurrent restores (any
     * type of restore) in a given account.
     * </p>
     * <p>
     * You can call <code>RestoreTableFromBackup</code> at a maximum rate of 10 times per second.
     * </p>
     * <p>
     * You must manually set up the following on the restored table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto scaling policies
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM policies
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon CloudWatch metrics and alarms
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * Stream settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Time to Live (TTL) settings
     * </p>
     * </li>
     * </ul>
     * 
     * @param restoreTableFromBackupRequest
     * @return Result of the RestoreTableFromBackup operation returned by the service.
     * @throws TableAlreadyExistsException
     *         A target table with the specified name already exists.
     * @throws TableInUseException
     *         A target table with the specified name is either being created or deleted.
     * @throws BackupNotFoundException
     *         Backup not found for the given BackupARN.
     * @throws BackupInUseException
     *         There is another ongoing conflicting backup control plane operation on the table. The backup is either
     *         being created, deleted or restored to a table.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.RestoreTableFromBackup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableFromBackup"
     *      target="_top">AWS API Documentation</a>
     */
    RestoreTableFromBackupResult restoreTableFromBackup(RestoreTableFromBackupRequest restoreTableFromBackupRequest);

    /**
     * <p>
     * Restores the specified table to the specified point in time within <code>EarliestRestorableDateTime</code> and
     * <code>LatestRestorableDateTime</code>. You can restore your table to any point in time during the last 35 days.
     * Any number of users can execute up to 50 concurrent restores (any type of restore) in a given account.
     * </p>
     * <p>
     * When you restore using point in time recovery, DynamoDB restores your table data to the state based on the
     * selected date and time (day:hour:minute:second) to a new table.
     * </p>
     * <p>
     * Along with data, the following are also included on the new restored table using point in time recovery:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Global secondary indexes (GSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Local secondary indexes (LSIs)
     * </p>
     * </li>
     * <li>
     * <p>
     * Provisioned read and write capacity
     * </p>
     * </li>
     * <li>
     * <p>
     * Encryption settings
     * </p>
     * <important>
     * <p>
     * All these settings come from the current settings of the source table at the time of restore.
     * </p>
     * </important></li>
     * </ul>
     * <p>
     * You must manually set up the following on the restored table:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto scaling policies
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM policies
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon CloudWatch metrics and alarms
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags
     * </p>
     * </li>
     * <li>
     * <p>
     * Stream settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Time to Live (TTL) settings
     * </p>
     * </li>
     * <li>
     * <p>
     * Point in time recovery settings
     * </p>
     * </li>
     * </ul>
     * 
     * @param restoreTableToPointInTimeRequest
     * @return Result of the RestoreTableToPointInTime operation returned by the service.
     * @throws TableAlreadyExistsException
     *         A target table with the specified name already exists.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @throws TableInUseException
     *         A target table with the specified name is either being created or deleted.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InvalidRestoreTimeException
     *         An invalid restore time was specified. RestoreDateTime must be between EarliestRestorableDateTime and
     *         LatestRestorableDateTime.
     * @throws PointInTimeRecoveryUnavailableException
     *         Point in time recovery has not yet been enabled for this source table.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.RestoreTableToPointInTime
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/RestoreTableToPointInTime"
     *      target="_top">AWS API Documentation</a>
     */
    RestoreTableToPointInTimeResult restoreTableToPointInTime(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest);

    /**
     * <p>
     * The <code>Scan</code> operation returns one or more items and item attributes by accessing every item in a table
     * or a secondary index. To have DynamoDB return fewer items, you can provide a <code>FilterExpression</code>
     * operation.
     * </p>
     * <p>
     * If the total size of scanned items exceeds the maximum dataset size limit of 1 MB, the scan completes and results
     * are returned to the user. The <code>LastEvaluatedKey</code> value is also returned and the requestor can use the
     * <code>LastEvaluatedKey</code> to continue the scan in a subsequent operation. Each scan response also includes
     * number of items that were scanned (ScannedCount) as part of the request. If using a <code>FilterExpression</code>
     * , a scan result can result in no items meeting the criteria and the <code>Count</code> will result in zero. If
     * you did not use a <code>FilterExpression</code> in the scan request, then <code>Count</code> is the same as
     * <code>ScannedCount</code>.
     * </p>
     * <note>
     * <p>
     * <code>Count</code> and <code>ScannedCount</code> only return the count of items specific to a single scan request
     * and, unless the table is less than 1MB, do not represent the total number of items in the table.
     * </p>
     * </note>
     * <p>
     * A single <code>Scan</code> operation first reads up to the maximum number of items set (if using the
     * <code>Limit</code> parameter) or a maximum of 1 MB of data and then applies any filtering to the results if a
     * <code>FilterExpression</code> is provided. If <code>LastEvaluatedKey</code> is present in the response,
     * pagination is required to complete the full table scan. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.Pagination">Paginating the
     * Results</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * <code>Scan</code> operations proceed sequentially; however, for faster performance on a large table or secondary
     * index, applications can request a parallel <code>Scan</code> operation by providing the <code>Segment</code> and
     * <code>TotalSegments</code> parameters. For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Scan.html#Scan.ParallelScan">Parallel
     * Scan</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * <p>
     * By default, a <code>Scan</code> uses eventually consistent reads when accessing the items in a table. Therefore,
     * the results from an eventually consistent <code>Scan</code> may not include the latest item changes at the time
     * the scan iterates through each item in the table. If you require a strongly consistent read of each item as the
     * scan iterates through the items in the table, you can set the <code>ConsistentRead</code> parameter to true.
     * Strong consistency only relates to the consistency of the read at the item level.
     * </p>
     * <note>
     * <p>
     * DynamoDB does not provide snapshot isolation for a scan operation when the <code>ConsistentRead</code> parameter
     * is set to true. Thus, a DynamoDB scan operation does not guarantee that all reads in a scan see a consistent
     * snapshot of the table when the scan operation was requested.
     * </p>
     * </note>
     * 
     * @param scanRequest
     *        Represents the input of a <code>Scan</code> operation.
     * @return Result of the Scan operation returned by the service.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.Scan
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/Scan" target="_top">AWS API
     *      Documentation</a>
     */
    ScanResult scan(ScanRequest scanRequest);

    /**
     * Simplified method form for invoking the Scan operation.
     *
     * @see #scan(ScanRequest)
     */
    ScanResult scan(String tableName, java.util.List<String> attributesToGet);

    /**
     * Simplified method form for invoking the Scan operation.
     *
     * @see #scan(ScanRequest)
     */
    ScanResult scan(String tableName, java.util.Map<String, Condition> scanFilter);

    /**
     * Simplified method form for invoking the Scan operation.
     *
     * @see #scan(ScanRequest)
     */
    ScanResult scan(String tableName, java.util.List<String> attributesToGet, java.util.Map<String, Condition> scanFilter);

    /**
     * <p>
     * Associate a set of tags with an Amazon DynamoDB resource. You can then activate these user-defined tags so that
     * they appear on the Billing and Cost Management console for cost allocation tracking. You can call TagResource up
     * to five times per second, per account.
     * </p>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @sample AmazonDynamoDB.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    TagResourceResult tagResource(TagResourceRequest tagResourceRequest);

    /**
     * <p>
     * <code>TransactGetItems</code> is a synchronous operation that atomically retrieves multiple items from one or
     * more tables (but not from indexes) in a single account and Region. A <code>TransactGetItems</code> call can
     * contain up to 100 <code>TransactGetItem</code> objects, each of which contains a <code>Get</code> structure that
     * specifies an item to retrieve from a table in the account and Region. A call to <code>TransactGetItems</code>
     * cannot retrieve items from tables in more than one Amazon Web Services account or Region. The aggregate size of
     * the items in the transaction cannot exceed 4 MB.
     * </p>
     * <p>
     * DynamoDB rejects the entire <code>TransactGetItems</code> request if any of the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A conflicting operation is in the process of updating an item to be read.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is insufficient provisioned capacity for the transaction to be completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is a user error, such as an invalid data format.
     * </p>
     * </li>
     * <li>
     * <p>
     * The aggregate size of the items in the transaction exceeded 4 MB.
     * </p>
     * </li>
     * </ul>
     * 
     * @param transactGetItemsRequest
     * @return Result of the TransactGetItems operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws TransactionCanceledException
     *         The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property.
     *         This property is not set for other languages. Transaction cancellation reasons are ordered in the order
     *         of requested items, if an item has no error it will have <code>None</code> code and <code>Null</code>
     *         message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.TransactGetItems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactGetItems" target="_top">AWS API
     *      Documentation</a>
     */
    TransactGetItemsResult transactGetItems(TransactGetItemsRequest transactGetItemsRequest);

    /**
     * <p>
     * <code>TransactWriteItems</code> is a synchronous write operation that groups up to 100 action requests. These
     * actions can target items in different tables, but not in different Amazon Web Services accounts or Regions, and
     * no two actions can target the same item. For example, you cannot both <code>ConditionCheck</code> and
     * <code>Update</code> the same item. The aggregate size of the items in the transaction cannot exceed 4 MB.
     * </p>
     * <p>
     * The actions are completed atomically so that either all of them succeed, or all of them fail. They are defined by
     * the following objects:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Put</code>  —   Initiates a <code>PutItem</code> operation to write a new item. This structure specifies
     * the primary key of the item to be written, the name of the table to write it in, an optional condition expression
     * that must be satisfied for the write to succeed, a list of the item's attributes, and a field indicating whether
     * to retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Update</code>  —   Initiates an <code>UpdateItem</code> operation to update an existing item. This
     * structure specifies the primary key of the item to be updated, the name of the table where it resides, an
     * optional condition expression that must be satisfied for the update to succeed, an expression that defines one or
     * more attributes to be updated, and a field indicating whether to retrieve the item's attributes if the condition
     * is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Delete</code>  —   Initiates a <code>DeleteItem</code> operation to delete an existing item. This structure
     * specifies the primary key of the item to be deleted, the name of the table where it resides, an optional
     * condition expression that must be satisfied for the deletion to succeed, and a field indicating whether to
     * retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ConditionCheck</code>  —   Applies a condition to an item that is not being modified by the transaction.
     * This structure specifies the primary key of the item to be checked, the name of the table where it resides, a
     * condition expression that must be satisfied for the transaction to succeed, and a field indicating whether to
     * retrieve the item's attributes if the condition is not met.
     * </p>
     * </li>
     * </ul>
     * <p>
     * DynamoDB rejects the entire <code>TransactWriteItems</code> request if any of the following is true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A condition in one of the condition expressions is not met.
     * </p>
     * </li>
     * <li>
     * <p>
     * An ongoing operation is in the process of updating the same item.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is insufficient provisioned capacity for the transaction to be completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * An item size becomes too large (bigger than 400 KB), a local secondary index (LSI) becomes too large, or a
     * similar validation error occurs because of changes made by the transaction.
     * </p>
     * </li>
     * <li>
     * <p>
     * The aggregate size of the items in the transaction exceeds 4 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * There is a user error, such as an invalid data format.
     * </p>
     * </li>
     * </ul>
     * 
     * @param transactWriteItemsRequest
     * @return Result of the TransactWriteItems operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws TransactionCanceledException
     *         The entire transaction request was canceled.</p>
     *         <p>
     *         DynamoDB cancels a <code>TransactWriteItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A condition in one of the condition expressions is not met.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactWriteItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         More than one action in the <code>TransactWriteItems</code> operation targets the same item.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An item size becomes too large (larger than 400 KB), or a local secondary index (LSI) becomes too large,
     *         or a similar validation error occurs because of changes made by the transaction.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactWriteItems</code> operation that conflicts with a concurrent
     *         <code>TransactWriteItems</code> request. In this case the <code>TransactWriteItems</code> operation fails
     *         with a <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DynamoDB cancels a <code>TransactGetItems</code> request under the following circumstances:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There is an ongoing <code>TransactGetItems</code> operation that conflicts with a concurrent
     *         <code>PutItem</code>, <code>UpdateItem</code>, <code>DeleteItem</code> or <code>TransactWriteItems</code>
     *         request. In this case the <code>TransactGetItems</code> operation fails with a
     *         <code>TransactionCanceledException</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A table in the <code>TransactGetItems</code> request is in a different account or region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is insufficient provisioned capacity for the transaction to be completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         There is a user error, such as an invalid data format.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If using Java, DynamoDB lists the cancellation reasons on the <code>CancellationReasons</code> property.
     *         This property is not set for other languages. Transaction cancellation reasons are ordered in the order
     *         of requested items, if an item has no error it will have <code>None</code> code and <code>Null</code>
     *         message.
     *         </p>
     *         </note>
     *         <p>
     *         Cancellation reason codes and possible error messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         No Errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>None</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: <code>null</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Conditional Check Failed:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ConditionalCheckFailed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: The conditional request failed.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Item Collection Size Limit Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ItemCollectionSizeLimitExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Collection size exceeded.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Transaction Conflict:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>TransactionConflict</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Message: Transaction is ongoing for the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Provisioned Throughput Exceeded:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for the table was exceeded. Consider increasing your
     *         provisioning level with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This Message is received when provisioned throughput is exceeded is on a provisioned DynamoDB table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         The level of configured provisioned throughput for one or more global secondary indexes of the table was
     *         exceeded. Consider increasing your provisioning level for the under-provisioned global secondary indexes
     *         with the UpdateTable API.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when provisioned throughput is exceeded is on a provisioned GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Throttling Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ThrottlingError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity of your table or index. DynamoDB is automatically scaling your
     *         table or index so please try again shortly. If exceptions persist, check if you have a hot key:
     *         https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/bp-partition-key-design.html.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand table as DynamoDB is automatically
     *         scaling the table.
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         Throughput exceeds the current capacity for one or more global secondary indexes. DynamoDB is
     *         automatically scaling your index so please try again shortly.
     *         </p>
     *         <note>
     *         <p>
     *         This message is returned when writes get throttled on an On-Demand GSI as DynamoDB is automatically
     *         scaling the GSI.
     *         </p>
     *         </note></li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         Validation Error:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Code: <code>ValidationError</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Messages:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         One or more parameter values were invalid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key beyond allowed size limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The update expression attempted to update the secondary index key to unsupported type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An operand in the update expression has an incorrect data type.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Item size to update has exceeded the maximum allowed size.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Number overflow. Attempting to store a number with magnitude larger than supported range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type mismatch for attribute to update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Nesting Levels have exceeded supported limits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The document path provided in the update expression is invalid for update.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The provided expression refers to an attribute that does not exist in the item.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         </ul>
     *         </li>
     * @throws TransactionInProgressException
     *         The transaction with the given request token is already in progress.</p>
     *         <p>
     *         Recommended Settings
     *         </p>
     *         <note>
     *         <p>
     *         This is a general recommendation for handling the <code>TransactionInProgressException</code>. These
     *         settings help ensure that the client retries will trigger completion of the ongoing <code>
     *         TransactWriteItems</code> request.
     *         </p>
     *         </note>
     *         <ul>
     *         <li>
     *         <p>
     *         Set <code>clientExecutionTimeout</code> to a value that allows at least one retry to be processed after 5
     *         seconds have elapsed since the first attempt for the <code>TransactWriteItems</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set <code>socketTimeout</code> to a value a little lower than the <code>requestTimeout</code> setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requestTimeout</code> should be set based on the time taken for the individual retries of a single
     *         HTTP request for your use case, but setting it to 1 second or higher should work well to reduce chances
     *         of retries and <code>TransactionInProgressException</code> errors.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Use exponential backoff when retrying and tune backoff if needed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Assuming <a href=
     *         "https://github.com/aws/aws-sdk-java/blob/fd409dee8ae23fb8953e0bb4dbde65536a7e0514/aws-java-sdk-core/src/main/java/com/amazonaws/retry/PredefinedRetryPolicies.java#L97"
     *         >default retry policy</a>, example timeout settings based on the guidelines above are as follows:
     *         </p>
     *         <p>
     *         Example timeline:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         0-1000 first attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1000-1500 first sleep/delay (default retry policy uses 500 ms as base delay for 4xx errors)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1500-2500 second attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2500-3500 second sleep/delay (500 * 2, exponential backoff)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         3500-4500 third attempt
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4500-6500 third sleep/delay (500 * 2^2)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         6500-7500 fourth attempt (this can trigger inline recovery since 5 seconds have elapsed since the first
     *         attempt reached TC)
     *         </p>
     *         </li>
     * @throws IdempotentParameterMismatchException
     *         DynamoDB rejected the request because you retried a request with a different payload but with an
     *         idempotent token that was already used.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.TransactWriteItems
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/TransactWriteItems" target="_top">AWS
     *      API Documentation</a>
     */
    TransactWriteItemsResult transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest);

    /**
     * <p>
     * Removes the association of tags from an Amazon DynamoDB resource. You can call <code>UntagResource</code> up to
     * five times per second, per account.
     * </p>
     * <p>
     * For an overview on tagging DynamoDB resources, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html">Tagging for DynamoDB</a> in
     * the <i>Amazon DynamoDB Developer Guide</i>.
     * </p>
     * 
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @sample AmazonDynamoDB.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    UntagResourceResult untagResource(UntagResourceRequest untagResourceRequest);

    /**
     * <p>
     * <code>UpdateContinuousBackups</code> enables or disables point in time recovery for the specified table. A
     * successful <code>UpdateContinuousBackups</code> call returns the current
     * <code>ContinuousBackupsDescription</code>. Continuous backups are <code>ENABLED</code> on all tables at table
     * creation. If point in time recovery is enabled, <code>PointInTimeRecoveryStatus</code> will be set to ENABLED.
     * </p>
     * <p>
     * Once continuous backups and point in time recovery are enabled, you can restore to any point in time within
     * <code>EarliestRestorableDateTime</code> and <code>LatestRestorableDateTime</code>.
     * </p>
     * <p>
     * <code>LatestRestorableDateTime</code> is typically 5 minutes before the current time. You can restore your table
     * to any point in time during the last 35 days.
     * </p>
     * 
     * @param updateContinuousBackupsRequest
     * @return Result of the UpdateContinuousBackups operation returned by the service.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @throws ContinuousBackupsUnavailableException
     *         Backups have not yet been enabled for this table.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateContinuousBackups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContinuousBackups"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateContinuousBackupsResult updateContinuousBackups(UpdateContinuousBackupsRequest updateContinuousBackupsRequest);

    /**
     * <p>
     * Updates the status for contributor insights for a specific table or index. CloudWatch Contributor Insights for
     * DynamoDB graphs display the partition key and (if applicable) sort key of frequently accessed items and
     * frequently throttled items in plaintext. If you require the use of Amazon Web Services Key Management Service
     * (KMS) to encrypt this table’s partition key and sort key data with an Amazon Web Services managed key or customer
     * managed key, you should not enable CloudWatch Contributor Insights for DynamoDB for this table.
     * </p>
     * 
     * @param updateContributorInsightsRequest
     * @return Result of the UpdateContributorInsights operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateContributorInsights
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateContributorInsights"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateContributorInsightsResult updateContributorInsights(UpdateContributorInsightsRequest updateContributorInsightsRequest);

    /**
     * <p>
     * Adds or removes replicas in the specified global table. The global table must already exist to be able to use
     * this operation. Any replica to be added must be empty, have the same name as the global table, have the same key
     * schema, have DynamoDB Streams enabled, and have the same provisioned and maximum write capacity units.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29
     * (Legacy)</a> of global tables. We recommend using <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> when creating new global tables, as it provides greater flexibility, higher efficiency and consumes
     * less write capacity than 2017.11.29 (Legacy). To determine which version you are using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the version</a>. To update existing global tables from version 2017.11.29 (Legacy) to version
     * 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html"> Updating
     * global tables</a>.
     * </p>
     * </important> <note>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version
     * 2017.11.29</a> of global tables. If you are using global tables <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version
     * 2019.11.21</a> you can use <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/APIReference/API_DescribeTable.html">DescribeTable</a>
     * instead.
     * </p>
     * <p>
     * Although you can use <code>UpdateGlobalTable</code> to add replicas and remove replicas in a single request, for
     * simplicity we recommend that you issue separate requests for adding or removing replicas.
     * </p>
     * </note>
     * <p>
     * If global secondary indexes are specified, then the following conditions must also be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The global secondary indexes must have the same name.
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same hash key and sort key (if present).
     * </p>
     * </li>
     * <li>
     * <p>
     * The global secondary indexes must have the same provisioned and maximum write capacity units.
     * </p>
     * </li>
     * </ul>
     * 
     * @param updateGlobalTableRequest
     * @return Result of the UpdateGlobalTable operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws GlobalTableNotFoundException
     *         The specified global table does not exist.
     * @throws ReplicaAlreadyExistsException
     *         The specified replica is already part of the global table.
     * @throws ReplicaNotFoundException
     *         The specified replica is no longer part of the global table.
     * @throws TableNotFoundException
     *         A source table with the name <code>TableName</code> does not currently exist within the subscriber's
     *         account or the subscriber is operating in the wrong Amazon Web Services Region.
     * @sample AmazonDynamoDB.UpdateGlobalTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTable" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateGlobalTableResult updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest);

    /**
     * <p>
     * Updates settings for a global table.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V1.html">Version 2017.11.29
     * (Legacy)</a> of global tables. We recommend using <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> when creating new global tables, as it provides greater flexibility, higher efficiency and consumes
     * less write capacity than 2017.11.29 (Legacy). To determine which version you are using, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.DetermineVersion.html"
     * >Determining the version</a>. To update existing global tables from version 2017.11.29 (Legacy) to version
     * 2019.11.21 (Current), see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/V2globaltables_upgrade.html"> Updating
     * global tables</a>.
     * </p>
     * </important>
     * 
     * @param updateGlobalTableSettingsRequest
     * @return Result of the UpdateGlobalTableSettings operation returned by the service.
     * @throws GlobalTableNotFoundException
     *         The specified global table does not exist.
     * @throws ReplicaNotFoundException
     *         The specified replica is no longer part of the global table.
     * @throws IndexNotFoundException
     *         The operation tried to access a nonexistent index.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateGlobalTableSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateGlobalTableSettings"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateGlobalTableSettingsResult updateGlobalTableSettings(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest);

    /**
     * <p>
     * Edits an existing item's attributes, or adds a new item to the table if it does not already exist. You can put,
     * delete, or add attribute values. You can also perform a conditional update on an existing item (insert a new
     * attribute name-value pair if it doesn't exist, or replace an existing name-value pair if it has certain expected
     * attribute values).
     * </p>
     * <p>
     * You can also return the item's attribute values in the same <code>UpdateItem</code> operation using the
     * <code>ReturnValues</code> parameter.
     * </p>
     * 
     * @param updateItemRequest
     *        Represents the input of an <code>UpdateItem</code> operation.
     * @return Result of the UpdateItem operation returned by the service.
     * @throws ConditionalCheckFailedException
     *         A condition specified in the operation could not be evaluated.
     * @throws ProvisionedThroughputExceededException
     *         Your request rate is too high. The Amazon Web Services SDKs for DynamoDB automatically retry requests
     *         that receive this exception. Your request is eventually successful, unless your retry queue is too large
     *         to finish. Reduce the frequency of requests and use exponential backoff. For more information, go to <a
     *         href=
     *         "https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Programming.Errors.html#Programming.Errors.RetryAndBackoff"
     *         >Error Retries and Exponential Backoff</a> in the <i>Amazon DynamoDB Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws ItemCollectionSizeLimitExceededException
     *         An item collection is too large. This exception is only returned for tables that have one or more local
     *         secondary indexes.
     * @throws TransactionConflictException
     *         Operation was rejected because there is an ongoing transaction for the item.
     * @throws RequestLimitExceededException
     *         Throughput exceeds the current throughput quota for your account. Please contact <a
     *         href="https://aws.amazon.com/support">Amazon Web Services Support</a> to request a quota increase.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateItem
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateItem" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateItemResult updateItem(UpdateItemRequest updateItemRequest);

    /**
     * Simplified method form for invoking the UpdateItem operation.
     *
     * @see #updateItem(UpdateItemRequest)
     */
    UpdateItemResult updateItem(String tableName, java.util.Map<String, AttributeValue> key, java.util.Map<String, AttributeValueUpdate> attributeUpdates);

    /**
     * Simplified method form for invoking the UpdateItem operation.
     *
     * @see #updateItem(UpdateItemRequest)
     */
    UpdateItemResult updateItem(String tableName, java.util.Map<String, AttributeValue> key, java.util.Map<String, AttributeValueUpdate> attributeUpdates,
            String returnValues);

    /**
     * <p>
     * The command to update the Kinesis stream destination.
     * </p>
     * 
     * @param updateKinesisStreamingDestinationRequest
     * @return Result of the UpdateKinesisStreamingDestination operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @sample AmazonDynamoDB.UpdateKinesisStreamingDestination
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateKinesisStreamingDestination"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateKinesisStreamingDestinationResult updateKinesisStreamingDestination(UpdateKinesisStreamingDestinationRequest updateKinesisStreamingDestinationRequest);

    /**
     * <p>
     * Modifies the provisioned throughput settings, global secondary indexes, or DynamoDB Streams settings for a given
     * table.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> of global tables.
     * </p>
     * </important>
     * <p>
     * You can only perform one of the following operations at once:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Modify the provisioned throughput settings of the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove a global secondary index from the table.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create a new global secondary index on the table. After the index begins backfilling, you can use
     * <code>UpdateTable</code> to perform other operations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>UpdateTable</code> is an asynchronous operation; while it is executing, the table status changes from
     * <code>ACTIVE</code> to <code>UPDATING</code>. While it is <code>UPDATING</code>, you cannot issue another
     * <code>UpdateTable</code> request. When the table returns to the <code>ACTIVE</code> state, the
     * <code>UpdateTable</code> operation is complete.
     * </p>
     * 
     * @param updateTableRequest
     *        Represents the input of an <code>UpdateTable</code> operation.
     * @return Result of the UpdateTable operation returned by the service.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateTable
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTable" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateTableResult updateTable(UpdateTableRequest updateTableRequest);

    /**
     * Simplified method form for invoking the UpdateTable operation.
     *
     * @see #updateTable(UpdateTableRequest)
     */
    UpdateTableResult updateTable(String tableName, ProvisionedThroughput provisionedThroughput);

    /**
     * <p>
     * Updates auto scaling settings on your global tables at once.
     * </p>
     * <important>
     * <p>
     * This operation only applies to <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/globaltables.V2.html">Version 2019.11.21
     * (Current)</a> of global tables.
     * </p>
     * </important>
     * 
     * @param updateTableReplicaAutoScalingRequest
     * @return Result of the UpdateTableReplicaAutoScaling operation returned by the service.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateTableReplicaAutoScaling
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTableReplicaAutoScaling"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateTableReplicaAutoScalingResult updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest);

    /**
     * <p>
     * The <code>UpdateTimeToLive</code> method enables or disables Time to Live (TTL) for the specified table. A
     * successful <code>UpdateTimeToLive</code> call returns the current <code>TimeToLiveSpecification</code>. It can
     * take up to one hour for the change to fully process. Any additional <code>UpdateTimeToLive</code> calls for the
     * same table during this one hour duration result in a <code>ValidationException</code>.
     * </p>
     * <p>
     * TTL compares the current time in epoch time format to the time stored in the TTL attribute of an item. If the
     * epoch time value stored in the attribute is less than the current time, the item is marked as expired and
     * subsequently deleted.
     * </p>
     * <note>
     * <p>
     * The epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.
     * </p>
     * </note>
     * <p>
     * DynamoDB deletes expired items on a best-effort basis to ensure availability of throughput for other data
     * operations.
     * </p>
     * <important>
     * <p>
     * DynamoDB typically deletes expired items within two days of expiration. The exact duration within which an item
     * gets deleted after expiration is specific to the nature of the workload. Items that have expired and not been
     * deleted will still show up in reads, queries, and scans.
     * </p>
     * </important>
     * <p>
     * As items are deleted, they are removed from any local secondary index and global secondary index immediately in
     * the same eventually consistent way as a standard delete operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/TTL.html">Time To Live</a> in the Amazon
     * DynamoDB Developer Guide.
     * </p>
     * 
     * @param updateTimeToLiveRequest
     *        Represents the input of an <code>UpdateTimeToLive</code> operation.
     * @return Result of the UpdateTimeToLive operation returned by the service.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to recreate an
     *         existing table, or tried to delete a table currently in the <code>CREATING</code> state.
     * @throws ResourceNotFoundException
     *         The operation tried to access a nonexistent table or index. The resource might not be specified
     *         correctly, or its status might not be <code>ACTIVE</code>.
     * @throws LimitExceededException
     *         There is no limit to the number of daily on-demand backups that can be taken. </p>
     *         <p>
     *         For most purposes, up to 500 simultaneous table operations are allowed per account. These operations
     *         include <code>CreateTable</code>, <code>UpdateTable</code>, <code>DeleteTable</code>,
     *         <code>UpdateTimeToLive</code>, <code>RestoreTableFromBackup</code>, and
     *         <code>RestoreTableToPointInTime</code>.
     *         </p>
     *         <p>
     *         When you are creating a table with one or more secondary indexes, you can have up to 250 such requests
     *         running at a time. However, if the table or index specifications are complex, then DynamoDB might
     *         temporarily reduce the number of concurrent operations.
     *         </p>
     *         <p>
     *         When importing into DynamoDB, up to 50 simultaneous import table operations are allowed per account.
     *         </p>
     *         <p>
     *         There is a soft account quota of 2,500 tables.
     *         </p>
     *         <p>
     *         GetRecords was called with a value of more than 1000 for the limit request parameter.
     *         </p>
     *         <p>
     *         More than 2 processes are reading from the same streams shard at the same time. Exceeding this limit may
     *         result in request throttling.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @sample AmazonDynamoDB.UpdateTimeToLive
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/dynamodb-2012-08-10/UpdateTimeToLive" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateTimeToLiveResult updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest);

    /**
     * Shuts down this client object, releasing any resources that might be held open. This is an optional method, and
     * callers are not expected to call it, but can if they want to explicitly release any open resources. Once a client
     * has been shutdown, it should not be used to make any more requests.
     */
    void shutdown();

    /**
     * Returns additional metadata for a previously executed successful request, typically used for debugging issues
     * where a service isn't acting as expected. This data isn't considered part of the result data returned by an
     * operation, so it's available through this separate, diagnostic interface.
     * <p>
     * Response metadata is only cached for a limited period of time, so if you need to access this extra diagnostic
     * information for an executed request, you should use this method to retrieve it as soon as possible after
     * executing a request.
     *
     * @param request
     *        The originally executed request.
     *
     * @return The response metadata for the specified request, or null if none is available.
     */
    ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request);

    AmazonDynamoDBWaiters waiters();

}
