/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.xspec;

import com.amazonaws.annotation.Beta;
import com.amazonaws.services.dynamodbv2.xspec.B;
import com.amazonaws.services.dynamodbv2.xspec.BOOL;
import com.amazonaws.services.dynamodbv2.xspec.BS;
import com.amazonaws.services.dynamodbv2.xspec.Condition;
import com.amazonaws.services.dynamodbv2.xspec.DeleteItemExpressionSpec;
import com.amazonaws.services.dynamodbv2.xspec.FunctionCondition;
import com.amazonaws.services.dynamodbv2.xspec.GetItemExpressionSpec;
import com.amazonaws.services.dynamodbv2.xspec.IfNotExistsFunction;
import com.amazonaws.services.dynamodbv2.xspec.L;
import com.amazonaws.services.dynamodbv2.xspec.ListAppendFunction;
import com.amazonaws.services.dynamodbv2.xspec.ListLiteralOperand;
import com.amazonaws.services.dynamodbv2.xspec.LiteralOperand;
import com.amazonaws.services.dynamodbv2.xspec.M;
import com.amazonaws.services.dynamodbv2.xspec.N;
import com.amazonaws.services.dynamodbv2.xspec.NS;
import com.amazonaws.services.dynamodbv2.xspec.NULL;
import com.amazonaws.services.dynamodbv2.xspec.NegationCondition;
import com.amazonaws.services.dynamodbv2.xspec.Operand;
import com.amazonaws.services.dynamodbv2.xspec.ParenthesizedCondition;
import com.amazonaws.services.dynamodbv2.xspec.PathOperand;
import com.amazonaws.services.dynamodbv2.xspec.QueryExpressionSpec;
import com.amazonaws.services.dynamodbv2.xspec.RemoveAction;
import com.amazonaws.services.dynamodbv2.xspec.S;
import com.amazonaws.services.dynamodbv2.xspec.SS;
import com.amazonaws.services.dynamodbv2.xspec.ScanExpressionSpec;
import com.amazonaws.services.dynamodbv2.xspec.SubstitutionContext;
import com.amazonaws.services.dynamodbv2.xspec.UpdateAction;
import com.amazonaws.services.dynamodbv2.xspec.UpdateItemExpressionSpec;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Beta
public final class ExpressionSpecBuilder
implements Cloneable {
    private final Map<String, List<UpdateAction>> updates;
    private Condition keyCondition;
    private Condition condition;
    private final Set<PathOperand> projections;

    public ExpressionSpecBuilder() {
        this.updates = new LinkedHashMap<String, List<UpdateAction>>();
        this.projections = new LinkedHashSet<PathOperand>();
    }

    private ExpressionSpecBuilder(ExpressionSpecBuilder from) {
        this.updates = new LinkedHashMap<String, List<UpdateAction>>(from.updates);
        this.projections = new LinkedHashSet<PathOperand>(from.projections);
        this.keyCondition = from.keyCondition;
        this.condition = from.condition;
    }

    public ExpressionSpecBuilder addUpdate(UpdateAction updateAction) {
        String operator = updateAction.getOperator();
        List<UpdateAction> list = this.updates.get(operator);
        if (list == null) {
            list = new LinkedList<UpdateAction>();
            this.updates.put(operator, list);
        }
        list.add(updateAction);
        return this;
    }

    public ExpressionSpecBuilder withCondition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public ExpressionSpecBuilder withKeyCondition(Condition keyCondition) {
        this.keyCondition = keyCondition;
        return this;
    }

    public ExpressionSpecBuilder addProjection(String path) {
        this.projections.add(new PathOperand(path));
        return this;
    }

    public ExpressionSpecBuilder addProjections(String ... paths) {
        for (String path : paths) {
            this.addProjection(path);
        }
        return this;
    }

    public DeleteItemExpressionSpec buildForDeleteItem() {
        return new DeleteItemExpressionSpec(this);
    }

    public GetItemExpressionSpec buildForGetItem() {
        return new GetItemExpressionSpec(this);
    }

    public QueryExpressionSpec buildForQuery() {
        return new QueryExpressionSpec(this);
    }

    public ScanExpressionSpec buildForScan() {
        return new ScanExpressionSpec(this);
    }

    public UpdateItemExpressionSpec buildForUpdate() {
        return new UpdateItemExpressionSpec(this);
    }

    String buildUpdateExpression(SubstitutionContext context) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<UpdateAction>> e : this.updates.entrySet()) {
            boolean firstOfUpdateType = true;
            for (UpdateAction expr : e.getValue()) {
                if (firstOfUpdateType) {
                    firstOfUpdateType = false;
                    String operator = e.getKey();
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(operator).append(" ");
                } else {
                    sb.append(", ");
                }
                sb.append(expr.asSubstituted(context));
            }
        }
        return sb.toString();
    }

    String buildProjectionExpression(SubstitutionContext context) {
        if (this.projections.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (PathOperand projection : this.projections) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(projection.asSubstituted(context));
        }
        return sb.toString();
    }

    String buildConditionExpression(SubstitutionContext context) {
        return this.condition == null ? null : this.condition.asSubstituted(context);
    }

    String buildKeyConditionExpression(SubstitutionContext context) {
        return this.keyCondition == null ? null : this.keyCondition.asSubstituted(context);
    }

    public ExpressionSpecBuilder clone() {
        return new ExpressionSpecBuilder(this);
    }

    static <T> IfNotExistsFunction<T> if_not_exists(PathOperand pathOperand, Operand operand) {
        return new IfNotExistsFunction(pathOperand, operand);
    }

    public static IfNotExistsFunction<N> if_not_exists(String path, Number defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<B> if_not_exists(String path, byte[] defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<B> if_not_exists(String path, ByteBuffer defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<BOOL> if_not_exists(String path, boolean defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<BS> if_not_exists(String path, byte[] ... defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<BS> if_not_exists(String path, ByteBuffer ... defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<L> if_not_exists(String path, List<?> defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<M> if_not_exists(String path, Map<String, ?> defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<NS> if_not_exists(String path, Number ... defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<S> if_not_exists(String path, String defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static IfNotExistsFunction<SS> if_not_exists(String path, String ... defaultValue) {
        return ExpressionSpecBuilder.if_not_exists(new PathOperand(path), new LiteralOperand(defaultValue));
    }

    public static <T> ListAppendFunction list_append(String path, T value) {
        LinkedList<T> list = new LinkedList<T>();
        list.add(value);
        return ExpressionSpecBuilder.list_append(path, list);
    }

    public static <T> ListAppendFunction list_append(String path, List<? extends T> value) {
        return new ListAppendFunction(ExpressionSpecBuilder.L(path), new ListLiteralOperand(new LinkedList<T>(value)));
    }

    public static <T> ListAppendFunction list_append(List<? extends T> value, String path) {
        return new ListAppendFunction(new ListLiteralOperand(new LinkedList<T>(value)), ExpressionSpecBuilder.L(path));
    }

    public static <T> FunctionCondition attribute_exists(PathOperand pathOperand) {
        return new FunctionCondition("attribute_exists", pathOperand);
    }

    public static <T> FunctionCondition attribute_exists(String path) {
        return ExpressionSpecBuilder.attribute_exists(new PathOperand(path));
    }

    public static FunctionCondition attribute_not_exists(PathOperand pathOperand) {
        return new FunctionCondition("attribute_not_exists", pathOperand);
    }

    public static FunctionCondition attribute_not_exists(String path) {
        return ExpressionSpecBuilder.attribute_not_exists(new PathOperand(path));
    }

    public static <T> NegationCondition not(Condition cond) {
        return new NegationCondition(cond);
    }

    public static RemoveAction remove(String path) {
        return new PathOperand(path).remove();
    }

    public static PathOperand attribute(String path) {
        return new PathOperand(path);
    }

    public static BOOL BOOL(String path) {
        return new BOOL(path);
    }

    public static NULL NULL(String path) {
        return new NULL(path);
    }

    public static B B(String path) {
        return new B(path);
    }

    public static N N(String path) {
        return new N(path);
    }

    public static S S(String path) {
        return new S(path);
    }

    public static BS BS(String path) {
        return new BS(path);
    }

    public static NS NS(String path) {
        return new NS(path);
    }

    public static SS SS(String path) {
        return new SS(path);
    }

    public static L L(String path) {
        return new L(path);
    }

    public static M M(String path) {
        return new M(path);
    }

    public static <T> ParenthesizedCondition parenthesize(Condition condition) {
        return ParenthesizedCondition.getInstance(condition);
    }

    public static <T> ParenthesizedCondition _(Condition condition) {
        return ExpressionSpecBuilder.parenthesize(condition);
    }
}

