/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.AllocationState;
import com.amazonaws.services.ec2.model.AutoPlacement;
import com.amazonaws.services.ec2.model.AvailableCapacity;
import com.amazonaws.services.ec2.model.HostInstance;
import com.amazonaws.services.ec2.model.HostProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Host
implements Serializable,
Cloneable {
    private String hostId;
    private String autoPlacement;
    private String hostReservationId;
    private String clientToken;
    private HostProperties hostProperties;
    private String state;
    private String availabilityZone;
    private ListWithAutoConstructFlag<HostInstance> instances;
    private AvailableCapacity availableCapacity;

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public Host withHostId(String hostId) {
        this.hostId = hostId;
        return this;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public Host withAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
    }

    public Host withAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
        return this;
    }

    public String getHostReservationId() {
        return this.hostReservationId;
    }

    public void setHostReservationId(String hostReservationId) {
        this.hostReservationId = hostReservationId;
    }

    public Host withHostReservationId(String hostReservationId) {
        this.hostReservationId = hostReservationId;
        return this;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public Host withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public HostProperties getHostProperties() {
        return this.hostProperties;
    }

    public void setHostProperties(HostProperties hostProperties) {
        this.hostProperties = hostProperties;
    }

    public Host withHostProperties(HostProperties hostProperties) {
        this.hostProperties = hostProperties;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Host withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(AllocationState state) {
        this.state = state.toString();
    }

    public Host withState(AllocationState state) {
        this.state = state.toString();
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Host withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public List<HostInstance> getInstances() {
        if (this.instances == null) {
            this.instances = new ListWithAutoConstructFlag();
            this.instances.setAutoConstruct(true);
        }
        return this.instances;
    }

    public void setInstances(Collection<HostInstance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
        instancesCopy.addAll(instances);
        this.instances = instancesCopy;
    }

    public Host withInstances(HostInstance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<HostInstance>(instances.length));
        }
        for (HostInstance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public Host withInstances(Collection<HostInstance> instances) {
        if (instances == null) {
            this.instances = null;
        } else {
            ListWithAutoConstructFlag instancesCopy = new ListWithAutoConstructFlag(instances.size());
            instancesCopy.addAll(instances);
            this.instances = instancesCopy;
        }
        return this;
    }

    public AvailableCapacity getAvailableCapacity() {
        return this.availableCapacity;
    }

    public void setAvailableCapacity(AvailableCapacity availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    public Host withAvailableCapacity(AvailableCapacity availableCapacity) {
        this.availableCapacity = availableCapacity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostId() != null) {
            sb.append("HostId: " + this.getHostId() + ",");
        }
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: " + this.getAutoPlacement() + ",");
        }
        if (this.getHostReservationId() != null) {
            sb.append("HostReservationId: " + this.getHostReservationId() + ",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getHostProperties() != null) {
            sb.append("HostProperties: " + this.getHostProperties() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: " + this.getInstances() + ",");
        }
        if (this.getAvailableCapacity() != null) {
            sb.append("AvailableCapacity: " + this.getAvailableCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostId() == null ? 0 : this.getHostId().hashCode());
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getHostReservationId() == null ? 0 : this.getHostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getHostProperties() == null ? 0 : this.getHostProperties().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableCapacity() == null ? 0 : this.getAvailableCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        if (other.getHostId() == null ^ this.getHostId() == null) {
            return false;
        }
        if (other.getHostId() != null && !other.getHostId().equals(this.getHostId())) {
            return false;
        }
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        if (other.getAutoPlacement() != null && !other.getAutoPlacement().equals(this.getAutoPlacement())) {
            return false;
        }
        if (other.getHostReservationId() == null ^ this.getHostReservationId() == null) {
            return false;
        }
        if (other.getHostReservationId() != null && !other.getHostReservationId().equals(this.getHostReservationId())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getHostProperties() == null ^ this.getHostProperties() == null) {
            return false;
        }
        if (other.getHostProperties() != null && !other.getHostProperties().equals(this.getHostProperties())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getAvailableCapacity() == null ^ this.getAvailableCapacity() == null) {
            return false;
        }
        return other.getAvailableCapacity() == null || other.getAvailableCapacity().equals(this.getAvailableCapacity());
    }

    public Host clone() {
        try {
            return (Host)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

