/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateFleetRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import com.amazonaws.services.ec2.model.OnDemandOptionsRequest;
import com.amazonaws.services.ec2.model.SpotOptionsRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class CreateFleetRequestMarshaller
implements Marshaller<Request<CreateFleetRequest>, CreateFleetRequest> {
    public Request<CreateFleetRequest> marshall(CreateFleetRequest createFleetRequest) {
        SdkInternalList createFleetRequestTagSpecificationsList;
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        SdkInternalList createFleetRequestLaunchTemplateConfigsList;
        OnDemandOptionsRequest onDemandOptions;
        SpotOptionsRequest spotOptions;
        if (createFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createFleetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createFleetRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createFleetRequest.getClientToken()));
        }
        if ((spotOptions = createFleetRequest.getSpotOptions()) != null) {
            if (spotOptions.getAllocationStrategy() != null) {
                request.addParameter("SpotOptions.AllocationStrategy", StringUtils.fromString((String)spotOptions.getAllocationStrategy()));
            }
            if (spotOptions.getInstanceInterruptionBehavior() != null) {
                request.addParameter("SpotOptions.InstanceInterruptionBehavior", StringUtils.fromString((String)spotOptions.getInstanceInterruptionBehavior()));
            }
            if (spotOptions.getInstancePoolsToUseCount() != null) {
                request.addParameter("SpotOptions.InstancePoolsToUseCount", StringUtils.fromInteger((Integer)spotOptions.getInstancePoolsToUseCount()));
            }
        }
        if ((onDemandOptions = createFleetRequest.getOnDemandOptions()) != null && onDemandOptions.getAllocationStrategy() != null) {
            request.addParameter("OnDemandOptions.AllocationStrategy", StringUtils.fromString((String)onDemandOptions.getAllocationStrategy()));
        }
        if (createFleetRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)createFleetRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(createFleetRequestLaunchTemplateConfigsList = (SdkInternalList)createFleetRequest.getLaunchTemplateConfigs()).isEmpty() || !createFleetRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest createFleetRequestLaunchTemplateConfigsListValue : createFleetRequestLaunchTemplateConfigsList) {
                SdkInternalList fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = createFleetRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = (SdkInternalList)createFleetRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !fleetLaunchTemplateConfigRequestOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getPriority()));
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if ((targetCapacitySpecification = createFleetRequest.getTargetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.getTotalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getTotalTargetCapacity()));
            }
            if (targetCapacitySpecification.getOnDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getOnDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.getSpotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getSpotTargetCapacity()));
            }
            if (targetCapacitySpecification.getDefaultTargetCapacityType() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringUtils.fromString((String)targetCapacitySpecification.getDefaultTargetCapacityType()));
            }
        }
        if (createFleetRequest.getTerminateInstancesWithExpiration() != null) {
            request.addParameter("TerminateInstancesWithExpiration", StringUtils.fromBoolean((Boolean)createFleetRequest.getTerminateInstancesWithExpiration()));
        }
        if (createFleetRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createFleetRequest.getType()));
        }
        if (createFleetRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate((Date)createFleetRequest.getValidFrom()));
        }
        if (createFleetRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate((Date)createFleetRequest.getValidUntil()));
        }
        if (createFleetRequest.getReplaceUnhealthyInstances() != null) {
            request.addParameter("ReplaceUnhealthyInstances", StringUtils.fromBoolean((Boolean)createFleetRequest.getReplaceUnhealthyInstances()));
        }
        if (!(createFleetRequestTagSpecificationsList = (SdkInternalList)createFleetRequest.getTagSpecifications()).isEmpty() || !createFleetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createFleetRequestTagSpecificationsListValue : createFleetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createFleetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createFleetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createFleetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

