/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.transform.CreateNetworkInterfaceRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateNetworkInterfaceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateNetworkInterfaceRequest> {
    private String subnetId;
    private String description;
    private String privateIpAddress;
    private SdkInternalList<String> groups;
    private SdkInternalList<PrivateIpAddressSpecification> privateIpAddresses;
    private Integer secondaryPrivateIpAddressCount;
    private SdkInternalList<InstanceIpv6Address> ipv6Addresses;
    private Integer ipv6AddressCount;

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public CreateNetworkInterfaceRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateNetworkInterfaceRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public CreateNetworkInterfaceRequest withPrivateIpAddress(String privateIpAddress) {
        this.setPrivateIpAddress(privateIpAddress);
        return this;
    }

    public List<String> getGroups() {
        if (this.groups == null) {
            this.groups = new SdkInternalList();
        }
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        if (groups == null) {
            this.groups = null;
            return;
        }
        this.groups = new SdkInternalList(groups);
    }

    public CreateNetworkInterfaceRequest withGroups(String ... groups) {
        if (this.groups == null) {
            this.setGroups((Collection<String>)new SdkInternalList(groups.length));
        }
        for (String ele : groups) {
            this.groups.add((Object)ele);
        }
        return this;
    }

    public CreateNetworkInterfaceRequest withGroups(Collection<String> groups) {
        this.setGroups(groups);
        return this;
    }

    public List<PrivateIpAddressSpecification> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new SdkInternalList();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        this.privateIpAddresses = new SdkInternalList(privateIpAddresses);
    }

    public CreateNetworkInterfaceRequest withPrivateIpAddresses(PrivateIpAddressSpecification ... privateIpAddresses) {
        if (this.privateIpAddresses == null) {
            this.setPrivateIpAddresses((Collection<PrivateIpAddressSpecification>)new SdkInternalList(privateIpAddresses.length));
        }
        for (PrivateIpAddressSpecification ele : privateIpAddresses) {
            this.privateIpAddresses.add((Object)ele);
        }
        return this;
    }

    public CreateNetworkInterfaceRequest withPrivateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
        this.setPrivateIpAddresses(privateIpAddresses);
        return this;
    }

    public void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
    }

    public Integer getSecondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public CreateNetworkInterfaceRequest withSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
        this.setSecondaryPrivateIpAddressCount(secondaryPrivateIpAddressCount);
        return this;
    }

    public List<InstanceIpv6Address> getIpv6Addresses() {
        if (this.ipv6Addresses == null) {
            this.ipv6Addresses = new SdkInternalList();
        }
        return this.ipv6Addresses;
    }

    public void setIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
        if (ipv6Addresses == null) {
            this.ipv6Addresses = null;
            return;
        }
        this.ipv6Addresses = new SdkInternalList(ipv6Addresses);
    }

    public CreateNetworkInterfaceRequest withIpv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
        if (this.ipv6Addresses == null) {
            this.setIpv6Addresses((Collection<InstanceIpv6Address>)new SdkInternalList(ipv6Addresses.length));
        }
        for (InstanceIpv6Address ele : ipv6Addresses) {
            this.ipv6Addresses.add((Object)ele);
        }
        return this;
    }

    public CreateNetworkInterfaceRequest withIpv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
        this.setIpv6Addresses(ipv6Addresses);
        return this;
    }

    public void setIpv6AddressCount(Integer ipv6AddressCount) {
        this.ipv6AddressCount = ipv6AddressCount;
    }

    public Integer getIpv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public CreateNetworkInterfaceRequest withIpv6AddressCount(Integer ipv6AddressCount) {
        this.setIpv6AddressCount(ipv6AddressCount);
        return this;
    }

    @Override
    public Request<CreateNetworkInterfaceRequest> getDryRunRequest() {
        Request<CreateNetworkInterfaceRequest> request = new CreateNetworkInterfaceRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getPrivateIpAddress() != null) {
            sb.append("PrivateIpAddress: " + this.getPrivateIpAddress() + ",");
        }
        if (this.getGroups() != null) {
            sb.append("Groups: " + this.getGroups() + ",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: " + this.getPrivateIpAddresses() + ",");
        }
        if (this.getSecondaryPrivateIpAddressCount() != null) {
            sb.append("SecondaryPrivateIpAddressCount: " + this.getSecondaryPrivateIpAddressCount() + ",");
        }
        if (this.getIpv6Addresses() != null) {
            sb.append("Ipv6Addresses: " + this.getIpv6Addresses() + ",");
        }
        if (this.getIpv6AddressCount() != null) {
            sb.append("Ipv6AddressCount: " + this.getIpv6AddressCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfaceRequest)) {
            return false;
        }
        CreateNetworkInterfaceRequest other = (CreateNetworkInterfaceRequest)obj;
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPrivateIpAddress() == null ^ this.getPrivateIpAddress() == null) {
            return false;
        }
        if (other.getPrivateIpAddress() != null && !other.getPrivateIpAddress().equals(this.getPrivateIpAddress())) {
            return false;
        }
        if (other.getGroups() == null ^ this.getGroups() == null) {
            return false;
        }
        if (other.getGroups() != null && !other.getGroups().equals(this.getGroups())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() == null ^ this.getSecondaryPrivateIpAddressCount() == null) {
            return false;
        }
        if (other.getSecondaryPrivateIpAddressCount() != null && !other.getSecondaryPrivateIpAddressCount().equals(this.getSecondaryPrivateIpAddressCount())) {
            return false;
        }
        if (other.getIpv6Addresses() == null ^ this.getIpv6Addresses() == null) {
            return false;
        }
        if (other.getIpv6Addresses() != null && !other.getIpv6Addresses().equals(this.getIpv6Addresses())) {
            return false;
        }
        if (other.getIpv6AddressCount() == null ^ this.getIpv6AddressCount() == null) {
            return false;
        }
        return other.getIpv6AddressCount() == null || other.getIpv6AddressCount().equals(this.getIpv6AddressCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddress() == null ? 0 : this.getPrivateIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getGroups() == null ? 0 : this.getGroups().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryPrivateIpAddressCount() == null ? 0 : this.getSecondaryPrivateIpAddressCount().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6Addresses() == null ? 0 : this.getIpv6Addresses().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6AddressCount() == null ? 0 : this.getIpv6AddressCount().hashCode());
        return hashCode;
    }

    public CreateNetworkInterfaceRequest clone() {
        return (CreateNetworkInterfaceRequest)super.clone();
    }
}

