/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.LaunchTemplate;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class LaunchTemplateStaxUnmarshaller
implements Unmarshaller<LaunchTemplate, StaxUnmarshallerContext> {
    private static LaunchTemplateStaxUnmarshaller instance;

    public LaunchTemplate unmarshall(StaxUnmarshallerContext context) throws Exception {
        LaunchTemplate launchTemplate = new LaunchTemplate();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return launchTemplate;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("launchTemplateId", targetDepth)) {
                    launchTemplate.setLaunchTemplateId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("launchTemplateName", targetDepth)) {
                    launchTemplate.setLaunchTemplateName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createTime", targetDepth)) {
                    launchTemplate.setCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("createdBy", targetDepth)) {
                    launchTemplate.setCreatedBy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultVersionNumber", targetDepth)) {
                    launchTemplate.setDefaultVersionNumber(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("latestVersionNumber", targetDepth)) {
                    launchTemplate.setLatestVersionNumber(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    launchTemplate.withTags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                launchTemplate.withTags(TagStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return launchTemplate;
    }

    public static LaunchTemplateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LaunchTemplateStaxUnmarshaller();
        }
        return instance;
    }
}

