/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ReservationFleetInstanceSpecification StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ReservationFleetInstanceSpecificationStaxUnmarshaller implements Unmarshaller<ReservationFleetInstanceSpecification, StaxUnmarshallerContext> {

    public ReservationFleetInstanceSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservationFleetInstanceSpecification reservationFleetInstanceSpecification = new ReservationFleetInstanceSpecification();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return reservationFleetInstanceSpecification;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("InstanceType", targetDepth)) {
                    reservationFleetInstanceSpecification.setInstanceType(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("InstancePlatform", targetDepth)) {
                    reservationFleetInstanceSpecification.setInstancePlatform(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Weight", targetDepth)) {
                    reservationFleetInstanceSpecification.setWeight(DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AvailabilityZone", targetDepth)) {
                    reservationFleetInstanceSpecification.setAvailabilityZone(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("AvailabilityZoneId", targetDepth)) {
                    reservationFleetInstanceSpecification.setAvailabilityZoneId(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EbsOptimized", targetDepth)) {
                    reservationFleetInstanceSpecification.setEbsOptimized(BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Priority", targetDepth)) {
                    reservationFleetInstanceSpecification.setPriority(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return reservationFleetInstanceSpecification;
                }
            }
        }
    }

    private static ReservationFleetInstanceSpecificationStaxUnmarshaller instance;

    public static ReservationFleetInstanceSpecificationStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new ReservationFleetInstanceSpecificationStaxUnmarshaller();
        return instance;
    }
}
