/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * ModifyHostsRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ModifyHostsRequestMarshaller implements Marshaller<Request<ModifyHostsRequest>, ModifyHostsRequest> {

    public Request<ModifyHostsRequest> marshall(ModifyHostsRequest modifyHostsRequest) {

        if (modifyHostsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyHostsRequest> request = new DefaultRequest<ModifyHostsRequest>(modifyHostsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyHostsRequest.getAutoPlacement() != null) {
            request.addParameter("AutoPlacement", StringUtils.fromString(modifyHostsRequest.getAutoPlacement()));
        }

        com.amazonaws.internal.SdkInternalList<String> modifyHostsRequestHostIdsList = (com.amazonaws.internal.SdkInternalList<String>) modifyHostsRequest
                .getHostIds();
        if (!modifyHostsRequestHostIdsList.isEmpty() || !modifyHostsRequestHostIdsList.isAutoConstruct()) {
            int hostIdsListIndex = 1;

            for (String modifyHostsRequestHostIdsListValue : modifyHostsRequestHostIdsList) {
                if (modifyHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringUtils.fromString(modifyHostsRequestHostIdsListValue));
                }
                hostIdsListIndex++;
            }
        }

        if (modifyHostsRequest.getHostRecovery() != null) {
            request.addParameter("HostRecovery", StringUtils.fromString(modifyHostsRequest.getHostRecovery()));
        }

        if (modifyHostsRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(modifyHostsRequest.getInstanceType()));
        }

        if (modifyHostsRequest.getInstanceFamily() != null) {
            request.addParameter("InstanceFamily", StringUtils.fromString(modifyHostsRequest.getInstanceFamily()));
        }

        if (modifyHostsRequest.getHostMaintenance() != null) {
            request.addParameter("HostMaintenance", StringUtils.fromString(modifyHostsRequest.getHostMaintenance()));
        }

        return request;
    }

}
