/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.transform.EnableImageDeregistrationProtectionRequestMarshaller;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EnableImageDeregistrationProtectionRequest extends AmazonWebServiceRequest implements Serializable, Cloneable,
        DryRunSupportedRequest<EnableImageDeregistrationProtectionRequest> {

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     */
    private String imageId;
    /**
     * <p>
     * If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     * disabled.
     * </p>
     */
    private Boolean withCooldown;

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @param imageId
     *        The ID of the AMI.
     */

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */

    public String getImageId() {
        return this.imageId;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @param imageId
     *        The ID of the AMI.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EnableImageDeregistrationProtectionRequest withImageId(String imageId) {
        setImageId(imageId);
        return this;
    }

    /**
     * <p>
     * If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     * disabled.
     * </p>
     * 
     * @param withCooldown
     *        If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     *        disabled.
     */

    public void setWithCooldown(Boolean withCooldown) {
        this.withCooldown = withCooldown;
    }

    /**
     * <p>
     * If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     * disabled.
     * </p>
     * 
     * @return If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     *         disabled.
     */

    public Boolean getWithCooldown() {
        return this.withCooldown;
    }

    /**
     * <p>
     * If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     * disabled.
     * </p>
     * 
     * @param withCooldown
     *        If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     *        disabled.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EnableImageDeregistrationProtectionRequest withWithCooldown(Boolean withCooldown) {
        setWithCooldown(withCooldown);
        return this;
    }

    /**
     * <p>
     * If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     * disabled.
     * </p>
     * 
     * @return If <code>true</code>, enforces deregistration protection for 24 hours after deregistration protection is
     *         disabled.
     */

    public Boolean isWithCooldown() {
        return this.withCooldown;
    }

    /**
     * This method is intended for internal use only. Returns the marshaled request configured with additional
     * parameters to enable operation dry-run.
     */
    @Override
    public Request<EnableImageDeregistrationProtectionRequest> getDryRunRequest() {
        Request<EnableImageDeregistrationProtectionRequest> request = new EnableImageDeregistrationProtectionRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getImageId() != null)
            sb.append("ImageId: ").append(getImageId()).append(",");
        if (getWithCooldown() != null)
            sb.append("WithCooldown: ").append(getWithCooldown());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EnableImageDeregistrationProtectionRequest == false)
            return false;
        EnableImageDeregistrationProtectionRequest other = (EnableImageDeregistrationProtectionRequest) obj;
        if (other.getImageId() == null ^ this.getImageId() == null)
            return false;
        if (other.getImageId() != null && other.getImageId().equals(this.getImageId()) == false)
            return false;
        if (other.getWithCooldown() == null ^ this.getWithCooldown() == null)
            return false;
        if (other.getWithCooldown() != null && other.getWithCooldown().equals(this.getWithCooldown()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getImageId() == null) ? 0 : getImageId().hashCode());
        hashCode = prime * hashCode + ((getWithCooldown() == null) ? 0 : getWithCooldown().hashCode());
        return hashCode;
    }

    @Override
    public EnableImageDeregistrationProtectionRequest clone() {
        return (EnableImageDeregistrationProtectionRequest) super.clone();
    }
}
