/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * ModifyInstanceMetadataDefaultsRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ModifyInstanceMetadataDefaultsRequestMarshaller implements
        Marshaller<Request<ModifyInstanceMetadataDefaultsRequest>, ModifyInstanceMetadataDefaultsRequest> {

    public Request<ModifyInstanceMetadataDefaultsRequest> marshall(ModifyInstanceMetadataDefaultsRequest modifyInstanceMetadataDefaultsRequest) {

        if (modifyInstanceMetadataDefaultsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ModifyInstanceMetadataDefaultsRequest> request = new DefaultRequest<ModifyInstanceMetadataDefaultsRequest>(
                modifyInstanceMetadataDefaultsRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyInstanceMetadataDefaults");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);

        if (modifyInstanceMetadataDefaultsRequest.getHttpTokens() != null) {
            request.addParameter("HttpTokens", StringUtils.fromString(modifyInstanceMetadataDefaultsRequest.getHttpTokens()));
        }

        if (modifyInstanceMetadataDefaultsRequest.getHttpPutResponseHopLimit() != null) {
            request.addParameter("HttpPutResponseHopLimit", StringUtils.fromInteger(modifyInstanceMetadataDefaultsRequest.getHttpPutResponseHopLimit()));
        }

        if (modifyInstanceMetadataDefaultsRequest.getHttpEndpoint() != null) {
            request.addParameter("HttpEndpoint", StringUtils.fromString(modifyInstanceMetadataDefaultsRequest.getHttpEndpoint()));
        }

        if (modifyInstanceMetadataDefaultsRequest.getInstanceMetadataTags() != null) {
            request.addParameter("InstanceMetadataTags", StringUtils.fromString(modifyInstanceMetadataDefaultsRequest.getInstanceMetadataTags()));
        }

        return request;
    }

}
