/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Volume;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeVolumesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Volume> volumes;
    private String nextToken;

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new ListWithAutoConstructFlag();
            this.volumes.setAutoConstruct(true);
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
        volumesCopy.addAll(volumes);
        this.volumes = volumesCopy;
    }

    public DescribeVolumesResult withVolumes(Volume ... volumes) {
        if (this.getVolumes() == null) {
            this.setVolumes(new ArrayList<Volume>(volumes.length));
        }
        for (Volume value : volumes) {
            this.getVolumes().add(value);
        }
        return this;
    }

    public DescribeVolumesResult withVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
        } else {
            ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
            volumesCopy.addAll(volumes);
            this.volumes = volumesCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeVolumesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVolumes() != null) {
            sb.append("Volumes: " + this.getVolumes() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVolumesResult)) {
            return false;
        }
        DescribeVolumesResult other = (DescribeVolumesResult)obj;
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public DescribeVolumesResult clone() {
        try {
            return (DescribeVolumesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

