/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecr.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecr.model.BatchDeleteImageResult;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.BatchGetImageResult;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecr.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecr.model.CreateRepositoryRequest;
import com.amazonaws.services.ecr.model.CreateRepositoryResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryResult;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecr.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecr.model.EmptyUploadException;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerResult;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.ImageAlreadyExistsException;
import com.amazonaws.services.ecr.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecr.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecr.model.InvalidLayerException;
import com.amazonaws.services.ecr.model.InvalidLayerPartException;
import com.amazonaws.services.ecr.model.InvalidParameterException;
import com.amazonaws.services.ecr.model.LayerAlreadyExistsException;
import com.amazonaws.services.ecr.model.LayerInaccessibleException;
import com.amazonaws.services.ecr.model.LayerPartTooSmallException;
import com.amazonaws.services.ecr.model.LayersNotFoundException;
import com.amazonaws.services.ecr.model.LimitExceededException;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.services.ecr.model.ListImagesResult;
import com.amazonaws.services.ecr.model.PutImageRequest;
import com.amazonaws.services.ecr.model.PutImageResult;
import com.amazonaws.services.ecr.model.RepositoryAlreadyExistsException;
import com.amazonaws.services.ecr.model.RepositoryNotEmptyException;
import com.amazonaws.services.ecr.model.RepositoryNotFoundException;
import com.amazonaws.services.ecr.model.RepositoryPolicyNotFoundException;
import com.amazonaws.services.ecr.model.ServerException;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.services.ecr.model.UploadLayerPartResult;
import com.amazonaws.services.ecr.model.UploadNotFoundException;
import com.amazonaws.services.ecr.model.transform.BatchCheckLayerAvailabilityRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchCheckLayerAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.BatchDeleteImageRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchDeleteImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.BatchGetImageRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchGetImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.CompleteLayerUploadRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.CompleteLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.CreateRepositoryRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.CreateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryPolicyRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeRepositoriesRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetAuthorizationTokenRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.GetAuthorizationTokenResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetDownloadUrlForLayerRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.GetDownloadUrlForLayerResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetRepositoryPolicyRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.GetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.InitiateLayerUploadRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.InitiateLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.ListImagesRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.ListImagesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.PutImageRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.PutImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.SetRepositoryPolicyRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.SetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.UploadLayerPartRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.UploadLayerPartResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonECRClient
extends AmazonWebServiceClient
implements AmazonECR {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECR.class);
    private static final String DEFAULT_SIGNING_NAME = "ecr";
    private static final String DEFAULT_ENDPOINT_PREFIX = "ecr";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonECRClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonECRClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonECRClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonECRClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LayerPartTooSmallException.class, "LayerPartTooSmallException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidLayerPartException.class, "InvalidLayerPartException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidParameterException.class, "InvalidParameterException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ServerException.class, "ServerException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryNotEmptyException.class, "RepositoryNotEmptyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LayerAlreadyExistsException.class, "LayerAlreadyExistsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(EmptyUploadException.class, "EmptyUploadException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LayersNotFoundException.class, "LayersNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidLayerException.class, "InvalidLayerException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryNotFoundException.class, "RepositoryNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryAlreadyExistsException.class, "RepositoryAlreadyExistsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(RepositoryPolicyNotFoundException.class, "RepositoryPolicyNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ImageAlreadyExistsException.class, "ImageAlreadyExistsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LayerInaccessibleException.class, "LayerInaccessibleException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LimitExceededException.class, "LimitExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UploadNotFoundException.class, "UploadNotFoundException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("ecr.us-east-1.amazonaws.com");
        this.setServiceNameIntern("ecr");
        this.setEndpointPrefix("ecr");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecr/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecr/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCheckLayerAvailabilityResult batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCheckLayerAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCheckLayerAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCheckLayerAvailabilityRequestMarshaller().marshall((BatchCheckLayerAvailabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCheckLayerAvailabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new BatchCheckLayerAvailabilityResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            BatchCheckLayerAvailabilityResult batchCheckLayerAvailabilityResult = (BatchCheckLayerAvailabilityResult)response.getAwsResponse();
            return batchCheckLayerAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteImageResult batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteImageRequestMarshaller().marshall((BatchDeleteImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new BatchDeleteImageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            BatchDeleteImageResult batchDeleteImageResult = (BatchDeleteImageResult)response.getAwsResponse();
            return batchDeleteImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetImageResult batchGetImage(BatchGetImageRequest batchGetImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetImageRequestMarshaller().marshall((BatchGetImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new BatchGetImageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            BatchGetImageResult batchGetImageResult = (BatchGetImageResult)response.getAwsResponse();
            return batchGetImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteLayerUploadResult completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteLayerUploadRequestMarshaller().marshall((CompleteLayerUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CompleteLayerUploadResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CompleteLayerUploadResult completeLayerUploadResult = (CompleteLayerUploadResult)response.getAwsResponse();
            return completeLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest createRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRepositoryRequestMarshaller().marshall((CreateRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new CreateRepositoryResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateRepositoryResult createRepositoryResult = (CreateRepositoryResult)response.getAwsResponse();
            return createRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryRequestMarshaller().marshall((DeleteRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteRepositoryResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteRepositoryResult deleteRepositoryResult = (DeleteRepositoryResult)response.getAwsResponse();
            return deleteRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryPolicyResult deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryPolicyRequestMarshaller().marshall((DeleteRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DeleteRepositoryPolicyResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteRepositoryPolicyResult deleteRepositoryPolicyResult = (DeleteRepositoryPolicyResult)response.getAwsResponse();
            return deleteRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRepositoriesResult describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRepositoriesRequestMarshaller().marshall((DescribeRepositoriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new DescribeRepositoriesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeRepositoriesResult describeRepositoriesResult = (DescribeRepositoriesResult)response.getAwsResponse();
            return describeRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAuthorizationTokenResult getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAuthorizationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAuthorizationTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAuthorizationTokenRequestMarshaller().marshall((GetAuthorizationTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAuthorizationTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetAuthorizationTokenResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetAuthorizationTokenResult getAuthorizationTokenResult = (GetAuthorizationTokenResult)response.getAwsResponse();
            return getAuthorizationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDownloadUrlForLayerResult getDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDownloadUrlForLayerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDownloadUrlForLayerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDownloadUrlForLayerRequestMarshaller().marshall((GetDownloadUrlForLayerRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDownloadUrlForLayerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetDownloadUrlForLayerResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetDownloadUrlForLayerResult getDownloadUrlForLayerResult = (GetDownloadUrlForLayerResult)response.getAwsResponse();
            return getDownloadUrlForLayerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryPolicyResult getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryPolicyRequestMarshaller().marshall((GetRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new GetRepositoryPolicyResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetRepositoryPolicyResult getRepositoryPolicyResult = (GetRepositoryPolicyResult)response.getAwsResponse();
            return getRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateLayerUploadResult initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateLayerUploadRequestMarshaller().marshall((InitiateLayerUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new InitiateLayerUploadResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            InitiateLayerUploadResult initiateLayerUploadResult = (InitiateLayerUploadResult)response.getAwsResponse();
            return initiateLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImagesResult listImages(ListImagesRequest listImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListImagesRequestMarshaller().marshall((ListImagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new ListImagesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListImagesResult listImagesResult = (ListImagesResult)response.getAwsResponse();
            return listImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutImageResult putImage(PutImageRequest putImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutImageRequestMarshaller().marshall((PutImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)putImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new PutImageResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutImageResult putImageResult = (PutImageResult)response.getAwsResponse();
            return putImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetRepositoryPolicyResult setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetRepositoryPolicyRequestMarshaller().marshall((SetRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)setRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new SetRepositoryPolicyResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            SetRepositoryPolicyResult setRepositoryPolicyResult = (SetRepositoryPolicyResult)response.getAwsResponse();
            return setRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadLayerPartResult uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadLayerPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadLayerPartRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadLayerPartRequestMarshaller().marshall((UploadLayerPartRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadLayerPartRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)new UploadLayerPartResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UploadLayerPartResult uploadLayerPartResult = (UploadLayerPartResult)response.getAwsResponse();
            return uploadLayerPartResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

