/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ecr.model.RegistryScanningRule;
import com.amazonaws.services.ecr.model.ScanType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutRegistryScanningConfigurationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String scanType;
    private List<RegistryScanningRule> rules;

    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    public String getScanType() {
        return this.scanType;
    }

    public PutRegistryScanningConfigurationRequest withScanType(String scanType) {
        this.setScanType(scanType);
        return this;
    }

    public PutRegistryScanningConfigurationRequest withScanType(ScanType scanType) {
        this.scanType = scanType.toString();
        return this;
    }

    public List<RegistryScanningRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<RegistryScanningRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<RegistryScanningRule>(rules);
    }

    public PutRegistryScanningConfigurationRequest withRules(RegistryScanningRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<RegistryScanningRule>(rules.length));
        }
        for (RegistryScanningRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public PutRegistryScanningConfigurationRequest withRules(Collection<RegistryScanningRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScanType() != null) {
            sb.append("ScanType: ").append(this.getScanType()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRegistryScanningConfigurationRequest)) {
            return false;
        }
        PutRegistryScanningConfigurationRequest other = (PutRegistryScanningConfigurationRequest)obj;
        if (other.getScanType() == null ^ this.getScanType() == null) {
            return false;
        }
        if (other.getScanType() != null && !other.getScanType().equals(this.getScanType())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScanType() == null ? 0 : this.getScanType().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public PutRegistryScanningConfigurationRequest clone() {
        return (PutRegistryScanningConfigurationRequest)super.clone();
    }
}

