/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecr.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.ecr.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * PackageVulnerabilityDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PackageVulnerabilityDetailsJsonUnmarshaller implements Unmarshaller<PackageVulnerabilityDetails, JsonUnmarshallerContext> {

    public PackageVulnerabilityDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        PackageVulnerabilityDetails packageVulnerabilityDetails = new PackageVulnerabilityDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("cvss", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setCvss(new ListUnmarshaller<CvssScore>(CvssScoreJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("referenceUrls", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setReferenceUrls(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("relatedVulnerabilities", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setRelatedVulnerabilities(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
                if (context.testExpression("source", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setSource(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("sourceUrl", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setSourceUrl(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vendorCreatedAt", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setVendorCreatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("vendorSeverity", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setVendorSeverity(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vendorUpdatedAt", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setVendorUpdatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("vulnerabilityId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setVulnerabilityId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("vulnerablePackages", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    packageVulnerabilityDetails.setVulnerablePackages(new ListUnmarshaller<VulnerablePackage>(VulnerablePackageJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return packageVulnerabilityDetails;
    }

    private static PackageVulnerabilityDetailsJsonUnmarshaller instance;

    public static PackageVulnerabilityDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new PackageVulnerabilityDetailsJsonUnmarshaller();
        return instance;
    }
}
