/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecr.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecr-2015-09-21/CreateRepositoryCreationTemplate"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateRepositoryCreationTemplateResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     */
    private String registryId;
    /**
     * <p>
     * The details of the repository creation template associated with the request.
     * </p>
     */
    private RepositoryCreationTemplate repositoryCreationTemplate;

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @param registryId
     *        The registry ID associated with the request.
     */

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @return The registry ID associated with the request.
     */

    public String getRegistryId() {
        return this.registryId;
    }

    /**
     * <p>
     * The registry ID associated with the request.
     * </p>
     * 
     * @param registryId
     *        The registry ID associated with the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateRepositoryCreationTemplateResult withRegistryId(String registryId) {
        setRegistryId(registryId);
        return this;
    }

    /**
     * <p>
     * The details of the repository creation template associated with the request.
     * </p>
     * 
     * @param repositoryCreationTemplate
     *        The details of the repository creation template associated with the request.
     */

    public void setRepositoryCreationTemplate(RepositoryCreationTemplate repositoryCreationTemplate) {
        this.repositoryCreationTemplate = repositoryCreationTemplate;
    }

    /**
     * <p>
     * The details of the repository creation template associated with the request.
     * </p>
     * 
     * @return The details of the repository creation template associated with the request.
     */

    public RepositoryCreationTemplate getRepositoryCreationTemplate() {
        return this.repositoryCreationTemplate;
    }

    /**
     * <p>
     * The details of the repository creation template associated with the request.
     * </p>
     * 
     * @param repositoryCreationTemplate
     *        The details of the repository creation template associated with the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateRepositoryCreationTemplateResult withRepositoryCreationTemplate(RepositoryCreationTemplate repositoryCreationTemplate) {
        setRepositoryCreationTemplate(repositoryCreationTemplate);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRegistryId() != null)
            sb.append("RegistryId: ").append(getRegistryId()).append(",");
        if (getRepositoryCreationTemplate() != null)
            sb.append("RepositoryCreationTemplate: ").append(getRepositoryCreationTemplate());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateRepositoryCreationTemplateResult == false)
            return false;
        CreateRepositoryCreationTemplateResult other = (CreateRepositoryCreationTemplateResult) obj;
        if (other.getRegistryId() == null ^ this.getRegistryId() == null)
            return false;
        if (other.getRegistryId() != null && other.getRegistryId().equals(this.getRegistryId()) == false)
            return false;
        if (other.getRepositoryCreationTemplate() == null ^ this.getRepositoryCreationTemplate() == null)
            return false;
        if (other.getRepositoryCreationTemplate() != null && other.getRepositoryCreationTemplate().equals(this.getRepositoryCreationTemplate()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRegistryId() == null) ? 0 : getRegistryId().hashCode());
        hashCode = prime * hashCode + ((getRepositoryCreationTemplate() == null) ? 0 : getRepositoryCreationTemplate().hashCode());
        return hashCode;
    }

    @Override
    public CreateRepositoryCreationTemplateResult clone() {
        try {
            return (CreateRepositoryCreationTemplateResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
