/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.TaskDefinition;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ContainerDefinitionJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VolumeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class TaskDefinitionJsonMarshaller {
    private static TaskDefinitionJsonMarshaller instance;

    public void marshall(TaskDefinition taskDefinition, JSONWriter jsonWriter) {
        if (taskDefinition == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList requiresAttributesList;
            SdkInternalList volumesList;
            SdkInternalList containerDefinitionsList;
            jsonWriter.object();
            if (taskDefinition.getTaskDefinitionArn() != null) {
                jsonWriter.key("taskDefinitionArn").value((Object)taskDefinition.getTaskDefinitionArn());
            }
            if (!(containerDefinitionsList = (SdkInternalList)taskDefinition.getContainerDefinitions()).isEmpty() || !containerDefinitionsList.isAutoConstruct()) {
                jsonWriter.key("containerDefinitions");
                jsonWriter.array();
                for (ContainerDefinition containerDefinitionsListValue : containerDefinitionsList) {
                    if (containerDefinitionsListValue == null) continue;
                    ContainerDefinitionJsonMarshaller.getInstance().marshall(containerDefinitionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (taskDefinition.getFamily() != null) {
                jsonWriter.key("family").value((Object)taskDefinition.getFamily());
            }
            if (taskDefinition.getRevision() != null) {
                jsonWriter.key("revision").value((Object)taskDefinition.getRevision());
            }
            if (!(volumesList = (SdkInternalList)taskDefinition.getVolumes()).isEmpty() || !volumesList.isAutoConstruct()) {
                jsonWriter.key("volumes");
                jsonWriter.array();
                for (Volume volumesListValue : volumesList) {
                    if (volumesListValue == null) continue;
                    VolumeJsonMarshaller.getInstance().marshall(volumesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (taskDefinition.getStatus() != null) {
                jsonWriter.key("status").value((Object)taskDefinition.getStatus());
            }
            if (!(requiresAttributesList = (SdkInternalList)taskDefinition.getRequiresAttributes()).isEmpty() || !requiresAttributesList.isAutoConstruct()) {
                jsonWriter.key("requiresAttributes");
                jsonWriter.array();
                for (Attribute requiresAttributesListValue : requiresAttributesList) {
                    if (requiresAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(requiresAttributesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskDefinitionJsonMarshaller();
        }
        return instance;
    }
}

