/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerInstanceStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateContainerInstancesStateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> containerInstances;
    private String status;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public UpdateContainerInstancesStateRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new SdkInternalList();
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        this.containerInstances = new SdkInternalList(containerInstances);
    }

    public UpdateContainerInstancesStateRequest withContainerInstances(String ... containerInstances) {
        if (this.containerInstances == null) {
            this.setContainerInstances((Collection<String>)new SdkInternalList(containerInstances.length));
        }
        for (String ele : containerInstances) {
            this.containerInstances.add((Object)ele);
        }
        return this;
    }

    public UpdateContainerInstancesStateRequest withContainerInstances(Collection<String> containerInstances) {
        this.setContainerInstances(containerInstances);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public UpdateContainerInstancesStateRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    @JsonIgnore
    public void setStatus(ContainerInstanceStatus status) {
        this.withStatus(status);
    }

    public UpdateContainerInstancesStateRequest withStatus(ContainerInstanceStatus status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: ").append(this.getContainerInstances()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContainerInstancesStateRequest)) {
            return false;
        }
        UpdateContainerInstancesStateRequest other = (UpdateContainerInstancesStateRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        if (other.getContainerInstances() != null && !other.getContainerInstances().equals(this.getContainerInstances())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public UpdateContainerInstancesStateRequest clone() {
        return (UpdateContainerInstancesStateRequest)super.clone();
    }
}

