/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.waiters.DescribeServicesFunction;
import com.amazonaws.services.ecs.waiters.DescribeTasksFunction;
import com.amazonaws.services.ecs.waiters.ServicesInactive;
import com.amazonaws.services.ecs.waiters.ServicesStable;
import com.amazonaws.services.ecs.waiters.TasksRunning;
import com.amazonaws.services.ecs.waiters.TasksStopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonECSWaiters {
    private final AmazonECS client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonECSWaiters(AmazonECS client) {
        this.client = client;
    }

    public Waiter tasksRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TasksRunning.IsSTOPPEDMatcher(), new TasksRunning.IsMISSINGMatcher(), new TasksRunning.IsRUNNINGMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(100), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(6))).withExecutorService(this.executorService).build();
    }

    public Waiter servicesStable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeServicesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServicesStable.IsMISSINGMatcher(), new ServicesStable.IsDRAININGMatcher(), new ServicesStable.IsINACTIVEMatcher(), new ServicesStable.IsTrueMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter servicesInactive() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeServicesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ServicesInactive.IsMISSINGMatcher(), new ServicesInactive.IsINACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter tasksStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TasksStopped.IsSTOPPEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(100), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(6))).withExecutorService(this.executorService).build();
    }
}

