/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecs.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.ecs.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * AutoScalingGroupProviderMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class AutoScalingGroupProviderMarshaller {

    private static final MarshallingInfo<String> AUTOSCALINGGROUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoScalingGroupArn").build();
    private static final MarshallingInfo<StructuredPojo> MANAGEDSCALING_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("managedScaling").build();
    private static final MarshallingInfo<String> MANAGEDTERMINATIONPROTECTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("managedTerminationProtection").build();

    private static final AutoScalingGroupProviderMarshaller instance = new AutoScalingGroupProviderMarshaller();

    public static AutoScalingGroupProviderMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(AutoScalingGroupProvider autoScalingGroupProvider, ProtocolMarshaller protocolMarshaller) {

        if (autoScalingGroupProvider == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(autoScalingGroupProvider.getAutoScalingGroupArn(), AUTOSCALINGGROUPARN_BINDING);
            protocolMarshaller.marshall(autoScalingGroupProvider.getManagedScaling(), MANAGEDSCALING_BINDING);
            protocolMarshaller.marshall(autoScalingGroupProvider.getManagedTerminationProtection(), MANAGEDTERMINATIONPROTECTION_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
