/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.UnknownMemberJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class ResourceJsonUnmarshaller
implements Unmarshaller<Resource, JsonUnmarshallerContext> {
    private static ResourceJsonUnmarshaller instance;

    public Resource unmarshall(JsonUnmarshallerContext context) throws Exception {
        Resource resource = new Resource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            boolean knownMember = false;
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    resource.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("type", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    resource.setType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("doubleValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    resource.setDoubleValue((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("longValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    resource.setLongValue((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("integerValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    resource.setIntegerValue((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("stringSetValue", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    resource.setStringSetValue(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (token == JsonToken.FIELD_NAME && !knownMember) {
                    context.nextToken();
                    UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return resource;
    }

    public static ResourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ResourceJsonUnmarshaller();
        }
        return instance;
    }
}

