/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ecs.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Details on a task in a cluster.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/ecs-2014-11-13/Task" target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class Task implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
     * mode.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Attachment> attachments;
    /**
     * <p>
     * The attributes of the task
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Attribute> attributes;
    /**
     * <p>
     * The Availability Zone for the task.
     * </p>
     */
    private String availabilityZone;
    /**
     * <p>
     * The capacity provider that's associated with the task.
     * </p>
     */
    private String capacityProviderName;
    /**
     * <p>
     * The ARN of the cluster that hosts the task.
     * </p>
     */
    private String clusterArn;
    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     */
    private String connectivity;
    /**
     * <p>
     * The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     * </p>
     */
    private java.util.Date connectivityAt;
    /**
     * <p>
     * The ARN of the container instances that host the task.
     * </p>
     */
    private String containerInstanceArn;
    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Container> containers;
    /**
     * <p>
     * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer
     * using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs (for example,
     * <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that indicates the CPU
     * units when the task definition is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (
     * <code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. These
     * values determine the range of supported values for the <code>memory</code> parameter:
     * </p>
     * <p>
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6
     * GB), 7168 (7 GB), 8192 (8 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * 16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     */
    private String cpu;
    /**
     * <p>
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
     * entered the <code>PENDING</code> state.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * The desired status of the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     */
    private String desiredStatus;
    /**
     * <p>
     * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     * command functionality is turned on all the containers in the task.
     * </p>
     */
    private Boolean enableExecuteCommand;
    /**
     * <p>
     * The Unix timestamp for the time when the task execution stopped.
     * </p>
     */
    private java.util.Date executionStoppedAt;
    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     */
    private String group;
    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     */
    private String healthStatus;
    /**
     * <p>
     * The Elastic Inference accelerator that's associated with the task.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<InferenceAccelerator> inferenceAccelerators;
    /**
     * <p>
     * The last known status for the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     */
    private String lastStatus;
    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     */
    private String launchType;
    /**
     * <p>
     * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an
     * integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for example,
     * <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the task definition
     * is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional.
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. The value
     * that you choose determines the range of supported values for the <code>cpu</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     * <code>cpu</code> values: 1024 (1 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     */
    private String memory;
    /**
     * <p>
     * One or more container overrides.
     * </p>
     */
    private TaskOverride overrides;
    /**
     * <p>
     * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate
     * launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     */
    private String platformVersion;
    /**
     * <p>
     * The operating system that your tasks are running on. A platform family is specified only for tasks that use the
     * Fargate launch type.
     * </p>
     * <p>
     * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
     * (for example, <code>LINUX.</code>).
     * </p>
     */
    private String platformFamily;
    /**
     * <p>
     * The Unix timestamp for the time when the container image pull began.
     * </p>
     */
    private java.util.Date pullStartedAt;
    /**
     * <p>
     * The Unix timestamp for the time when the container image pull completed.
     * </p>
     */
    private java.util.Date pullStoppedAt;
    /**
     * <p>
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * </p>
     */
    private java.util.Date startedAt;
    /**
     * <p>
     * The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code>
     * parameter contains the deployment ID of that service.
     * </p>
     */
    private String startedBy;
    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * For more information about stop code, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped tasks
     * error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     */
    private String stopCode;
    /**
     * <p>
     * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task
     * transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     * </p>
     */
    private java.util.Date stoppedAt;
    /**
     * <p>
     * The reason that the task was stopped.
     * </p>
     */
    private String stoppedReason;
    /**
     * <p>
     * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     * transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     * </p>
     */
    private java.util.Date stoppingAt;
    /**
     * <p>
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key
     * and an optional value. You define both the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;
    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     */
    private String taskArn;
    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     */
    private String taskDefinitionArn;
    /**
     * <p>
     * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the
     * version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can
     * compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch
     * Events for the task (inside the <code>detail</code> object) to verify that the version in your event stream is
     * current.
     * </p>
     */
    private Long version;
    /**
     * <p>
     * The ephemeral storage settings for the task.
     * </p>
     */
    private EphemeralStorage ephemeralStorage;

    /**
     * <p>
     * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
     * mode.
     * </p>
     * 
     * @return The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
     *         network mode.
     */

    public java.util.List<Attachment> getAttachments() {
        if (attachments == null) {
            attachments = new com.amazonaws.internal.SdkInternalList<Attachment>();
        }
        return attachments;
    }

    /**
     * <p>
     * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
     * mode.
     * </p>
     * 
     * @param attachments
     *        The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
     *        network mode.
     */

    public void setAttachments(java.util.Collection<Attachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }

        this.attachments = new com.amazonaws.internal.SdkInternalList<Attachment>(attachments);
    }

    /**
     * <p>
     * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
     * mode.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAttachments(java.util.Collection)} or {@link #withAttachments(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param attachments
     *        The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
     *        network mode.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withAttachments(Attachment... attachments) {
        if (this.attachments == null) {
            setAttachments(new com.amazonaws.internal.SdkInternalList<Attachment>(attachments.length));
        }
        for (Attachment ele : attachments) {
            this.attachments.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code> network
     * mode.
     * </p>
     * 
     * @param attachments
     *        The Elastic Network Adapter that's associated with the task if the task uses the <code>awsvpc</code>
     *        network mode.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withAttachments(java.util.Collection<Attachment> attachments) {
        setAttachments(attachments);
        return this;
    }

    /**
     * <p>
     * The attributes of the task
     * </p>
     * 
     * @return The attributes of the task
     */

    public java.util.List<Attribute> getAttributes() {
        if (attributes == null) {
            attributes = new com.amazonaws.internal.SdkInternalList<Attribute>();
        }
        return attributes;
    }

    /**
     * <p>
     * The attributes of the task
     * </p>
     * 
     * @param attributes
     *        The attributes of the task
     */

    public void setAttributes(java.util.Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }

        this.attributes = new com.amazonaws.internal.SdkInternalList<Attribute>(attributes);
    }

    /**
     * <p>
     * The attributes of the task
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAttributes(java.util.Collection)} or {@link #withAttributes(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param attributes
     *        The attributes of the task
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withAttributes(Attribute... attributes) {
        if (this.attributes == null) {
            setAttributes(new com.amazonaws.internal.SdkInternalList<Attribute>(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The attributes of the task
     * </p>
     * 
     * @param attributes
     *        The attributes of the task
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withAttributes(java.util.Collection<Attribute> attributes) {
        setAttributes(attributes);
        return this;
    }

    /**
     * <p>
     * The Availability Zone for the task.
     * </p>
     * 
     * @param availabilityZone
     *        The Availability Zone for the task.
     */

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    /**
     * <p>
     * The Availability Zone for the task.
     * </p>
     * 
     * @return The Availability Zone for the task.
     */

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    /**
     * <p>
     * The Availability Zone for the task.
     * </p>
     * 
     * @param availabilityZone
     *        The Availability Zone for the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withAvailabilityZone(String availabilityZone) {
        setAvailabilityZone(availabilityZone);
        return this;
    }

    /**
     * <p>
     * The capacity provider that's associated with the task.
     * </p>
     * 
     * @param capacityProviderName
     *        The capacity provider that's associated with the task.
     */

    public void setCapacityProviderName(String capacityProviderName) {
        this.capacityProviderName = capacityProviderName;
    }

    /**
     * <p>
     * The capacity provider that's associated with the task.
     * </p>
     * 
     * @return The capacity provider that's associated with the task.
     */

    public String getCapacityProviderName() {
        return this.capacityProviderName;
    }

    /**
     * <p>
     * The capacity provider that's associated with the task.
     * </p>
     * 
     * @param capacityProviderName
     *        The capacity provider that's associated with the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withCapacityProviderName(String capacityProviderName) {
        setCapacityProviderName(capacityProviderName);
        return this;
    }

    /**
     * <p>
     * The ARN of the cluster that hosts the task.
     * </p>
     * 
     * @param clusterArn
     *        The ARN of the cluster that hosts the task.
     */

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    /**
     * <p>
     * The ARN of the cluster that hosts the task.
     * </p>
     * 
     * @return The ARN of the cluster that hosts the task.
     */

    public String getClusterArn() {
        return this.clusterArn;
    }

    /**
     * <p>
     * The ARN of the cluster that hosts the task.
     * </p>
     * 
     * @param clusterArn
     *        The ARN of the cluster that hosts the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withClusterArn(String clusterArn) {
        setClusterArn(clusterArn);
        return this;
    }

    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     * 
     * @param connectivity
     *        The connectivity status of a task.
     * @see Connectivity
     */

    public void setConnectivity(String connectivity) {
        this.connectivity = connectivity;
    }

    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     * 
     * @return The connectivity status of a task.
     * @see Connectivity
     */

    public String getConnectivity() {
        return this.connectivity;
    }

    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     * 
     * @param connectivity
     *        The connectivity status of a task.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Connectivity
     */

    public Task withConnectivity(String connectivity) {
        setConnectivity(connectivity);
        return this;
    }

    /**
     * <p>
     * The connectivity status of a task.
     * </p>
     * 
     * @param connectivity
     *        The connectivity status of a task.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see Connectivity
     */

    public Task withConnectivity(Connectivity connectivity) {
        this.connectivity = connectivity.toString();
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     * </p>
     * 
     * @param connectivityAt
     *        The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     */

    public void setConnectivityAt(java.util.Date connectivityAt) {
        this.connectivityAt = connectivityAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     */

    public java.util.Date getConnectivityAt() {
        return this.connectivityAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     * </p>
     * 
     * @param connectivityAt
     *        The Unix timestamp for the time when the task last went into <code>CONNECTED</code> status.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withConnectivityAt(java.util.Date connectivityAt) {
        setConnectivityAt(connectivityAt);
        return this;
    }

    /**
     * <p>
     * The ARN of the container instances that host the task.
     * </p>
     * 
     * @param containerInstanceArn
     *        The ARN of the container instances that host the task.
     */

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    /**
     * <p>
     * The ARN of the container instances that host the task.
     * </p>
     * 
     * @return The ARN of the container instances that host the task.
     */

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    /**
     * <p>
     * The ARN of the container instances that host the task.
     * </p>
     * 
     * @param containerInstanceArn
     *        The ARN of the container instances that host the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withContainerInstanceArn(String containerInstanceArn) {
        setContainerInstanceArn(containerInstanceArn);
        return this;
    }

    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     * 
     * @return The containers that's associated with the task.
     */

    public java.util.List<Container> getContainers() {
        if (containers == null) {
            containers = new com.amazonaws.internal.SdkInternalList<Container>();
        }
        return containers;
    }

    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     * 
     * @param containers
     *        The containers that's associated with the task.
     */

    public void setContainers(java.util.Collection<Container> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }

        this.containers = new com.amazonaws.internal.SdkInternalList<Container>(containers);
    }

    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setContainers(java.util.Collection)} or {@link #withContainers(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param containers
     *        The containers that's associated with the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withContainers(Container... containers) {
        if (this.containers == null) {
            setContainers(new com.amazonaws.internal.SdkInternalList<Container>(containers.length));
        }
        for (Container ele : containers) {
            this.containers.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The containers that's associated with the task.
     * </p>
     * 
     * @param containers
     *        The containers that's associated with the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withContainers(java.util.Collection<Container> containers) {
        setContainers(containers);
        return this;
    }

    /**
     * <p>
     * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer
     * using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs (for example,
     * <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that indicates the CPU
     * units when the task definition is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (
     * <code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. These
     * values determine the range of supported values for the <code>memory</code> parameter:
     * </p>
     * <p>
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6
     * GB), 7168 (7 GB), 8192 (8 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * 16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cpu
     *        The number of CPU units used by the task as expressed in a task definition. It can be expressed as an
     *        integer using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs
     *        (for example, <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that
     *        indicates the CPU units when the task definition is registered.</p>
     *        <p>
     *        If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU
     *        units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     *        </p>
     *        <p>
     *        If you use the Fargate launch type, this field is required. You must use one of the following values.
     *        These values determine the range of supported values for the <code>memory</code> parameter:
     *        </p>
     *        <p>
     *        The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
     *        6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024
     *        (1 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024
     *        (1 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     */

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    /**
     * <p>
     * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer
     * using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs (for example,
     * <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that indicates the CPU
     * units when the task definition is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (
     * <code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. These
     * values determine the range of supported values for the <code>memory</code> parameter:
     * </p>
     * <p>
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6
     * GB), 7168 (7 GB), 8192 (8 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * 16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of CPU units used by the task as expressed in a task definition. It can be expressed as an
     *         integer using CPU units (for example, <code>1024</code>). It can also be expressed as a string using
     *         vCPUs (for example, <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an
     *         integer that indicates the CPU units when the task definition is registered.</p>
     *         <p>
     *         If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU
     *         units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     *         </p>
     *         <p>
     *         If you use the Fargate launch type, this field is required. You must use one of the following values.
     *         These values determine the range of supported values for the <code>memory</code> parameter:
     *         </p>
     *         <p>
     *         The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
     *         6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024
     *         (1 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024
     *         (1 GB)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     */

    public String getCpu() {
        return this.cpu;
    }

    /**
     * <p>
     * The number of CPU units used by the task as expressed in a task definition. It can be expressed as an integer
     * using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs (for example,
     * <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that indicates the CPU
     * units when the task definition is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU units (
     * <code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. These
     * values determine the range of supported values for the <code>memory</code> parameter:
     * </p>
     * <p>
     * The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6
     * GB), 7168 (7 GB), 8192 (8 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * </p>
     * </li>
     * <li>
     * <p>
     * 8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * 16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @param cpu
     *        The number of CPU units used by the task as expressed in a task definition. It can be expressed as an
     *        integer using CPU units (for example, <code>1024</code>). It can also be expressed as a string using vCPUs
     *        (for example, <code>1 vCPU</code> or <code>1 vcpu</code>). String values are converted to an integer that
     *        indicates the CPU units when the task definition is registered.</p>
     *        <p>
     *        If you use the EC2 launch type, this field is optional. Supported values are between <code>128</code> CPU
     *        units (<code>0.125</code> vCPUs) and <code>10240</code> CPU units (<code>10</code> vCPUs).
     *        </p>
     *        <p>
     *        If you use the Fargate launch type, this field is required. You must use one of the following values.
     *        These values determine the range of supported values for the <code>memory</code> parameter:
     *        </p>
     *        <p>
     *        The CPU units cannot be less than 1 vCPU when you use Windows containers on Fargate.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        256 (.25 vCPU) - Available <code>memory</code> values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        512 (.5 vCPU) - Available <code>memory</code> values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        1024 (1 vCPU) - Available <code>memory</code> values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB),
     *        6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        2048 (2 vCPU) - Available <code>memory</code> values: 4096 (4 GB) and 16384 (16 GB) in increments of 1024
     *        (1 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        4096 (4 vCPU) - Available <code>memory</code> values: 8192 (8 GB) and 30720 (30 GB) in increments of 1024
     *        (1 GB)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        8192 (8 vCPU) - Available <code>memory</code> values: 16 GB and 60 GB in 4 GB increments
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        16384 (16vCPU) - Available <code>memory</code> values: 32GB and 120 GB in 8 GB increments
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withCpu(String cpu) {
        setCpu(cpu);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
     * entered the <code>PENDING</code> state.
     * </p>
     * 
     * @param createdAt
     *        The Unix timestamp for the time when the task was created. More specifically, it's for the time when the
     *        task entered the <code>PENDING</code> state.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
     * entered the <code>PENDING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task was created. More specifically, it's for the time when the
     *         task entered the <code>PENDING</code> state.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was created. More specifically, it's for the time when the task
     * entered the <code>PENDING</code> state.
     * </p>
     * 
     * @param createdAt
     *        The Unix timestamp for the time when the task was created. More specifically, it's for the time when the
     *        task entered the <code>PENDING</code> state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * The desired status of the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @param desiredStatus
     *        The desired status of the task. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     */

    public void setDesiredStatus(String desiredStatus) {
        this.desiredStatus = desiredStatus;
    }

    /**
     * <p>
     * The desired status of the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @return The desired status of the task. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
     *         Lifecycle</a>.
     */

    public String getDesiredStatus() {
        return this.desiredStatus;
    }

    /**
     * <p>
     * The desired status of the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @param desiredStatus
     *        The desired status of the task. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withDesiredStatus(String desiredStatus) {
        setDesiredStatus(desiredStatus);
        return this;
    }

    /**
     * <p>
     * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     * command functionality is turned on all the containers in the task.
     * </p>
     * 
     * @param enableExecuteCommand
     *        Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     *        command functionality is turned on all the containers in the task.
     */

    public void setEnableExecuteCommand(Boolean enableExecuteCommand) {
        this.enableExecuteCommand = enableExecuteCommand;
    }

    /**
     * <p>
     * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     * command functionality is turned on all the containers in the task.
     * </p>
     * 
     * @return Determines whether execute command functionality is turned on for this task. If <code>true</code>,
     *         execute command functionality is turned on all the containers in the task.
     */

    public Boolean getEnableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    /**
     * <p>
     * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     * command functionality is turned on all the containers in the task.
     * </p>
     * 
     * @param enableExecuteCommand
     *        Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     *        command functionality is turned on all the containers in the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withEnableExecuteCommand(Boolean enableExecuteCommand) {
        setEnableExecuteCommand(enableExecuteCommand);
        return this;
    }

    /**
     * <p>
     * Determines whether execute command functionality is turned on for this task. If <code>true</code>, execute
     * command functionality is turned on all the containers in the task.
     * </p>
     * 
     * @return Determines whether execute command functionality is turned on for this task. If <code>true</code>,
     *         execute command functionality is turned on all the containers in the task.
     */

    public Boolean isEnableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task execution stopped.
     * </p>
     * 
     * @param executionStoppedAt
     *        The Unix timestamp for the time when the task execution stopped.
     */

    public void setExecutionStoppedAt(java.util.Date executionStoppedAt) {
        this.executionStoppedAt = executionStoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task execution stopped.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task execution stopped.
     */

    public java.util.Date getExecutionStoppedAt() {
        return this.executionStoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task execution stopped.
     * </p>
     * 
     * @param executionStoppedAt
     *        The Unix timestamp for the time when the task execution stopped.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withExecutionStoppedAt(java.util.Date executionStoppedAt) {
        setExecutionStoppedAt(executionStoppedAt);
        return this;
    }

    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     * 
     * @param group
     *        The name of the task group that's associated with the task.
     */

    public void setGroup(String group) {
        this.group = group;
    }

    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     * 
     * @return The name of the task group that's associated with the task.
     */

    public String getGroup() {
        return this.group;
    }

    /**
     * <p>
     * The name of the task group that's associated with the task.
     * </p>
     * 
     * @param group
     *        The name of the task group that's associated with the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withGroup(String group) {
        setGroup(group);
        return this;
    }

    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     * 
     * @param healthStatus
     *        The health status for the task. It's determined by the health of the essential containers in the task. If
     *        all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports
     *        as <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code>
     *        or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>
     *        .</p> <note>
     *        <p>
     *        The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
     *        container image and not specified in the container definition. For example, this includes those specified
     *        in a parent image or from the image's Dockerfile. Health check parameters that are specified in a
     *        container definition override any Docker health checks that are found in the container image.
     *        </p>
     * @see HealthStatus
     */

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     * 
     * @return The health status for the task. It's determined by the health of the essential containers in the task. If
     *         all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports
     *         as <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code>
     *         or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>
     *         .</p> <note>
     *         <p>
     *         The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
     *         container image and not specified in the container definition. For example, this includes those specified
     *         in a parent image or from the image's Dockerfile. Health check parameters that are specified in a
     *         container definition override any Docker health checks that are found in the container image.
     *         </p>
     * @see HealthStatus
     */

    public String getHealthStatus() {
        return this.healthStatus;
    }

    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     * 
     * @param healthStatus
     *        The health status for the task. It's determined by the health of the essential containers in the task. If
     *        all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports
     *        as <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code>
     *        or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>
     *        .</p> <note>
     *        <p>
     *        The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
     *        container image and not specified in the container definition. For example, this includes those specified
     *        in a parent image or from the image's Dockerfile. Health check parameters that are specified in a
     *        container definition override any Docker health checks that are found in the container image.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see HealthStatus
     */

    public Task withHealthStatus(String healthStatus) {
        setHealthStatus(healthStatus);
        return this;
    }

    /**
     * <p>
     * The health status for the task. It's determined by the health of the essential containers in the task. If all
     * essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports as
     * <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code> or
     * <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>.
     * </p>
     * <note>
     * <p>
     * The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a container
     * image and not specified in the container definition. For example, this includes those specified in a parent image
     * or from the image's Dockerfile. Health check parameters that are specified in a container definition override any
     * Docker health checks that are found in the container image.
     * </p>
     * </note>
     * 
     * @param healthStatus
     *        The health status for the task. It's determined by the health of the essential containers in the task. If
     *        all essential containers in the task are reporting as <code>HEALTHY</code>, the task status also reports
     *        as <code>HEALTHY</code>. If any essential containers in the task are reporting as <code>UNHEALTHY</code>
     *        or <code>UNKNOWN</code>, the task status also reports as <code>UNHEALTHY</code> or <code>UNKNOWN</code>
     *        .</p> <note>
     *        <p>
     *        The Amazon ECS container agent doesn't monitor or report on Docker health checks that are embedded in a
     *        container image and not specified in the container definition. For example, this includes those specified
     *        in a parent image or from the image's Dockerfile. Health check parameters that are specified in a
     *        container definition override any Docker health checks that are found in the container image.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see HealthStatus
     */

    public Task withHealthStatus(HealthStatus healthStatus) {
        this.healthStatus = healthStatus.toString();
        return this;
    }

    /**
     * <p>
     * The Elastic Inference accelerator that's associated with the task.
     * </p>
     * 
     * @return The Elastic Inference accelerator that's associated with the task.
     */

    public java.util.List<InferenceAccelerator> getInferenceAccelerators() {
        if (inferenceAccelerators == null) {
            inferenceAccelerators = new com.amazonaws.internal.SdkInternalList<InferenceAccelerator>();
        }
        return inferenceAccelerators;
    }

    /**
     * <p>
     * The Elastic Inference accelerator that's associated with the task.
     * </p>
     * 
     * @param inferenceAccelerators
     *        The Elastic Inference accelerator that's associated with the task.
     */

    public void setInferenceAccelerators(java.util.Collection<InferenceAccelerator> inferenceAccelerators) {
        if (inferenceAccelerators == null) {
            this.inferenceAccelerators = null;
            return;
        }

        this.inferenceAccelerators = new com.amazonaws.internal.SdkInternalList<InferenceAccelerator>(inferenceAccelerators);
    }

    /**
     * <p>
     * The Elastic Inference accelerator that's associated with the task.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInferenceAccelerators(java.util.Collection)} or
     * {@link #withInferenceAccelerators(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param inferenceAccelerators
     *        The Elastic Inference accelerator that's associated with the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withInferenceAccelerators(InferenceAccelerator... inferenceAccelerators) {
        if (this.inferenceAccelerators == null) {
            setInferenceAccelerators(new com.amazonaws.internal.SdkInternalList<InferenceAccelerator>(inferenceAccelerators.length));
        }
        for (InferenceAccelerator ele : inferenceAccelerators) {
            this.inferenceAccelerators.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The Elastic Inference accelerator that's associated with the task.
     * </p>
     * 
     * @param inferenceAccelerators
     *        The Elastic Inference accelerator that's associated with the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withInferenceAccelerators(java.util.Collection<InferenceAccelerator> inferenceAccelerators) {
        setInferenceAccelerators(inferenceAccelerators);
        return this;
    }

    /**
     * <p>
     * The last known status for the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @param lastStatus
     *        The last known status for the task. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     */

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    /**
     * <p>
     * The last known status for the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @return The last known status for the task. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task
     *         Lifecycle</a>.
     */

    public String getLastStatus() {
        return this.lastStatus;
    }

    /**
     * <p>
     * The last known status for the task. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * </p>
     * 
     * @param lastStatus
     *        The last known status for the task. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-lifecycle.html">Task Lifecycle</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withLastStatus(String lastStatus) {
        setLastStatus(lastStatus);
        return this;
    }

    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @param launchType
     *        The infrastructure where your task runs on. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */

    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The infrastructure where your task runs on. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *         types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @see LaunchType
     */

    public String getLaunchType() {
        return this.launchType;
    }

    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @param launchType
     *        The infrastructure where your task runs on. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LaunchType
     */

    public Task withLaunchType(String launchType) {
        setLaunchType(launchType);
        return this;
    }

    /**
     * <p>
     * The infrastructure where your task runs on. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a>
     * in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @param launchType
     *        The infrastructure where your task runs on. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch
     *        types</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LaunchType
     */

    public Task withLaunchType(LaunchType launchType) {
        this.launchType = launchType.toString();
        return this;
    }

    /**
     * <p>
     * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an
     * integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for example,
     * <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the task definition
     * is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional.
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. The value
     * that you choose determines the range of supported values for the <code>cpu</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     * <code>cpu</code> values: 1024 (1 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @param memory
     *        The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as
     *        an integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for
     *        example, <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the
     *        task definition is registered.</p>
     *        <p>
     *        If you use the EC2 launch type, this field is optional.
     *        </p>
     *        <p>
     *        If you use the Fargate launch type, this field is required. You must use one of the following values. The
     *        value that you choose determines the range of supported values for the <code>cpu</code> parameter.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     *        <code>cpu</code> values: 1024 (1 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *        2048 (2 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *        4096 (4 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     */

    public void setMemory(String memory) {
        this.memory = memory;
    }

    /**
     * <p>
     * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an
     * integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for example,
     * <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the task definition
     * is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional.
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. The value
     * that you choose determines the range of supported values for the <code>cpu</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     * <code>cpu</code> values: 1024 (1 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed
     *         as an integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for
     *         example, <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the
     *         task definition is registered.</p>
     *         <p>
     *         If you use the EC2 launch type, this field is optional.
     *         </p>
     *         <p>
     *         If you use the Fargate launch type, this field is required. You must use one of the following values. The
     *         value that you choose determines the range of supported values for the <code>cpu</code> parameter.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     *         <code>cpu</code> values: 1024 (1 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *         2048 (2 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *         4096 (4 vCPU)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     *         </p>
     *         <p>
     *         This option requires Linux platform <code>1.4.0</code> or later.
     *         </p>
     *         </li>
     */

    public String getMemory() {
        return this.memory;
    }

    /**
     * <p>
     * The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as an
     * integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for example,
     * <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the task definition
     * is registered.
     * </p>
     * <p>
     * If you use the EC2 launch type, this field is optional.
     * </p>
     * <p>
     * If you use the Fargate launch type, this field is required. You must use one of the following values. The value
     * that you choose determines the range of supported values for the <code>cpu</code> parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     * <code>cpu</code> values: 1024 (1 vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4
     * vCPU)
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * <li>
     * <p>
     * Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     * </p>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * </p>
     * </li>
     * </ul>
     * 
     * @param memory
     *        The amount of memory (in MiB) that the task uses as expressed in a task definition. It can be expressed as
     *        an integer using MiB (for example, <code>1024</code>). If it's expressed as a string using GB (for
     *        example, <code>1GB</code> or <code>1 GB</code>), it's converted to an integer indicating the MiB when the
     *        task definition is registered.</p>
     *        <p>
     *        If you use the EC2 launch type, this field is optional.
     *        </p>
     *        <p>
     *        If you use the Fargate launch type, this field is required. You must use one of the following values. The
     *        value that you choose determines the range of supported values for the <code>cpu</code> parameter.
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available
     *        <code>cpu</code> values: 1024 (1 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *        2048 (2 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values:
     *        4096 (4 vCPU)
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)
     *        </p>
     *        <p>
     *        This option requires Linux platform <code>1.4.0</code> or later.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withMemory(String memory) {
        setMemory(memory);
        return this;
    }

    /**
     * <p>
     * One or more container overrides.
     * </p>
     * 
     * @param overrides
     *        One or more container overrides.
     */

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    /**
     * <p>
     * One or more container overrides.
     * </p>
     * 
     * @return One or more container overrides.
     */

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    /**
     * <p>
     * One or more container overrides.
     * </p>
     * 
     * @param overrides
     *        One or more container overrides.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withOverrides(TaskOverride overrides) {
        setOverrides(overrides);
        return this;
    }

    /**
     * <p>
     * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate
     * launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @param platformVersion
     *        The platform version where your task runs on. A platform version is only specified for tasks that use the
     *        Fargate launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more
     *        information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     *        Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    /**
     * <p>
     * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate
     * launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The platform version where your task runs on. A platform version is only specified for tasks that use the
     *         Fargate launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate
     *         Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    /**
     * <p>
     * The platform version where your task runs on. A platform version is only specified for tasks that use the Fargate
     * launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more information,
     * see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     * Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @param platformVersion
     *        The platform version where your task runs on. A platform version is only specified for tasks that use the
     *        Fargate launch type. If you didn't specify one, the <code>LATEST</code> platform version is used. For more
     *        information, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform
     *        Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withPlatformVersion(String platformVersion) {
        setPlatformVersion(platformVersion);
        return this;
    }

    /**
     * <p>
     * The operating system that your tasks are running on. A platform family is specified only for tasks that use the
     * Fargate launch type.
     * </p>
     * <p>
     * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
     * (for example, <code>LINUX.</code>).
     * </p>
     * 
     * @param platformFamily
     *        The operating system that your tasks are running on. A platform family is specified only for tasks that
     *        use the Fargate launch type. </p>
     *        <p>
     *        All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
     *        service (for example, <code>LINUX.</code>).
     */

    public void setPlatformFamily(String platformFamily) {
        this.platformFamily = platformFamily;
    }

    /**
     * <p>
     * The operating system that your tasks are running on. A platform family is specified only for tasks that use the
     * Fargate launch type.
     * </p>
     * <p>
     * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
     * (for example, <code>LINUX.</code>).
     * </p>
     * 
     * @return The operating system that your tasks are running on. A platform family is specified only for tasks that
     *         use the Fargate launch type. </p>
     *         <p>
     *         All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
     *         service (for example, <code>LINUX.</code>).
     */

    public String getPlatformFamily() {
        return this.platformFamily;
    }

    /**
     * <p>
     * The operating system that your tasks are running on. A platform family is specified only for tasks that use the
     * Fargate launch type.
     * </p>
     * <p>
     * All tasks that run as part of this service must use the same <code>platformFamily</code> value as the service
     * (for example, <code>LINUX.</code>).
     * </p>
     * 
     * @param platformFamily
     *        The operating system that your tasks are running on. A platform family is specified only for tasks that
     *        use the Fargate launch type. </p>
     *        <p>
     *        All tasks that run as part of this service must use the same <code>platformFamily</code> value as the
     *        service (for example, <code>LINUX.</code>).
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withPlatformFamily(String platformFamily) {
        setPlatformFamily(platformFamily);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull began.
     * </p>
     * 
     * @param pullStartedAt
     *        The Unix timestamp for the time when the container image pull began.
     */

    public void setPullStartedAt(java.util.Date pullStartedAt) {
        this.pullStartedAt = pullStartedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull began.
     * </p>
     * 
     * @return The Unix timestamp for the time when the container image pull began.
     */

    public java.util.Date getPullStartedAt() {
        return this.pullStartedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull began.
     * </p>
     * 
     * @param pullStartedAt
     *        The Unix timestamp for the time when the container image pull began.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withPullStartedAt(java.util.Date pullStartedAt) {
        setPullStartedAt(pullStartedAt);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull completed.
     * </p>
     * 
     * @param pullStoppedAt
     *        The Unix timestamp for the time when the container image pull completed.
     */

    public void setPullStoppedAt(java.util.Date pullStoppedAt) {
        this.pullStoppedAt = pullStoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull completed.
     * </p>
     * 
     * @return The Unix timestamp for the time when the container image pull completed.
     */

    public java.util.Date getPullStoppedAt() {
        return this.pullStoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the container image pull completed.
     * </p>
     * 
     * @param pullStoppedAt
     *        The Unix timestamp for the time when the container image pull completed.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withPullStoppedAt(java.util.Date pullStoppedAt) {
        setPullStoppedAt(pullStoppedAt);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * </p>
     * 
     * @param startedAt
     *        The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     *        transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     */

    public void setStartedAt(java.util.Date startedAt) {
        this.startedAt = startedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     *         transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     */

    public java.util.Date getStartedAt() {
        return this.startedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     * transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * </p>
     * 
     * @param startedAt
     *        The Unix timestamp for the time when the task started. More specifically, it's for the time when the task
     *        transitioned from the <code>PENDING</code> state to the <code>RUNNING</code> state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withStartedAt(java.util.Date startedAt) {
        setStartedAt(startedAt);
        return this;
    }

    /**
     * <p>
     * The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code>
     * parameter contains the deployment ID of that service.
     * </p>
     * 
     * @param startedBy
     *        The tag specified when a task is started. If an Amazon ECS service started the task, the
     *        <code>startedBy</code> parameter contains the deployment ID of that service.
     */

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    /**
     * <p>
     * The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code>
     * parameter contains the deployment ID of that service.
     * </p>
     * 
     * @return The tag specified when a task is started. If an Amazon ECS service started the task, the
     *         <code>startedBy</code> parameter contains the deployment ID of that service.
     */

    public String getStartedBy() {
        return this.startedBy;
    }

    /**
     * <p>
     * The tag specified when a task is started. If an Amazon ECS service started the task, the <code>startedBy</code>
     * parameter contains the deployment ID of that service.
     * </p>
     * 
     * @param startedBy
     *        The tag specified when a task is started. If an Amazon ECS service started the task, the
     *        <code>startedBy</code> parameter contains the deployment ID of that service.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withStartedBy(String startedBy) {
        setStartedBy(startedBy);
        return this;
    }

    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * For more information about stop code, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped tasks
     * error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @param stopCode
     *        The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
     *        details. </p>
     *        <p>
     *        For more information about stop code, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped
     *        tasks error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * @see TaskStopCode
     */

    public void setStopCode(String stopCode) {
        this.stopCode = stopCode;
    }

    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * For more information about stop code, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped tasks
     * error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @return The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
     *         details. </p>
     *         <p>
     *         For more information about stop code, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped
     *         tasks error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * @see TaskStopCode
     */

    public String getStopCode() {
        return this.stopCode;
    }

    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * For more information about stop code, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped tasks
     * error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @param stopCode
     *        The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
     *        details. </p>
     *        <p>
     *        For more information about stop code, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped
     *        tasks error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TaskStopCode
     */

    public Task withStopCode(String stopCode) {
        setStopCode(stopCode);
        return this;
    }

    /**
     * <p>
     * The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional details.
     * </p>
     * <p>
     * For more information about stop code, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped tasks
     * error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * </p>
     * 
     * @param stopCode
     *        The stop code indicating why a task was stopped. The <code>stoppedReason</code> might contain additional
     *        details. </p>
     *        <p>
     *        For more information about stop code, see <a
     *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/stopped-task-error-codes.html">Stopped
     *        tasks error codes</a> in the <i>Amazon ECS Developer Guide</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TaskStopCode
     */

    public Task withStopCode(TaskStopCode stopCode) {
        this.stopCode = stopCode.toString();
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task
     * transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     * </p>
     * 
     * @param stoppedAt
     *        The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the
     *        task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     */

    public void setStoppedAt(java.util.Date stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task
     * transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the
     *         task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     */

    public java.util.Date getStoppedAt() {
        return this.stoppedAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the task
     * transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     * </p>
     * 
     * @param stoppedAt
     *        The Unix timestamp for the time when the task was stopped. More specifically, it's for the time when the
     *        task transitioned from the <code>RUNNING</code> state to the <code>STOPPED</code> state.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withStoppedAt(java.util.Date stoppedAt) {
        setStoppedAt(stoppedAt);
        return this;
    }

    /**
     * <p>
     * The reason that the task was stopped.
     * </p>
     * 
     * @param stoppedReason
     *        The reason that the task was stopped.
     */

    public void setStoppedReason(String stoppedReason) {
        this.stoppedReason = stoppedReason;
    }

    /**
     * <p>
     * The reason that the task was stopped.
     * </p>
     * 
     * @return The reason that the task was stopped.
     */

    public String getStoppedReason() {
        return this.stoppedReason;
    }

    /**
     * <p>
     * The reason that the task was stopped.
     * </p>
     * 
     * @param stoppedReason
     *        The reason that the task was stopped.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withStoppedReason(String stoppedReason) {
        setStoppedReason(stoppedReason);
        return this;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     * transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     * </p>
     * 
     * @param stoppingAt
     *        The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     *        transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     */

    public void setStoppingAt(java.util.Date stoppingAt) {
        this.stoppingAt = stoppingAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     * transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     * </p>
     * 
     * @return The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     *         transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     */

    public java.util.Date getStoppingAt() {
        return this.stoppingAt;
    }

    /**
     * <p>
     * The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     * transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     * </p>
     * 
     * @param stoppingAt
     *        The Unix timestamp for the time when the task stops. More specifically, it's for the time when the task
     *        transitions from the <code>RUNNING</code> state to <code>STOPPING</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withStoppingAt(java.util.Date stoppingAt) {
        setStoppingAt(stoppingAt);
        return this;
    }

    /**
     * <p>
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key
     * and an optional value. You define both the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The metadata that you apply to the task to help you categorize and organize the task. Each tag consists
     *         of a key and an optional value. You define both the key and value.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete
     *         tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource
     *         limit.
     *         </p>
     *         </li>
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key
     * and an optional value. You define both the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * 
     * @param tags
     *        The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of
     *        a key and an optional value. You define both the key and value.</p>
     *        <p>
     *        The following basic restrictions apply to tags:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Maximum number of tags per resource - 50
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For each resource, each tag key must be unique, and each tag key can have only one value.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Maximum key length - 128 Unicode characters in UTF-8
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Maximum value length - 256 Unicode characters in UTF-8
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If your tagging schema is used across multiple services and resources, remember that other services may
     *        have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *        representable in UTF-8, and the following characters: + - = . _ : / @.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Tag keys and values are case-sensitive.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
     *        for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag
     *        keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     *        </p>
     *        </li>
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key
     * and an optional value. You define both the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of
     *        a key and an optional value. You define both the key and value.</p>
     *        <p>
     *        The following basic restrictions apply to tags:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Maximum number of tags per resource - 50
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For each resource, each tag key must be unique, and each tag key can have only one value.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Maximum key length - 128 Unicode characters in UTF-8
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Maximum value length - 256 Unicode characters in UTF-8
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If your tagging schema is used across multiple services and resources, remember that other services may
     *        have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *        representable in UTF-8, and the following characters: + - = . _ : / @.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Tag keys and values are case-sensitive.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
     *        for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag
     *        keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of a key
     * and an optional value. You define both the key and value.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values
     * with this prefix. Tags with this prefix do not count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * 
     * @param tags
     *        The metadata that you apply to the task to help you categorize and organize the task. Each tag consists of
     *        a key and an optional value. You define both the key and value.</p>
     *        <p>
     *        The following basic restrictions apply to tags:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Maximum number of tags per resource - 50
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        For each resource, each tag key must be unique, and each tag key can have only one value.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Maximum key length - 128 Unicode characters in UTF-8
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Maximum value length - 256 Unicode characters in UTF-8
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        If your tagging schema is used across multiple services and resources, remember that other services may
     *        have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *        representable in UTF-8, and the following characters: + - = . _ : / @.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Tag keys and values are case-sensitive.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
     *        for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag
     *        keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @param taskArn
     *        The Amazon Resource Name (ARN) of the task.
     */

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the task.
     */

    public String getTaskArn() {
        return this.taskArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the task.
     * </p>
     * 
     * @param taskArn
     *        The Amazon Resource Name (ARN) of the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withTaskArn(String taskArn) {
        setTaskArn(taskArn);
        return this;
    }

    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     * 
     * @param taskDefinitionArn
     *        The ARN of the task definition that creates the task.
     */

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     * 
     * @return The ARN of the task definition that creates the task.
     */

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    /**
     * <p>
     * The ARN of the task definition that creates the task.
     * </p>
     * 
     * @param taskDefinitionArn
     *        The ARN of the task definition that creates the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withTaskDefinitionArn(String taskDefinitionArn) {
        setTaskDefinitionArn(taskDefinitionArn);
        return this;
    }

    /**
     * <p>
     * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the
     * version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can
     * compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch
     * Events for the task (inside the <code>detail</code> object) to verify that the version in your event stream is
     * current.
     * </p>
     * 
     * @param version
     *        The version counter for the task. Every time a task experiences a change that starts a CloudWatch event,
     *        the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events,
     *        you can compare the version of a task reported by the Amazon ECS API actions with the version reported in
     *        CloudWatch Events for the task (inside the <code>detail</code> object) to verify that the version in your
     *        event stream is current.
     */

    public void setVersion(Long version) {
        this.version = version;
    }

    /**
     * <p>
     * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the
     * version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can
     * compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch
     * Events for the task (inside the <code>detail</code> object) to verify that the version in your event stream is
     * current.
     * </p>
     * 
     * @return The version counter for the task. Every time a task experiences a change that starts a CloudWatch event,
     *         the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events,
     *         you can compare the version of a task reported by the Amazon ECS API actions with the version reported in
     *         CloudWatch Events for the task (inside the <code>detail</code> object) to verify that the version in your
     *         event stream is current.
     */

    public Long getVersion() {
        return this.version;
    }

    /**
     * <p>
     * The version counter for the task. Every time a task experiences a change that starts a CloudWatch event, the
     * version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events, you can
     * compare the version of a task reported by the Amazon ECS API actions with the version reported in CloudWatch
     * Events for the task (inside the <code>detail</code> object) to verify that the version in your event stream is
     * current.
     * </p>
     * 
     * @param version
     *        The version counter for the task. Every time a task experiences a change that starts a CloudWatch event,
     *        the version counter is incremented. If you replicate your Amazon ECS task state with CloudWatch Events,
     *        you can compare the version of a task reported by the Amazon ECS API actions with the version reported in
     *        CloudWatch Events for the task (inside the <code>detail</code> object) to verify that the version in your
     *        event stream is current.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withVersion(Long version) {
        setVersion(version);
        return this;
    }

    /**
     * <p>
     * The ephemeral storage settings for the task.
     * </p>
     * 
     * @param ephemeralStorage
     *        The ephemeral storage settings for the task.
     */

    public void setEphemeralStorage(EphemeralStorage ephemeralStorage) {
        this.ephemeralStorage = ephemeralStorage;
    }

    /**
     * <p>
     * The ephemeral storage settings for the task.
     * </p>
     * 
     * @return The ephemeral storage settings for the task.
     */

    public EphemeralStorage getEphemeralStorage() {
        return this.ephemeralStorage;
    }

    /**
     * <p>
     * The ephemeral storage settings for the task.
     * </p>
     * 
     * @param ephemeralStorage
     *        The ephemeral storage settings for the task.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public Task withEphemeralStorage(EphemeralStorage ephemeralStorage) {
        setEphemeralStorage(ephemeralStorage);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAttachments() != null)
            sb.append("Attachments: ").append(getAttachments()).append(",");
        if (getAttributes() != null)
            sb.append("Attributes: ").append(getAttributes()).append(",");
        if (getAvailabilityZone() != null)
            sb.append("AvailabilityZone: ").append(getAvailabilityZone()).append(",");
        if (getCapacityProviderName() != null)
            sb.append("CapacityProviderName: ").append(getCapacityProviderName()).append(",");
        if (getClusterArn() != null)
            sb.append("ClusterArn: ").append(getClusterArn()).append(",");
        if (getConnectivity() != null)
            sb.append("Connectivity: ").append(getConnectivity()).append(",");
        if (getConnectivityAt() != null)
            sb.append("ConnectivityAt: ").append(getConnectivityAt()).append(",");
        if (getContainerInstanceArn() != null)
            sb.append("ContainerInstanceArn: ").append(getContainerInstanceArn()).append(",");
        if (getContainers() != null)
            sb.append("Containers: ").append(getContainers()).append(",");
        if (getCpu() != null)
            sb.append("Cpu: ").append(getCpu()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getDesiredStatus() != null)
            sb.append("DesiredStatus: ").append(getDesiredStatus()).append(",");
        if (getEnableExecuteCommand() != null)
            sb.append("EnableExecuteCommand: ").append(getEnableExecuteCommand()).append(",");
        if (getExecutionStoppedAt() != null)
            sb.append("ExecutionStoppedAt: ").append(getExecutionStoppedAt()).append(",");
        if (getGroup() != null)
            sb.append("Group: ").append(getGroup()).append(",");
        if (getHealthStatus() != null)
            sb.append("HealthStatus: ").append(getHealthStatus()).append(",");
        if (getInferenceAccelerators() != null)
            sb.append("InferenceAccelerators: ").append(getInferenceAccelerators()).append(",");
        if (getLastStatus() != null)
            sb.append("LastStatus: ").append(getLastStatus()).append(",");
        if (getLaunchType() != null)
            sb.append("LaunchType: ").append(getLaunchType()).append(",");
        if (getMemory() != null)
            sb.append("Memory: ").append(getMemory()).append(",");
        if (getOverrides() != null)
            sb.append("Overrides: ").append(getOverrides()).append(",");
        if (getPlatformVersion() != null)
            sb.append("PlatformVersion: ").append(getPlatformVersion()).append(",");
        if (getPlatformFamily() != null)
            sb.append("PlatformFamily: ").append(getPlatformFamily()).append(",");
        if (getPullStartedAt() != null)
            sb.append("PullStartedAt: ").append(getPullStartedAt()).append(",");
        if (getPullStoppedAt() != null)
            sb.append("PullStoppedAt: ").append(getPullStoppedAt()).append(",");
        if (getStartedAt() != null)
            sb.append("StartedAt: ").append(getStartedAt()).append(",");
        if (getStartedBy() != null)
            sb.append("StartedBy: ").append(getStartedBy()).append(",");
        if (getStopCode() != null)
            sb.append("StopCode: ").append(getStopCode()).append(",");
        if (getStoppedAt() != null)
            sb.append("StoppedAt: ").append(getStoppedAt()).append(",");
        if (getStoppedReason() != null)
            sb.append("StoppedReason: ").append(getStoppedReason()).append(",");
        if (getStoppingAt() != null)
            sb.append("StoppingAt: ").append(getStoppingAt()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags()).append(",");
        if (getTaskArn() != null)
            sb.append("TaskArn: ").append(getTaskArn()).append(",");
        if (getTaskDefinitionArn() != null)
            sb.append("TaskDefinitionArn: ").append(getTaskDefinitionArn()).append(",");
        if (getVersion() != null)
            sb.append("Version: ").append(getVersion()).append(",");
        if (getEphemeralStorage() != null)
            sb.append("EphemeralStorage: ").append(getEphemeralStorage());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof Task == false)
            return false;
        Task other = (Task) obj;
        if (other.getAttachments() == null ^ this.getAttachments() == null)
            return false;
        if (other.getAttachments() != null && other.getAttachments().equals(this.getAttachments()) == false)
            return false;
        if (other.getAttributes() == null ^ this.getAttributes() == null)
            return false;
        if (other.getAttributes() != null && other.getAttributes().equals(this.getAttributes()) == false)
            return false;
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null)
            return false;
        if (other.getAvailabilityZone() != null && other.getAvailabilityZone().equals(this.getAvailabilityZone()) == false)
            return false;
        if (other.getCapacityProviderName() == null ^ this.getCapacityProviderName() == null)
            return false;
        if (other.getCapacityProviderName() != null && other.getCapacityProviderName().equals(this.getCapacityProviderName()) == false)
            return false;
        if (other.getClusterArn() == null ^ this.getClusterArn() == null)
            return false;
        if (other.getClusterArn() != null && other.getClusterArn().equals(this.getClusterArn()) == false)
            return false;
        if (other.getConnectivity() == null ^ this.getConnectivity() == null)
            return false;
        if (other.getConnectivity() != null && other.getConnectivity().equals(this.getConnectivity()) == false)
            return false;
        if (other.getConnectivityAt() == null ^ this.getConnectivityAt() == null)
            return false;
        if (other.getConnectivityAt() != null && other.getConnectivityAt().equals(this.getConnectivityAt()) == false)
            return false;
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null)
            return false;
        if (other.getContainerInstanceArn() != null && other.getContainerInstanceArn().equals(this.getContainerInstanceArn()) == false)
            return false;
        if (other.getContainers() == null ^ this.getContainers() == null)
            return false;
        if (other.getContainers() != null && other.getContainers().equals(this.getContainers()) == false)
            return false;
        if (other.getCpu() == null ^ this.getCpu() == null)
            return false;
        if (other.getCpu() != null && other.getCpu().equals(this.getCpu()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getDesiredStatus() == null ^ this.getDesiredStatus() == null)
            return false;
        if (other.getDesiredStatus() != null && other.getDesiredStatus().equals(this.getDesiredStatus()) == false)
            return false;
        if (other.getEnableExecuteCommand() == null ^ this.getEnableExecuteCommand() == null)
            return false;
        if (other.getEnableExecuteCommand() != null && other.getEnableExecuteCommand().equals(this.getEnableExecuteCommand()) == false)
            return false;
        if (other.getExecutionStoppedAt() == null ^ this.getExecutionStoppedAt() == null)
            return false;
        if (other.getExecutionStoppedAt() != null && other.getExecutionStoppedAt().equals(this.getExecutionStoppedAt()) == false)
            return false;
        if (other.getGroup() == null ^ this.getGroup() == null)
            return false;
        if (other.getGroup() != null && other.getGroup().equals(this.getGroup()) == false)
            return false;
        if (other.getHealthStatus() == null ^ this.getHealthStatus() == null)
            return false;
        if (other.getHealthStatus() != null && other.getHealthStatus().equals(this.getHealthStatus()) == false)
            return false;
        if (other.getInferenceAccelerators() == null ^ this.getInferenceAccelerators() == null)
            return false;
        if (other.getInferenceAccelerators() != null && other.getInferenceAccelerators().equals(this.getInferenceAccelerators()) == false)
            return false;
        if (other.getLastStatus() == null ^ this.getLastStatus() == null)
            return false;
        if (other.getLastStatus() != null && other.getLastStatus().equals(this.getLastStatus()) == false)
            return false;
        if (other.getLaunchType() == null ^ this.getLaunchType() == null)
            return false;
        if (other.getLaunchType() != null && other.getLaunchType().equals(this.getLaunchType()) == false)
            return false;
        if (other.getMemory() == null ^ this.getMemory() == null)
            return false;
        if (other.getMemory() != null && other.getMemory().equals(this.getMemory()) == false)
            return false;
        if (other.getOverrides() == null ^ this.getOverrides() == null)
            return false;
        if (other.getOverrides() != null && other.getOverrides().equals(this.getOverrides()) == false)
            return false;
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null)
            return false;
        if (other.getPlatformVersion() != null && other.getPlatformVersion().equals(this.getPlatformVersion()) == false)
            return false;
        if (other.getPlatformFamily() == null ^ this.getPlatformFamily() == null)
            return false;
        if (other.getPlatformFamily() != null && other.getPlatformFamily().equals(this.getPlatformFamily()) == false)
            return false;
        if (other.getPullStartedAt() == null ^ this.getPullStartedAt() == null)
            return false;
        if (other.getPullStartedAt() != null && other.getPullStartedAt().equals(this.getPullStartedAt()) == false)
            return false;
        if (other.getPullStoppedAt() == null ^ this.getPullStoppedAt() == null)
            return false;
        if (other.getPullStoppedAt() != null && other.getPullStoppedAt().equals(this.getPullStoppedAt()) == false)
            return false;
        if (other.getStartedAt() == null ^ this.getStartedAt() == null)
            return false;
        if (other.getStartedAt() != null && other.getStartedAt().equals(this.getStartedAt()) == false)
            return false;
        if (other.getStartedBy() == null ^ this.getStartedBy() == null)
            return false;
        if (other.getStartedBy() != null && other.getStartedBy().equals(this.getStartedBy()) == false)
            return false;
        if (other.getStopCode() == null ^ this.getStopCode() == null)
            return false;
        if (other.getStopCode() != null && other.getStopCode().equals(this.getStopCode()) == false)
            return false;
        if (other.getStoppedAt() == null ^ this.getStoppedAt() == null)
            return false;
        if (other.getStoppedAt() != null && other.getStoppedAt().equals(this.getStoppedAt()) == false)
            return false;
        if (other.getStoppedReason() == null ^ this.getStoppedReason() == null)
            return false;
        if (other.getStoppedReason() != null && other.getStoppedReason().equals(this.getStoppedReason()) == false)
            return false;
        if (other.getStoppingAt() == null ^ this.getStoppingAt() == null)
            return false;
        if (other.getStoppingAt() != null && other.getStoppingAt().equals(this.getStoppingAt()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        if (other.getTaskArn() == null ^ this.getTaskArn() == null)
            return false;
        if (other.getTaskArn() != null && other.getTaskArn().equals(this.getTaskArn()) == false)
            return false;
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null)
            return false;
        if (other.getTaskDefinitionArn() != null && other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn()) == false)
            return false;
        if (other.getVersion() == null ^ this.getVersion() == null)
            return false;
        if (other.getVersion() != null && other.getVersion().equals(this.getVersion()) == false)
            return false;
        if (other.getEphemeralStorage() == null ^ this.getEphemeralStorage() == null)
            return false;
        if (other.getEphemeralStorage() != null && other.getEphemeralStorage().equals(this.getEphemeralStorage()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAttachments() == null) ? 0 : getAttachments().hashCode());
        hashCode = prime * hashCode + ((getAttributes() == null) ? 0 : getAttributes().hashCode());
        hashCode = prime * hashCode + ((getAvailabilityZone() == null) ? 0 : getAvailabilityZone().hashCode());
        hashCode = prime * hashCode + ((getCapacityProviderName() == null) ? 0 : getCapacityProviderName().hashCode());
        hashCode = prime * hashCode + ((getClusterArn() == null) ? 0 : getClusterArn().hashCode());
        hashCode = prime * hashCode + ((getConnectivity() == null) ? 0 : getConnectivity().hashCode());
        hashCode = prime * hashCode + ((getConnectivityAt() == null) ? 0 : getConnectivityAt().hashCode());
        hashCode = prime * hashCode + ((getContainerInstanceArn() == null) ? 0 : getContainerInstanceArn().hashCode());
        hashCode = prime * hashCode + ((getContainers() == null) ? 0 : getContainers().hashCode());
        hashCode = prime * hashCode + ((getCpu() == null) ? 0 : getCpu().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getDesiredStatus() == null) ? 0 : getDesiredStatus().hashCode());
        hashCode = prime * hashCode + ((getEnableExecuteCommand() == null) ? 0 : getEnableExecuteCommand().hashCode());
        hashCode = prime * hashCode + ((getExecutionStoppedAt() == null) ? 0 : getExecutionStoppedAt().hashCode());
        hashCode = prime * hashCode + ((getGroup() == null) ? 0 : getGroup().hashCode());
        hashCode = prime * hashCode + ((getHealthStatus() == null) ? 0 : getHealthStatus().hashCode());
        hashCode = prime * hashCode + ((getInferenceAccelerators() == null) ? 0 : getInferenceAccelerators().hashCode());
        hashCode = prime * hashCode + ((getLastStatus() == null) ? 0 : getLastStatus().hashCode());
        hashCode = prime * hashCode + ((getLaunchType() == null) ? 0 : getLaunchType().hashCode());
        hashCode = prime * hashCode + ((getMemory() == null) ? 0 : getMemory().hashCode());
        hashCode = prime * hashCode + ((getOverrides() == null) ? 0 : getOverrides().hashCode());
        hashCode = prime * hashCode + ((getPlatformVersion() == null) ? 0 : getPlatformVersion().hashCode());
        hashCode = prime * hashCode + ((getPlatformFamily() == null) ? 0 : getPlatformFamily().hashCode());
        hashCode = prime * hashCode + ((getPullStartedAt() == null) ? 0 : getPullStartedAt().hashCode());
        hashCode = prime * hashCode + ((getPullStoppedAt() == null) ? 0 : getPullStoppedAt().hashCode());
        hashCode = prime * hashCode + ((getStartedAt() == null) ? 0 : getStartedAt().hashCode());
        hashCode = prime * hashCode + ((getStartedBy() == null) ? 0 : getStartedBy().hashCode());
        hashCode = prime * hashCode + ((getStopCode() == null) ? 0 : getStopCode().hashCode());
        hashCode = prime * hashCode + ((getStoppedAt() == null) ? 0 : getStoppedAt().hashCode());
        hashCode = prime * hashCode + ((getStoppedReason() == null) ? 0 : getStoppedReason().hashCode());
        hashCode = prime * hashCode + ((getStoppingAt() == null) ? 0 : getStoppingAt().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        hashCode = prime * hashCode + ((getTaskArn() == null) ? 0 : getTaskArn().hashCode());
        hashCode = prime * hashCode + ((getTaskDefinitionArn() == null) ? 0 : getTaskDefinitionArn().hashCode());
        hashCode = prime * hashCode + ((getVersion() == null) ? 0 : getVersion().hashCode());
        hashCode = prime * hashCode + ((getEphemeralStorage() == null) ? 0 : getEphemeralStorage().hashCode());
        return hashCode;
    }

    @Override
    public Task clone() {
        try {
            return (Task) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.ecs.model.transform.TaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
