/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.NetworkBinding;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Container
implements Serializable {
    private String containerArn;
    private String taskArn;
    private String name;
    private String lastStatus;
    private Integer exitCode;
    private String reason;
    private ListWithAutoConstructFlag<NetworkBinding> networkBindings;

    public String getContainerArn() {
        return this.containerArn;
    }

    public void setContainerArn(String containerArn) {
        this.containerArn = containerArn;
    }

    public Container withContainerArn(String containerArn) {
        this.containerArn = containerArn;
        return this;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public Container withTaskArn(String taskArn) {
        this.taskArn = taskArn;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public Container withLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
        return this;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public Container withExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Container withReason(String reason) {
        this.reason = reason;
        return this;
    }

    public List<NetworkBinding> getNetworkBindings() {
        if (this.networkBindings == null) {
            this.networkBindings = new ListWithAutoConstructFlag();
            this.networkBindings.setAutoConstruct(true);
        }
        return this.networkBindings;
    }

    public void setNetworkBindings(Collection<NetworkBinding> networkBindings) {
        if (networkBindings == null) {
            this.networkBindings = null;
            return;
        }
        ListWithAutoConstructFlag networkBindingsCopy = new ListWithAutoConstructFlag(networkBindings.size());
        networkBindingsCopy.addAll(networkBindings);
        this.networkBindings = networkBindingsCopy;
    }

    public Container withNetworkBindings(NetworkBinding ... networkBindings) {
        if (this.getNetworkBindings() == null) {
            this.setNetworkBindings(new ArrayList<NetworkBinding>(networkBindings.length));
        }
        for (NetworkBinding value : networkBindings) {
            this.getNetworkBindings().add(value);
        }
        return this;
    }

    public Container withNetworkBindings(Collection<NetworkBinding> networkBindings) {
        if (networkBindings == null) {
            this.networkBindings = null;
        } else {
            ListWithAutoConstructFlag networkBindingsCopy = new ListWithAutoConstructFlag(networkBindings.size());
            networkBindingsCopy.addAll(networkBindings);
            this.networkBindings = networkBindingsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerArn() != null) {
            sb.append("ContainerArn: " + this.getContainerArn() + ",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: " + this.getTaskArn() + ",");
        }
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: " + this.getLastStatus() + ",");
        }
        if (this.getExitCode() != null) {
            sb.append("ExitCode: " + this.getExitCode() + ",");
        }
        if (this.getReason() != null) {
            sb.append("Reason: " + this.getReason() + ",");
        }
        if (this.getNetworkBindings() != null) {
            sb.append("NetworkBindings: " + this.getNetworkBindings());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerArn() == null ? 0 : this.getContainerArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getExitCode() == null ? 0 : this.getExitCode().hashCode());
        hashCode = 31 * hashCode + (this.getReason() == null ? 0 : this.getReason().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBindings() == null ? 0 : this.getNetworkBindings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        if (other.getContainerArn() == null ^ this.getContainerArn() == null) {
            return false;
        }
        if (other.getContainerArn() != null && !other.getContainerArn().equals(this.getContainerArn())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getExitCode() == null ^ this.getExitCode() == null) {
            return false;
        }
        if (other.getExitCode() != null && !other.getExitCode().equals(this.getExitCode())) {
            return false;
        }
        if (other.getReason() == null ^ this.getReason() == null) {
            return false;
        }
        if (other.getReason() != null && !other.getReason().equals(this.getReason())) {
            return false;
        }
        if (other.getNetworkBindings() == null ^ this.getNetworkBindings() == null) {
            return false;
        }
        return other.getNetworkBindings() == null || other.getNetworkBindings().equals(this.getNetworkBindings());
    }
}

