/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeContainerInstancesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cluster;
    private ListWithAutoConstructFlag<String> containerInstances;

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public DescribeContainerInstancesRequest withCluster(String cluster) {
        this.cluster = cluster;
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new ListWithAutoConstructFlag();
            this.containerInstances.setAutoConstruct(true);
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        ListWithAutoConstructFlag containerInstancesCopy = new ListWithAutoConstructFlag(containerInstances.size());
        containerInstancesCopy.addAll(containerInstances);
        this.containerInstances = containerInstancesCopy;
    }

    public DescribeContainerInstancesRequest withContainerInstances(String ... containerInstances) {
        if (this.getContainerInstances() == null) {
            this.setContainerInstances(new ArrayList<String>(containerInstances.length));
        }
        for (String value : containerInstances) {
            this.getContainerInstances().add(value);
        }
        return this;
    }

    public DescribeContainerInstancesRequest withContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
        } else {
            ListWithAutoConstructFlag containerInstancesCopy = new ListWithAutoConstructFlag(containerInstances.size());
            containerInstancesCopy.addAll(containerInstances);
            this.containerInstances = containerInstancesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: " + this.getCluster() + ",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: " + this.getContainerInstances());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContainerInstancesRequest)) {
            return false;
        }
        DescribeContainerInstancesRequest other = (DescribeContainerInstancesRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        return other.getContainerInstances() == null || other.getContainerInstances().equals(this.getContainerInstances());
    }
}

