/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemAsync;
import com.amazonaws.services.elasticfilesystem.AmazonElasticFileSystemClient;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemResult;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.CreateMountTargetResult;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteFileSystemRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.services.elasticfilesystem.model.DeleteTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeFileSystemsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetSecurityGroupsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsResult;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsResult;
import com.amazonaws.services.elasticfilesystem.model.ModifyMountTargetSecurityGroupsRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonElasticFileSystemAsyncClient
extends AmazonElasticFileSystemClient
implements AmazonElasticFileSystemAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonElasticFileSystemAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonElasticFileSystemAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, new ClientConfiguration(), executorService);
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElasticFileSystemAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(final CreateFileSystemRequest createFileSystemRequest) {
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() {
                return AmazonElasticFileSystemAsyncClient.this.createFileSystem(createFileSystemRequest);
            }
        });
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(final CreateFileSystemRequest createFileSystemRequest, final AsyncHandler<CreateFileSystemRequest, CreateFileSystemResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                CreateFileSystemResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.createFileSystem(createFileSystemRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createFileSystemRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(final CreateMountTargetRequest createMountTargetRequest) {
        return this.executorService.submit(new Callable<CreateMountTargetResult>(){

            @Override
            public CreateMountTargetResult call() {
                return AmazonElasticFileSystemAsyncClient.this.createMountTarget(createMountTargetRequest);
            }
        });
    }

    @Override
    public Future<CreateMountTargetResult> createMountTargetAsync(final CreateMountTargetRequest createMountTargetRequest, final AsyncHandler<CreateMountTargetRequest, CreateMountTargetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateMountTargetResult>(){

            @Override
            public CreateMountTargetResult call() throws Exception {
                CreateMountTargetResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.createMountTarget(createMountTargetRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createMountTargetRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AmazonElasticFileSystemAsyncClient.this.createTags(createTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createTagsAsync(final CreateTagsRequest createTagsRequest, final AsyncHandler<CreateTagsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticFileSystemAsyncClient.this.createTags(createTagsRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteFileSystemAsync(final DeleteFileSystemRequest deleteFileSystemRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AmazonElasticFileSystemAsyncClient.this.deleteFileSystem(deleteFileSystemRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteFileSystemAsync(final DeleteFileSystemRequest deleteFileSystemRequest, final AsyncHandler<DeleteFileSystemRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticFileSystemAsyncClient.this.deleteFileSystem(deleteFileSystemRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteFileSystemRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteMountTargetAsync(final DeleteMountTargetRequest deleteMountTargetRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AmazonElasticFileSystemAsyncClient.this.deleteMountTarget(deleteMountTargetRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMountTargetAsync(final DeleteMountTargetRequest deleteMountTargetRequest, final AsyncHandler<DeleteMountTargetRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticFileSystemAsyncClient.this.deleteMountTarget(deleteMountTargetRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteMountTargetRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AmazonElasticFileSystemAsyncClient.this.deleteTags(deleteTagsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTagsAsync(final DeleteTagsRequest deleteTagsRequest, final AsyncHandler<DeleteTagsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticFileSystemAsyncClient.this.deleteTags(deleteTagsRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTagsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(final DescribeFileSystemsRequest describeFileSystemsRequest) {
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() {
                return AmazonElasticFileSystemAsyncClient.this.describeFileSystems(describeFileSystemsRequest);
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(final DescribeFileSystemsRequest describeFileSystemsRequest, final AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                DescribeFileSystemsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeFileSystems(describeFileSystemsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeFileSystemsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync() {
        return this.describeFileSystemsAsync(new DescribeFileSystemsRequest());
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        return this.describeFileSystemsAsync(new DescribeFileSystemsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(final DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest) {
        return this.executorService.submit(new Callable<DescribeMountTargetSecurityGroupsResult>(){

            @Override
            public DescribeMountTargetSecurityGroupsResult call() {
                return AmazonElasticFileSystemAsyncClient.this.describeMountTargetSecurityGroups(describeMountTargetSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeMountTargetSecurityGroupsResult> describeMountTargetSecurityGroupsAsync(final DescribeMountTargetSecurityGroupsRequest describeMountTargetSecurityGroupsRequest, final AsyncHandler<DescribeMountTargetSecurityGroupsRequest, DescribeMountTargetSecurityGroupsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeMountTargetSecurityGroupsResult>(){

            @Override
            public DescribeMountTargetSecurityGroupsResult call() throws Exception {
                DescribeMountTargetSecurityGroupsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeMountTargetSecurityGroups(describeMountTargetSecurityGroupsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeMountTargetSecurityGroupsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(final DescribeMountTargetsRequest describeMountTargetsRequest) {
        return this.executorService.submit(new Callable<DescribeMountTargetsResult>(){

            @Override
            public DescribeMountTargetsResult call() {
                return AmazonElasticFileSystemAsyncClient.this.describeMountTargets(describeMountTargetsRequest);
            }
        });
    }

    @Override
    public Future<DescribeMountTargetsResult> describeMountTargetsAsync(final DescribeMountTargetsRequest describeMountTargetsRequest, final AsyncHandler<DescribeMountTargetsRequest, DescribeMountTargetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeMountTargetsResult>(){

            @Override
            public DescribeMountTargetsResult call() throws Exception {
                DescribeMountTargetsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeMountTargets(describeMountTargetsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeMountTargetsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() {
                return AmazonElasticFileSystemAsyncClient.this.describeTags(describeTagsRequest);
            }
        });
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest describeTagsRequest, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonElasticFileSystemAsyncClient.this.describeTags(describeTagsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)describeTagsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> modifyMountTargetSecurityGroupsAsync(final ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                AmazonElasticFileSystemAsyncClient.this.modifyMountTargetSecurityGroups(modifyMountTargetSecurityGroupsRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> modifyMountTargetSecurityGroupsAsync(final ModifyMountTargetSecurityGroupsRequest modifyMountTargetSecurityGroupsRequest, final AsyncHandler<ModifyMountTargetSecurityGroupsRequest, Void> asyncHandler) {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result;
                try {
                    AmazonElasticFileSystemAsyncClient.this.modifyMountTargetSecurityGroups(modifyMountTargetSecurityGroupsRequest);
                    result = null;
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)modifyMountTargetSecurityGroupsRequest, result);
                return result;
            }
        });
    }
}

