/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.CreateTagsRequest;
import com.amazonaws.services.elasticfilesystem.model.Tag;
import com.amazonaws.services.elasticfilesystem.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateTagsRequestMarshaller
implements Marshaller<Request<CreateTagsRequest>, CreateTagsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreateTagsRequest> marshall(CreateTagsRequest createTagsRequest) {
        if (createTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTagsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-02-01/create-tags/{FileSystemId}";
        uriResourcePath = uriResourcePath.replace("{FileSystemId}", createTagsRequest.getFileSystemId() != null ? StringUtils.fromString((String)createTagsRequest.getFileSystemId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            SdkInternalList tagsList = (SdkInternalList)createTagsRequest.getTags();
            if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
                jsonWriter.key("Tags");
                jsonWriter.array();
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

