/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import com.amazonaws.services.elasticfilesystem.model.transform.FileSystemSizeJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;

public class FileSystemDescriptionJsonMarshaller {
    private static FileSystemDescriptionJsonMarshaller instance;

    public void marshall(FileSystemDescription fileSystemDescription, SdkJsonGenerator jsonGenerator) {
        if (fileSystemDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (fileSystemDescription.getOwnerId() != null) {
                jsonGenerator.writeFieldName("OwnerId").writeValue(fileSystemDescription.getOwnerId());
            }
            if (fileSystemDescription.getCreationToken() != null) {
                jsonGenerator.writeFieldName("CreationToken").writeValue(fileSystemDescription.getCreationToken());
            }
            if (fileSystemDescription.getFileSystemId() != null) {
                jsonGenerator.writeFieldName("FileSystemId").writeValue(fileSystemDescription.getFileSystemId());
            }
            if (fileSystemDescription.getCreationTime() != null) {
                jsonGenerator.writeFieldName("CreationTime").writeValue(fileSystemDescription.getCreationTime());
            }
            if (fileSystemDescription.getLifeCycleState() != null) {
                jsonGenerator.writeFieldName("LifeCycleState").writeValue(fileSystemDescription.getLifeCycleState());
            }
            if (fileSystemDescription.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(fileSystemDescription.getName());
            }
            if (fileSystemDescription.getNumberOfMountTargets() != null) {
                jsonGenerator.writeFieldName("NumberOfMountTargets").writeValue((long)fileSystemDescription.getNumberOfMountTargets().intValue());
            }
            if (fileSystemDescription.getSizeInBytes() != null) {
                jsonGenerator.writeFieldName("SizeInBytes");
                FileSystemSizeJsonMarshaller.getInstance().marshall(fileSystemDescription.getSizeInBytes(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FileSystemDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FileSystemDescriptionJsonMarshaller();
        }
        return instance;
    }
}

