/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticfilesystem.model.DeleteMountTargetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteMountTargetRequestMarshaller
implements Marshaller<Request<DeleteMountTargetRequest>, DeleteMountTargetRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteMountTargetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteMountTargetRequest> marshall(DeleteMountTargetRequest deleteMountTargetRequest) {
        if (deleteMountTargetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMountTargetRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-02-01/mount-targets/{MountTargetId}";
        uriResourcePath = uriResourcePath.replace("{MountTargetId}", deleteMountTargetRequest.getMountTargetId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteMountTargetRequest.getMountTargetId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

