/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.eks.model.EksAnywhereSubscriptionStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListEksAnywhereSubscriptionsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Integer maxResults;
    private String nextToken;
    private List<String> includeStatus;

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListEksAnywhereSubscriptionsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListEksAnywhereSubscriptionsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getIncludeStatus() {
        return this.includeStatus;
    }

    public void setIncludeStatus(Collection<String> includeStatus) {
        if (includeStatus == null) {
            this.includeStatus = null;
            return;
        }
        this.includeStatus = new ArrayList<String>(includeStatus);
    }

    public ListEksAnywhereSubscriptionsRequest withIncludeStatus(String ... includeStatus) {
        if (this.includeStatus == null) {
            this.setIncludeStatus(new ArrayList<String>(includeStatus.length));
        }
        for (String ele : includeStatus) {
            this.includeStatus.add(ele);
        }
        return this;
    }

    public ListEksAnywhereSubscriptionsRequest withIncludeStatus(Collection<String> includeStatus) {
        this.setIncludeStatus(includeStatus);
        return this;
    }

    public ListEksAnywhereSubscriptionsRequest withIncludeStatus(EksAnywhereSubscriptionStatus ... includeStatus) {
        ArrayList<String> includeStatusCopy = new ArrayList<String>(includeStatus.length);
        for (EksAnywhereSubscriptionStatus value : includeStatus) {
            includeStatusCopy.add(value.toString());
        }
        if (this.getIncludeStatus() == null) {
            this.setIncludeStatus(includeStatusCopy);
        } else {
            this.getIncludeStatus().addAll(includeStatusCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getIncludeStatus() != null) {
            sb.append("IncludeStatus: ").append(this.getIncludeStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEksAnywhereSubscriptionsRequest)) {
            return false;
        }
        ListEksAnywhereSubscriptionsRequest other = (ListEksAnywhereSubscriptionsRequest)obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getIncludeStatus() == null ^ this.getIncludeStatus() == null) {
            return false;
        }
        return other.getIncludeStatus() == null || other.getIncludeStatus().equals(this.getIncludeStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeStatus() == null ? 0 : this.getIncludeStatus().hashCode());
        return hashCode;
    }

    public ListEksAnywhereSubscriptionsRequest clone() {
        return (ListEksAnywhereSubscriptionsRequest)super.clone();
    }
}

