/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eks.model;

import javax.annotation.Generated;

/**
 * 
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public enum AMITypes {

    AL2_x86_64("AL2_x86_64"),
    AL2_x86_64_GPU("AL2_x86_64_GPU"),
    AL2_ARM_64("AL2_ARM_64"),
    CUSTOM("CUSTOM"),
    BOTTLEROCKET_ARM_64("BOTTLEROCKET_ARM_64"),
    BOTTLEROCKET_x86_64("BOTTLEROCKET_x86_64"),
    BOTTLEROCKET_ARM_64_NVIDIA("BOTTLEROCKET_ARM_64_NVIDIA"),
    BOTTLEROCKET_x86_64_NVIDIA("BOTTLEROCKET_x86_64_NVIDIA"),
    WINDOWS_CORE_2019_x86_64("WINDOWS_CORE_2019_x86_64"),
    WINDOWS_FULL_2019_x86_64("WINDOWS_FULL_2019_x86_64"),
    WINDOWS_CORE_2022_x86_64("WINDOWS_CORE_2022_x86_64"),
    WINDOWS_FULL_2022_x86_64("WINDOWS_FULL_2022_x86_64");

    private String value;

    private AMITypes(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return this.value;
    }

    /**
     * Use this in place of valueOf.
     *
     * @param value
     *        real value
     * @return AMITypes corresponding to the value
     *
     * @throws IllegalArgumentException
     *         If the specified value does not map to one of the known values in this enum.
     */
    public static AMITypes fromValue(String value) {
        if (value == null || "".equals(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }

        for (AMITypes enumEntry : AMITypes.values()) {
            if (enumEntry.toString().equals(value)) {
                return enumEntry;
            }
        }

        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }
}
