/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.Insight;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class InsightMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> CATEGORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("category").build();
    private static final MarshallingInfo<String> KUBERNETESVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesVersion").build();
    private static final MarshallingInfo<Date> LASTREFRESHTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastRefreshTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LASTTRANSITIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastTransitionTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<StructuredPojo> INSIGHTSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("insightStatus").build();
    private static final MarshallingInfo<String> RECOMMENDATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recommendation").build();
    private static final MarshallingInfo<Map> ADDITIONALINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("additionalInfo").build();
    private static final MarshallingInfo<List> RESOURCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("resources").build();
    private static final MarshallingInfo<StructuredPojo> CATEGORYSPECIFICSUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categorySpecificSummary").build();
    private static final InsightMarshaller instance = new InsightMarshaller();

    public static InsightMarshaller getInstance() {
        return instance;
    }

    public void marshall(Insight insight, ProtocolMarshaller protocolMarshaller) {
        if (insight == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)insight.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)insight.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)insight.getCategory(), CATEGORY_BINDING);
            protocolMarshaller.marshall((Object)insight.getKubernetesVersion(), KUBERNETESVERSION_BINDING);
            protocolMarshaller.marshall((Object)insight.getLastRefreshTime(), LASTREFRESHTIME_BINDING);
            protocolMarshaller.marshall((Object)insight.getLastTransitionTime(), LASTTRANSITIONTIME_BINDING);
            protocolMarshaller.marshall((Object)insight.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)insight.getInsightStatus(), INSIGHTSTATUS_BINDING);
            protocolMarshaller.marshall((Object)insight.getRecommendation(), RECOMMENDATION_BINDING);
            protocolMarshaller.marshall(insight.getAdditionalInfo(), ADDITIONALINFO_BINDING);
            protocolMarshaller.marshall(insight.getResources(), RESOURCES_BINDING);
            protocolMarshaller.marshall((Object)insight.getCategorySpecificSummary(), CATEGORYSPECIFICSUMMARY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

