/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eksauth.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumeRoleForPodIdentity" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssumeRoleForPodIdentityResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * </p>
     */
    private Subject subject;
    /**
     * <p>
     * The identity that is allowed to use the credentials. This value is always <code>pods.eks.amazonaws.com</code>.
     * </p>
     */
    private String audience;
    /**
     * <p>
     * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     * </p>
     */
    private PodIdentityAssociation podIdentityAssociation;
    /**
     * <p>
     * An object with the permanent IAM role identity and the temporary session name.
     * </p>
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     */
    private AssumedRoleUser assumedRoleUser;
    /**
     * <p>
     * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     * </p>
     */
    private Credentials credentials;

    /**
     * <p>
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * </p>
     * 
     * @param subject
     *        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    /**
     * <p>
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * </p>
     * 
     * @return The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     */

    public Subject getSubject() {
        return this.subject;
    }

    /**
     * <p>
     * The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * </p>
     * 
     * @param subject
     *        The name of the Kubernetes service account inside the cluster to associate the IAM credentials with.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumeRoleForPodIdentityResult withSubject(Subject subject) {
        setSubject(subject);
        return this;
    }

    /**
     * <p>
     * The identity that is allowed to use the credentials. This value is always <code>pods.eks.amazonaws.com</code>.
     * </p>
     * 
     * @param audience
     *        The identity that is allowed to use the credentials. This value is always
     *        <code>pods.eks.amazonaws.com</code>.
     */

    public void setAudience(String audience) {
        this.audience = audience;
    }

    /**
     * <p>
     * The identity that is allowed to use the credentials. This value is always <code>pods.eks.amazonaws.com</code>.
     * </p>
     * 
     * @return The identity that is allowed to use the credentials. This value is always
     *         <code>pods.eks.amazonaws.com</code>.
     */

    public String getAudience() {
        return this.audience;
    }

    /**
     * <p>
     * The identity that is allowed to use the credentials. This value is always <code>pods.eks.amazonaws.com</code>.
     * </p>
     * 
     * @param audience
     *        The identity that is allowed to use the credentials. This value is always
     *        <code>pods.eks.amazonaws.com</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumeRoleForPodIdentityResult withAudience(String audience) {
        setAudience(audience);
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     * </p>
     * 
     * @param podIdentityAssociation
     *        The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     */

    public void setPodIdentityAssociation(PodIdentityAssociation podIdentityAssociation) {
        this.podIdentityAssociation = podIdentityAssociation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     */

    public PodIdentityAssociation getPodIdentityAssociation() {
        return this.podIdentityAssociation;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     * </p>
     * 
     * @param podIdentityAssociation
     *        The Amazon Resource Name (ARN) and ID of the EKS Pod Identity association.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumeRoleForPodIdentityResult withPodIdentityAssociation(PodIdentityAssociation podIdentityAssociation) {
        setPodIdentityAssociation(podIdentityAssociation);
        return this;
    }

    /**
     * <p>
     * An object with the permanent IAM role identity and the temporary session name.
     * </p>
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @param assumedRoleUser
     *        An object with the permanent IAM role identity and the temporary session name.</p>
     *        <p>
     *        The ARN of the IAM role that the temporary credentials authenticate to.
     *        </p>
     *        <p>
     *        The session name of the temporary session requested to STS. The value is a unique identifier that contains
     *        the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The
     *        role ID is generated by IAM when the role is created. The role session name part of the value follows this
     *        format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     */

    public void setAssumedRoleUser(AssumedRoleUser assumedRoleUser) {
        this.assumedRoleUser = assumedRoleUser;
    }

    /**
     * <p>
     * An object with the permanent IAM role identity and the temporary session name.
     * </p>
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @return An object with the permanent IAM role identity and the temporary session name.</p>
     *         <p>
     *         The ARN of the IAM role that the temporary credentials authenticate to.
     *         </p>
     *         <p>
     *         The session name of the temporary session requested to STS. The value is a unique identifier that
     *         contains the role ID, a colon (<code>:</code>), and the role session name of the role that is being
     *         assumed. The role ID is generated by IAM when the role is created. The role session name part of the
     *         value follows this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     */

    public AssumedRoleUser getAssumedRoleUser() {
        return this.assumedRoleUser;
    }

    /**
     * <p>
     * An object with the permanent IAM role identity and the temporary session name.
     * </p>
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @param assumedRoleUser
     *        An object with the permanent IAM role identity and the temporary session name.</p>
     *        <p>
     *        The ARN of the IAM role that the temporary credentials authenticate to.
     *        </p>
     *        <p>
     *        The session name of the temporary session requested to STS. The value is a unique identifier that contains
     *        the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The
     *        role ID is generated by IAM when the role is created. The role session name part of the value follows this
     *        format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumeRoleForPodIdentityResult withAssumedRoleUser(AssumedRoleUser assumedRoleUser) {
        setAssumedRoleUser(assumedRoleUser);
        return this;
    }

    /**
     * <p>
     * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     * </p>
     * 
     * @param credentials
     *        The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     */

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    /**
     * <p>
     * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     * </p>
     * 
     * @return The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     */

    public Credentials getCredentials() {
        return this.credentials;
    }

    /**
     * <p>
     * The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     * </p>
     * 
     * @param credentials
     *        The <i>Amazon Web Services Signature Version 4</i> type of temporary credentials.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumeRoleForPodIdentityResult withCredentials(Credentials credentials) {
        setCredentials(credentials);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSubject() != null)
            sb.append("Subject: ").append(getSubject()).append(",");
        if (getAudience() != null)
            sb.append("Audience: ").append(getAudience()).append(",");
        if (getPodIdentityAssociation() != null)
            sb.append("PodIdentityAssociation: ").append(getPodIdentityAssociation()).append(",");
        if (getAssumedRoleUser() != null)
            sb.append("AssumedRoleUser: ").append(getAssumedRoleUser()).append(",");
        if (getCredentials() != null)
            sb.append("Credentials: ").append("***Sensitive Data Redacted***");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AssumeRoleForPodIdentityResult == false)
            return false;
        AssumeRoleForPodIdentityResult other = (AssumeRoleForPodIdentityResult) obj;
        if (other.getSubject() == null ^ this.getSubject() == null)
            return false;
        if (other.getSubject() != null && other.getSubject().equals(this.getSubject()) == false)
            return false;
        if (other.getAudience() == null ^ this.getAudience() == null)
            return false;
        if (other.getAudience() != null && other.getAudience().equals(this.getAudience()) == false)
            return false;
        if (other.getPodIdentityAssociation() == null ^ this.getPodIdentityAssociation() == null)
            return false;
        if (other.getPodIdentityAssociation() != null && other.getPodIdentityAssociation().equals(this.getPodIdentityAssociation()) == false)
            return false;
        if (other.getAssumedRoleUser() == null ^ this.getAssumedRoleUser() == null)
            return false;
        if (other.getAssumedRoleUser() != null && other.getAssumedRoleUser().equals(this.getAssumedRoleUser()) == false)
            return false;
        if (other.getCredentials() == null ^ this.getCredentials() == null)
            return false;
        if (other.getCredentials() != null && other.getCredentials().equals(this.getCredentials()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSubject() == null) ? 0 : getSubject().hashCode());
        hashCode = prime * hashCode + ((getAudience() == null) ? 0 : getAudience().hashCode());
        hashCode = prime * hashCode + ((getPodIdentityAssociation() == null) ? 0 : getPodIdentityAssociation().hashCode());
        hashCode = prime * hashCode + ((getAssumedRoleUser() == null) ? 0 : getAssumedRoleUser().hashCode());
        hashCode = prime * hashCode + ((getCredentials() == null) ? 0 : getCredentials().hashCode());
        return hashCode;
    }

    @Override
    public AssumeRoleForPodIdentityResult clone() {
        try {
            return (AssumeRoleForPodIdentityResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
