/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.elasticache.AmazonElastiCacheAsync;
import com.amazonaws.services.elasticache.AmazonElastiCacheAsyncClientBuilder;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import com.amazonaws.services.elasticache.model.AddTagsToResourceRequest;
import com.amazonaws.services.elasticache.model.AddTagsToResourceResult;
import com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheParameterGroup;
import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.CacheSubnetGroup;
import com.amazonaws.services.elasticache.model.CopySnapshotRequest;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.CreateSnapshotRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupResult;
import com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupResult;
import com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteSnapshotRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsResult;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeReplicationGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsResult;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest;
import com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesResult;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest;
import com.amazonaws.services.elasticache.model.DescribeSnapshotsResult;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest;
import com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsResult;
import com.amazonaws.services.elasticache.model.ListTagsForResourceRequest;
import com.amazonaws.services.elasticache.model.ListTagsForResourceResult;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest;
import com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.elasticache.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.elasticache.model.ReplicationGroup;
import com.amazonaws.services.elasticache.model.ReservedCacheNode;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.Snapshot;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonElastiCacheAsyncClient
extends AmazonElastiCacheClient
implements AmazonElastiCacheAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonElastiCacheAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonElastiCacheAsyncClientBuilder asyncBuilder() {
        return AmazonElastiCacheAsyncClientBuilder.standard();
    }

    AmazonElastiCacheAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        final AddTagsToResourceRequest finalRequest = (AddTagsToResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeAddTagsToResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(AuthorizeCacheSecurityGroupIngressRequest request) {
        return this.authorizeCacheSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(AuthorizeCacheSecurityGroupIngressRequest request, final AsyncHandler<AuthorizeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) {
        final AuthorizeCacheSecurityGroupIngressRequest finalRequest = (AuthorizeCacheSecurityGroupIngressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeAuthorizeCacheSecurityGroupIngress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> copySnapshotAsync(CopySnapshotRequest request) {
        return this.copySnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> copySnapshotAsync(CopySnapshotRequest request, final AsyncHandler<CopySnapshotRequest, Snapshot> asyncHandler) {
        final CopySnapshotRequest finalRequest = (CopySnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCopySnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(CreateCacheClusterRequest request) {
        return this.createCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(CreateCacheClusterRequest request, final AsyncHandler<CreateCacheClusterRequest, CacheCluster> asyncHandler) {
        final CreateCacheClusterRequest finalRequest = (CreateCacheClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCreateCacheCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(CreateCacheParameterGroupRequest request) {
        return this.createCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(CreateCacheParameterGroupRequest request, final AsyncHandler<CreateCacheParameterGroupRequest, CacheParameterGroup> asyncHandler) {
        final CreateCacheParameterGroupRequest finalRequest = (CreateCacheParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                CacheParameterGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCreateCacheParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(CreateCacheSecurityGroupRequest request) {
        return this.createCacheSecurityGroupAsync(request, null);
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(CreateCacheSecurityGroupRequest request, final AsyncHandler<CreateCacheSecurityGroupRequest, CacheSecurityGroup> asyncHandler) {
        final CreateCacheSecurityGroupRequest finalRequest = (CreateCacheSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCreateCacheSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> createCacheSubnetGroupAsync(CreateCacheSubnetGroupRequest request) {
        return this.createCacheSubnetGroupAsync(request, null);
    }

    @Override
    public Future<CacheSubnetGroup> createCacheSubnetGroupAsync(CreateCacheSubnetGroupRequest request, final AsyncHandler<CreateCacheSubnetGroupRequest, CacheSubnetGroup> asyncHandler) {
        final CreateCacheSubnetGroupRequest finalRequest = (CreateCacheSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                CacheSubnetGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCreateCacheSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> createReplicationGroupAsync(CreateReplicationGroupRequest request) {
        return this.createReplicationGroupAsync(request, null);
    }

    @Override
    public Future<ReplicationGroup> createReplicationGroupAsync(CreateReplicationGroupRequest request, final AsyncHandler<CreateReplicationGroupRequest, ReplicationGroup> asyncHandler) {
        final CreateReplicationGroupRequest finalRequest = (CreateReplicationGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCreateReplicationGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> createSnapshotAsync(CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, Snapshot> asyncHandler) {
        final CreateSnapshotRequest finalRequest = (CreateSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeCreateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(DeleteCacheClusterRequest request) {
        return this.deleteCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(DeleteCacheClusterRequest request, final AsyncHandler<DeleteCacheClusterRequest, CacheCluster> asyncHandler) {
        final DeleteCacheClusterRequest finalRequest = (DeleteCacheClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDeleteCacheCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCacheParameterGroupResult> deleteCacheParameterGroupAsync(DeleteCacheParameterGroupRequest request) {
        return this.deleteCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<DeleteCacheParameterGroupResult> deleteCacheParameterGroupAsync(DeleteCacheParameterGroupRequest request, final AsyncHandler<DeleteCacheParameterGroupRequest, DeleteCacheParameterGroupResult> asyncHandler) {
        final DeleteCacheParameterGroupRequest finalRequest = (DeleteCacheParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCacheParameterGroupResult>(){

            @Override
            public DeleteCacheParameterGroupResult call() throws Exception {
                DeleteCacheParameterGroupResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDeleteCacheParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCacheSecurityGroupResult> deleteCacheSecurityGroupAsync(DeleteCacheSecurityGroupRequest request) {
        return this.deleteCacheSecurityGroupAsync(request, null);
    }

    @Override
    public Future<DeleteCacheSecurityGroupResult> deleteCacheSecurityGroupAsync(DeleteCacheSecurityGroupRequest request, final AsyncHandler<DeleteCacheSecurityGroupRequest, DeleteCacheSecurityGroupResult> asyncHandler) {
        final DeleteCacheSecurityGroupRequest finalRequest = (DeleteCacheSecurityGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCacheSecurityGroupResult>(){

            @Override
            public DeleteCacheSecurityGroupResult call() throws Exception {
                DeleteCacheSecurityGroupResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDeleteCacheSecurityGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCacheSubnetGroupResult> deleteCacheSubnetGroupAsync(DeleteCacheSubnetGroupRequest request) {
        return this.deleteCacheSubnetGroupAsync(request, null);
    }

    @Override
    public Future<DeleteCacheSubnetGroupResult> deleteCacheSubnetGroupAsync(DeleteCacheSubnetGroupRequest request, final AsyncHandler<DeleteCacheSubnetGroupRequest, DeleteCacheSubnetGroupResult> asyncHandler) {
        final DeleteCacheSubnetGroupRequest finalRequest = (DeleteCacheSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteCacheSubnetGroupResult>(){

            @Override
            public DeleteCacheSubnetGroupResult call() throws Exception {
                DeleteCacheSubnetGroupResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDeleteCacheSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> deleteReplicationGroupAsync(DeleteReplicationGroupRequest request) {
        return this.deleteReplicationGroupAsync(request, null);
    }

    @Override
    public Future<ReplicationGroup> deleteReplicationGroupAsync(DeleteReplicationGroupRequest request, final AsyncHandler<DeleteReplicationGroupRequest, ReplicationGroup> asyncHandler) {
        final DeleteReplicationGroupRequest finalRequest = (DeleteReplicationGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDeleteReplicationGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<Snapshot> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotAsync(request, null);
    }

    @Override
    public Future<Snapshot> deleteSnapshotAsync(DeleteSnapshotRequest request, final AsyncHandler<DeleteSnapshotRequest, Snapshot> asyncHandler) {
        final DeleteSnapshotRequest finalRequest = (DeleteSnapshotRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<Snapshot>(){

            @Override
            public Snapshot call() throws Exception {
                Snapshot result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDeleteSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(DescribeCacheClustersRequest request) {
        return this.describeCacheClustersAsync(request, null);
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(DescribeCacheClustersRequest request, final AsyncHandler<DescribeCacheClustersRequest, DescribeCacheClustersResult> asyncHandler) {
        final DescribeCacheClustersRequest finalRequest = (DescribeCacheClustersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                DescribeCacheClustersResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeCacheClusters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync() {
        return this.describeCacheClustersAsync(new DescribeCacheClustersRequest());
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(AsyncHandler<DescribeCacheClustersRequest, DescribeCacheClustersResult> asyncHandler) {
        return this.describeCacheClustersAsync(new DescribeCacheClustersRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(DescribeCacheEngineVersionsRequest request) {
        return this.describeCacheEngineVersionsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(DescribeCacheEngineVersionsRequest request, final AsyncHandler<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResult> asyncHandler) {
        final DescribeCacheEngineVersionsRequest finalRequest = (DescribeCacheEngineVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCacheEngineVersionsResult>(){

            @Override
            public DescribeCacheEngineVersionsResult call() throws Exception {
                DescribeCacheEngineVersionsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeCacheEngineVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync() {
        return this.describeCacheEngineVersionsAsync(new DescribeCacheEngineVersionsRequest());
    }

    @Override
    public Future<DescribeCacheEngineVersionsResult> describeCacheEngineVersionsAsync(AsyncHandler<DescribeCacheEngineVersionsRequest, DescribeCacheEngineVersionsResult> asyncHandler) {
        return this.describeCacheEngineVersionsAsync(new DescribeCacheEngineVersionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(DescribeCacheParameterGroupsRequest request) {
        return this.describeCacheParameterGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(DescribeCacheParameterGroupsRequest request, final AsyncHandler<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResult> asyncHandler) {
        final DescribeCacheParameterGroupsRequest finalRequest = (DescribeCacheParameterGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                DescribeCacheParameterGroupsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeCacheParameterGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync() {
        return this.describeCacheParameterGroupsAsync(new DescribeCacheParameterGroupsRequest());
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(AsyncHandler<DescribeCacheParameterGroupsRequest, DescribeCacheParameterGroupsResult> asyncHandler) {
        return this.describeCacheParameterGroupsAsync(new DescribeCacheParameterGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(DescribeCacheParametersRequest request) {
        return this.describeCacheParametersAsync(request, null);
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(DescribeCacheParametersRequest request, final AsyncHandler<DescribeCacheParametersRequest, DescribeCacheParametersResult> asyncHandler) {
        final DescribeCacheParametersRequest finalRequest = (DescribeCacheParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                DescribeCacheParametersResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeCacheParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(DescribeCacheSecurityGroupsRequest request) {
        return this.describeCacheSecurityGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(DescribeCacheSecurityGroupsRequest request, final AsyncHandler<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResult> asyncHandler) {
        final DescribeCacheSecurityGroupsRequest finalRequest = (DescribeCacheSecurityGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                DescribeCacheSecurityGroupsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeCacheSecurityGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync() {
        return this.describeCacheSecurityGroupsAsync(new DescribeCacheSecurityGroupsRequest());
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(AsyncHandler<DescribeCacheSecurityGroupsRequest, DescribeCacheSecurityGroupsResult> asyncHandler) {
        return this.describeCacheSecurityGroupsAsync(new DescribeCacheSecurityGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(DescribeCacheSubnetGroupsRequest request) {
        return this.describeCacheSubnetGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(DescribeCacheSubnetGroupsRequest request, final AsyncHandler<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResult> asyncHandler) {
        final DescribeCacheSubnetGroupsRequest finalRequest = (DescribeCacheSubnetGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCacheSubnetGroupsResult>(){

            @Override
            public DescribeCacheSubnetGroupsResult call() throws Exception {
                DescribeCacheSubnetGroupsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeCacheSubnetGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync() {
        return this.describeCacheSubnetGroupsAsync(new DescribeCacheSubnetGroupsRequest());
    }

    @Override
    public Future<DescribeCacheSubnetGroupsResult> describeCacheSubnetGroupsAsync(AsyncHandler<DescribeCacheSubnetGroupsRequest, DescribeCacheSubnetGroupsResult> asyncHandler) {
        return this.describeCacheSubnetGroupsAsync(new DescribeCacheSubnetGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(DescribeEngineDefaultParametersRequest request) {
        return this.describeEngineDefaultParametersAsync(request, null);
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(DescribeEngineDefaultParametersRequest request, final AsyncHandler<DescribeEngineDefaultParametersRequest, EngineDefaults> asyncHandler) {
        final DescribeEngineDefaultParametersRequest finalRequest = (DescribeEngineDefaultParametersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                EngineDefaults result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeEngineDefaultParameters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        final DescribeEventsRequest finalRequest = (DescribeEventsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeEvents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync() {
        return this.describeEventsAsync(new DescribeEventsRequest());
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.describeEventsAsync(new DescribeEventsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(DescribeReplicationGroupsRequest request) {
        return this.describeReplicationGroupsAsync(request, null);
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(DescribeReplicationGroupsRequest request, final AsyncHandler<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult> asyncHandler) {
        final DescribeReplicationGroupsRequest finalRequest = (DescribeReplicationGroupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReplicationGroupsResult>(){

            @Override
            public DescribeReplicationGroupsResult call() throws Exception {
                DescribeReplicationGroupsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeReplicationGroups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync() {
        return this.describeReplicationGroupsAsync(new DescribeReplicationGroupsRequest());
    }

    @Override
    public Future<DescribeReplicationGroupsResult> describeReplicationGroupsAsync(AsyncHandler<DescribeReplicationGroupsRequest, DescribeReplicationGroupsResult> asyncHandler) {
        return this.describeReplicationGroupsAsync(new DescribeReplicationGroupsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(DescribeReservedCacheNodesRequest request) {
        return this.describeReservedCacheNodesAsync(request, null);
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(DescribeReservedCacheNodesRequest request, final AsyncHandler<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResult> asyncHandler) {
        final DescribeReservedCacheNodesRequest finalRequest = (DescribeReservedCacheNodesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesResult>(){

            @Override
            public DescribeReservedCacheNodesResult call() throws Exception {
                DescribeReservedCacheNodesResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeReservedCacheNodes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync() {
        return this.describeReservedCacheNodesAsync(new DescribeReservedCacheNodesRequest());
    }

    @Override
    public Future<DescribeReservedCacheNodesResult> describeReservedCacheNodesAsync(AsyncHandler<DescribeReservedCacheNodesRequest, DescribeReservedCacheNodesResult> asyncHandler) {
        return this.describeReservedCacheNodesAsync(new DescribeReservedCacheNodesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(DescribeReservedCacheNodesOfferingsRequest request) {
        return this.describeReservedCacheNodesOfferingsAsync(request, null);
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(DescribeReservedCacheNodesOfferingsRequest request, final AsyncHandler<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResult> asyncHandler) {
        final DescribeReservedCacheNodesOfferingsRequest finalRequest = (DescribeReservedCacheNodesOfferingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeReservedCacheNodesOfferingsResult>(){

            @Override
            public DescribeReservedCacheNodesOfferingsResult call() throws Exception {
                DescribeReservedCacheNodesOfferingsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeReservedCacheNodesOfferings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync() {
        return this.describeReservedCacheNodesOfferingsAsync(new DescribeReservedCacheNodesOfferingsRequest());
    }

    @Override
    public Future<DescribeReservedCacheNodesOfferingsResult> describeReservedCacheNodesOfferingsAsync(AsyncHandler<DescribeReservedCacheNodesOfferingsRequest, DescribeReservedCacheNodesOfferingsResult> asyncHandler) {
        return this.describeReservedCacheNodesOfferingsAsync(new DescribeReservedCacheNodesOfferingsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request) {
        return this.describeSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        final DescribeSnapshotsRequest finalRequest = (DescribeSnapshotsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeDescribeSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync() {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest());
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync(ListAllowedNodeTypeModificationsRequest request) {
        return this.listAllowedNodeTypeModificationsAsync(request, null);
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync(ListAllowedNodeTypeModificationsRequest request, final AsyncHandler<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResult> asyncHandler) {
        final ListAllowedNodeTypeModificationsRequest finalRequest = (ListAllowedNodeTypeModificationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAllowedNodeTypeModificationsResult>(){

            @Override
            public ListAllowedNodeTypeModificationsResult call() throws Exception {
                ListAllowedNodeTypeModificationsResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeListAllowedNodeTypeModifications(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync() {
        return this.listAllowedNodeTypeModificationsAsync(new ListAllowedNodeTypeModificationsRequest());
    }

    @Override
    public Future<ListAllowedNodeTypeModificationsResult> listAllowedNodeTypeModificationsAsync(AsyncHandler<ListAllowedNodeTypeModificationsRequest, ListAllowedNodeTypeModificationsResult> asyncHandler) {
        return this.listAllowedNodeTypeModificationsAsync(new ListAllowedNodeTypeModificationsRequest(), asyncHandler);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(ModifyCacheClusterRequest request) {
        return this.modifyCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(ModifyCacheClusterRequest request, final AsyncHandler<ModifyCacheClusterRequest, CacheCluster> asyncHandler) {
        final ModifyCacheClusterRequest finalRequest = (ModifyCacheClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeModifyCacheCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(ModifyCacheParameterGroupRequest request) {
        return this.modifyCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(ModifyCacheParameterGroupRequest request, final AsyncHandler<ModifyCacheParameterGroupRequest, ModifyCacheParameterGroupResult> asyncHandler) {
        final ModifyCacheParameterGroupRequest finalRequest = (ModifyCacheParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                ModifyCacheParameterGroupResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeModifyCacheParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSubnetGroup> modifyCacheSubnetGroupAsync(ModifyCacheSubnetGroupRequest request) {
        return this.modifyCacheSubnetGroupAsync(request, null);
    }

    @Override
    public Future<CacheSubnetGroup> modifyCacheSubnetGroupAsync(ModifyCacheSubnetGroupRequest request, final AsyncHandler<ModifyCacheSubnetGroupRequest, CacheSubnetGroup> asyncHandler) {
        final ModifyCacheSubnetGroupRequest finalRequest = (ModifyCacheSubnetGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheSubnetGroup>(){

            @Override
            public CacheSubnetGroup call() throws Exception {
                CacheSubnetGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeModifyCacheSubnetGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReplicationGroup> modifyReplicationGroupAsync(ModifyReplicationGroupRequest request) {
        return this.modifyReplicationGroupAsync(request, null);
    }

    @Override
    public Future<ReplicationGroup> modifyReplicationGroupAsync(ModifyReplicationGroupRequest request, final AsyncHandler<ModifyReplicationGroupRequest, ReplicationGroup> asyncHandler) {
        final ModifyReplicationGroupRequest finalRequest = (ModifyReplicationGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReplicationGroup>(){

            @Override
            public ReplicationGroup call() throws Exception {
                ReplicationGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeModifyReplicationGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(PurchaseReservedCacheNodesOfferingRequest request) {
        return this.purchaseReservedCacheNodesOfferingAsync(request, null);
    }

    @Override
    public Future<ReservedCacheNode> purchaseReservedCacheNodesOfferingAsync(PurchaseReservedCacheNodesOfferingRequest request, final AsyncHandler<PurchaseReservedCacheNodesOfferingRequest, ReservedCacheNode> asyncHandler) {
        final PurchaseReservedCacheNodesOfferingRequest finalRequest = (PurchaseReservedCacheNodesOfferingRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ReservedCacheNode>(){

            @Override
            public ReservedCacheNode call() throws Exception {
                ReservedCacheNode result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executePurchaseReservedCacheNodesOffering(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(RebootCacheClusterRequest request) {
        return this.rebootCacheClusterAsync(request, null);
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(RebootCacheClusterRequest request, final AsyncHandler<RebootCacheClusterRequest, CacheCluster> asyncHandler) {
        final RebootCacheClusterRequest finalRequest = (RebootCacheClusterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                CacheCluster result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeRebootCacheCluster(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        final RemoveTagsFromResourceRequest finalRequest = (RemoveTagsFromResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeRemoveTagsFromResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(ResetCacheParameterGroupRequest request) {
        return this.resetCacheParameterGroupAsync(request, null);
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(ResetCacheParameterGroupRequest request, final AsyncHandler<ResetCacheParameterGroupRequest, ResetCacheParameterGroupResult> asyncHandler) {
        final ResetCacheParameterGroupRequest finalRequest = (ResetCacheParameterGroupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                ResetCacheParameterGroupResult result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeResetCacheParameterGroup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(RevokeCacheSecurityGroupIngressRequest request) {
        return this.revokeCacheSecurityGroupIngressAsync(request, null);
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(RevokeCacheSecurityGroupIngressRequest request, final AsyncHandler<RevokeCacheSecurityGroupIngressRequest, CacheSecurityGroup> asyncHandler) {
        final RevokeCacheSecurityGroupIngressRequest finalRequest = (RevokeCacheSecurityGroupIngressRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                CacheSecurityGroup result = null;
                try {
                    result = AmazonElastiCacheAsyncClient.this.executeRevokeCacheSecurityGroupIngress(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

