/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyCacheClusterRequestMarshaller
implements Marshaller<Request<ModifyCacheClusterRequest>, ModifyCacheClusterRequest> {
    public Request<ModifyCacheClusterRequest> marshall(ModifyCacheClusterRequest modifyCacheClusterRequest) {
        SdkInternalList securityGroupIdsList;
        SdkInternalList cacheSecurityGroupNamesList;
        SdkInternalList newAvailabilityZonesList;
        SdkInternalList cacheNodeIdsToRemoveList;
        if (modifyCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyCacheClusterRequest, "AmazonElastiCache");
        request.addParameter("Action", "ModifyCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCacheClusterRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)modifyCacheClusterRequest.getCacheClusterId()));
        }
        if (modifyCacheClusterRequest.getNumCacheNodes() != null) {
            request.addParameter("NumCacheNodes", StringUtils.fromInteger((Integer)modifyCacheClusterRequest.getNumCacheNodes()));
        }
        if (!(cacheNodeIdsToRemoveList = (SdkInternalList)modifyCacheClusterRequest.getCacheNodeIdsToRemove()).isEmpty() || !cacheNodeIdsToRemoveList.isAutoConstruct()) {
            int cacheNodeIdsToRemoveListIndex = 1;
            for (Object cacheNodeIdsToRemoveListValue : cacheNodeIdsToRemoveList) {
                if (cacheNodeIdsToRemoveListValue != null) {
                    request.addParameter("CacheNodeIdsToRemove.CacheNodeId." + cacheNodeIdsToRemoveListIndex, StringUtils.fromString((String)cacheNodeIdsToRemoveListValue));
                }
                ++cacheNodeIdsToRemoveListIndex;
            }
        }
        if (modifyCacheClusterRequest.getAZMode() != null) {
            request.addParameter("AZMode", StringUtils.fromString((String)modifyCacheClusterRequest.getAZMode()));
        }
        if (!(newAvailabilityZonesList = (SdkInternalList)modifyCacheClusterRequest.getNewAvailabilityZones()).isEmpty() || !newAvailabilityZonesList.isAutoConstruct()) {
            int newAvailabilityZonesListIndex = 1;
            for (Object newAvailabilityZonesListValue : newAvailabilityZonesList) {
                if (newAvailabilityZonesListValue != null) {
                    request.addParameter("NewAvailabilityZones.PreferredAvailabilityZone." + newAvailabilityZonesListIndex, StringUtils.fromString((String)newAvailabilityZonesListValue));
                }
                ++newAvailabilityZonesListIndex;
            }
        }
        if (!(cacheSecurityGroupNamesList = (SdkInternalList)modifyCacheClusterRequest.getCacheSecurityGroupNames()).isEmpty() || !cacheSecurityGroupNamesList.isAutoConstruct()) {
            int cacheSecurityGroupNamesListIndex = 1;
            for (String cacheSecurityGroupNamesListValue : cacheSecurityGroupNamesList) {
                if (cacheSecurityGroupNamesListValue != null) {
                    request.addParameter("CacheSecurityGroupNames.CacheSecurityGroupName." + cacheSecurityGroupNamesListIndex, StringUtils.fromString((String)cacheSecurityGroupNamesListValue));
                }
                ++cacheSecurityGroupNamesListIndex;
            }
        }
        if (!(securityGroupIdsList = (SdkInternalList)modifyCacheClusterRequest.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String securityGroupIdsListValue : securityGroupIdsList) {
                if (securityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupIds.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (modifyCacheClusterRequest.getPreferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)modifyCacheClusterRequest.getPreferredMaintenanceWindow()));
        }
        if (modifyCacheClusterRequest.getNotificationTopicArn() != null) {
            request.addParameter("NotificationTopicArn", StringUtils.fromString((String)modifyCacheClusterRequest.getNotificationTopicArn()));
        }
        if (modifyCacheClusterRequest.getCacheParameterGroupName() != null) {
            request.addParameter("CacheParameterGroupName", StringUtils.fromString((String)modifyCacheClusterRequest.getCacheParameterGroupName()));
        }
        if (modifyCacheClusterRequest.getNotificationTopicStatus() != null) {
            request.addParameter("NotificationTopicStatus", StringUtils.fromString((String)modifyCacheClusterRequest.getNotificationTopicStatus()));
        }
        if (modifyCacheClusterRequest.getApplyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringUtils.fromBoolean((Boolean)modifyCacheClusterRequest.getApplyImmediately()));
        }
        if (modifyCacheClusterRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)modifyCacheClusterRequest.getEngineVersion()));
        }
        if (modifyCacheClusterRequest.getAutoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)modifyCacheClusterRequest.getAutoMinorVersionUpgrade()));
        }
        if (modifyCacheClusterRequest.getSnapshotRetentionLimit() != null) {
            request.addParameter("SnapshotRetentionLimit", StringUtils.fromInteger((Integer)modifyCacheClusterRequest.getSnapshotRetentionLimit()));
        }
        if (modifyCacheClusterRequest.getSnapshotWindow() != null) {
            request.addParameter("SnapshotWindow", StringUtils.fromString((String)modifyCacheClusterRequest.getSnapshotWindow()));
        }
        if (modifyCacheClusterRequest.getCacheNodeType() != null) {
            request.addParameter("CacheNodeType", StringUtils.fromString((String)modifyCacheClusterRequest.getCacheNodeType()));
        }
        return request;
    }
}

