/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.NodeSnapshot;
import com.amazonaws.services.elasticache.model.transform.NodeGroupConfigurationStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class NodeSnapshotStaxUnmarshaller
implements Unmarshaller<NodeSnapshot, StaxUnmarshallerContext> {
    private static NodeSnapshotStaxUnmarshaller instance;

    public NodeSnapshot unmarshall(StaxUnmarshallerContext context) throws Exception {
        NodeSnapshot nodeSnapshot = new NodeSnapshot();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return nodeSnapshot;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheClusterId", targetDepth)) {
                    nodeSnapshot.setCacheClusterId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeGroupId", targetDepth)) {
                    nodeSnapshot.setNodeGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeId", targetDepth)) {
                    nodeSnapshot.setCacheNodeId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeGroupConfiguration", targetDepth)) {
                    nodeSnapshot.setNodeGroupConfiguration(NodeGroupConfigurationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheSize", targetDepth)) {
                    nodeSnapshot.setCacheSize(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheNodeCreateTime", targetDepth)) {
                    nodeSnapshot.setCacheNodeCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SnapshotCreateTime", targetDepth)) continue;
                nodeSnapshot.setSnapshotCreateTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return nodeSnapshot;
    }

    public static NodeSnapshotStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NodeSnapshotStaxUnmarshaller();
        }
        return instance;
    }
}

