/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class NodeGroupConfiguration
implements Serializable,
Cloneable {
    private String slots;
    private Integer replicaCount;
    private String primaryAvailabilityZone;
    private SdkInternalList<String> replicaAvailabilityZones;

    public void setSlots(String slots) {
        this.slots = slots;
    }

    public String getSlots() {
        return this.slots;
    }

    public NodeGroupConfiguration withSlots(String slots) {
        this.setSlots(slots);
        return this;
    }

    public void setReplicaCount(Integer replicaCount) {
        this.replicaCount = replicaCount;
    }

    public Integer getReplicaCount() {
        return this.replicaCount;
    }

    public NodeGroupConfiguration withReplicaCount(Integer replicaCount) {
        this.setReplicaCount(replicaCount);
        return this;
    }

    public void setPrimaryAvailabilityZone(String primaryAvailabilityZone) {
        this.primaryAvailabilityZone = primaryAvailabilityZone;
    }

    public String getPrimaryAvailabilityZone() {
        return this.primaryAvailabilityZone;
    }

    public NodeGroupConfiguration withPrimaryAvailabilityZone(String primaryAvailabilityZone) {
        this.setPrimaryAvailabilityZone(primaryAvailabilityZone);
        return this;
    }

    public List<String> getReplicaAvailabilityZones() {
        if (this.replicaAvailabilityZones == null) {
            this.replicaAvailabilityZones = new SdkInternalList();
        }
        return this.replicaAvailabilityZones;
    }

    public void setReplicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
        if (replicaAvailabilityZones == null) {
            this.replicaAvailabilityZones = null;
            return;
        }
        this.replicaAvailabilityZones = new SdkInternalList(replicaAvailabilityZones);
    }

    public NodeGroupConfiguration withReplicaAvailabilityZones(String ... replicaAvailabilityZones) {
        if (this.replicaAvailabilityZones == null) {
            this.setReplicaAvailabilityZones((Collection<String>)new SdkInternalList(replicaAvailabilityZones.length));
        }
        for (String ele : replicaAvailabilityZones) {
            this.replicaAvailabilityZones.add((Object)ele);
        }
        return this;
    }

    public NodeGroupConfiguration withReplicaAvailabilityZones(Collection<String> replicaAvailabilityZones) {
        this.setReplicaAvailabilityZones(replicaAvailabilityZones);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSlots() != null) {
            sb.append("Slots: " + this.getSlots() + ",");
        }
        if (this.getReplicaCount() != null) {
            sb.append("ReplicaCount: " + this.getReplicaCount() + ",");
        }
        if (this.getPrimaryAvailabilityZone() != null) {
            sb.append("PrimaryAvailabilityZone: " + this.getPrimaryAvailabilityZone() + ",");
        }
        if (this.getReplicaAvailabilityZones() != null) {
            sb.append("ReplicaAvailabilityZones: " + this.getReplicaAvailabilityZones());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeGroupConfiguration)) {
            return false;
        }
        NodeGroupConfiguration other = (NodeGroupConfiguration)obj;
        if (other.getSlots() == null ^ this.getSlots() == null) {
            return false;
        }
        if (other.getSlots() != null && !other.getSlots().equals(this.getSlots())) {
            return false;
        }
        if (other.getReplicaCount() == null ^ this.getReplicaCount() == null) {
            return false;
        }
        if (other.getReplicaCount() != null && !other.getReplicaCount().equals(this.getReplicaCount())) {
            return false;
        }
        if (other.getPrimaryAvailabilityZone() == null ^ this.getPrimaryAvailabilityZone() == null) {
            return false;
        }
        if (other.getPrimaryAvailabilityZone() != null && !other.getPrimaryAvailabilityZone().equals(this.getPrimaryAvailabilityZone())) {
            return false;
        }
        if (other.getReplicaAvailabilityZones() == null ^ this.getReplicaAvailabilityZones() == null) {
            return false;
        }
        return other.getReplicaAvailabilityZones() == null || other.getReplicaAvailabilityZones().equals(this.getReplicaAvailabilityZones());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSlots() == null ? 0 : this.getSlots().hashCode());
        hashCode = 31 * hashCode + (this.getReplicaCount() == null ? 0 : this.getReplicaCount().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryAvailabilityZone() == null ? 0 : this.getPrimaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getReplicaAvailabilityZones() == null ? 0 : this.getReplicaAvailabilityZones().hashCode());
        return hashCode;
    }

    public NodeGroupConfiguration clone() {
        try {
            return (NodeGroupConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

