/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.AutomaticFailoverStatus;
import com.amazonaws.services.elasticache.model.Endpoint;
import com.amazonaws.services.elasticache.model.NodeGroup;
import com.amazonaws.services.elasticache.model.ReplicationGroupPendingModifiedValues;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ReplicationGroup
implements Serializable,
Cloneable {
    private String replicationGroupId;
    private String description;
    private String status;
    private ReplicationGroupPendingModifiedValues pendingModifiedValues;
    private SdkInternalList<String> memberClusters;
    private SdkInternalList<NodeGroup> nodeGroups;
    private String snapshottingClusterId;
    private String automaticFailover;
    private Endpoint configurationEndpoint;
    private Integer snapshotRetentionLimit;
    private String snapshotWindow;

    public void setReplicationGroupId(String replicationGroupId) {
        this.replicationGroupId = replicationGroupId;
    }

    public String getReplicationGroupId() {
        return this.replicationGroupId;
    }

    public ReplicationGroup withReplicationGroupId(String replicationGroupId) {
        this.setReplicationGroupId(replicationGroupId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ReplicationGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ReplicationGroup withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public ReplicationGroupPendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public ReplicationGroup withPendingModifiedValues(ReplicationGroupPendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public List<String> getMemberClusters() {
        if (this.memberClusters == null) {
            this.memberClusters = new SdkInternalList();
        }
        return this.memberClusters;
    }

    public void setMemberClusters(Collection<String> memberClusters) {
        if (memberClusters == null) {
            this.memberClusters = null;
            return;
        }
        this.memberClusters = new SdkInternalList(memberClusters);
    }

    public ReplicationGroup withMemberClusters(String ... memberClusters) {
        if (this.memberClusters == null) {
            this.setMemberClusters((Collection<String>)new SdkInternalList(memberClusters.length));
        }
        for (String ele : memberClusters) {
            this.memberClusters.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withMemberClusters(Collection<String> memberClusters) {
        this.setMemberClusters(memberClusters);
        return this;
    }

    public List<NodeGroup> getNodeGroups() {
        if (this.nodeGroups == null) {
            this.nodeGroups = new SdkInternalList();
        }
        return this.nodeGroups;
    }

    public void setNodeGroups(Collection<NodeGroup> nodeGroups) {
        if (nodeGroups == null) {
            this.nodeGroups = null;
            return;
        }
        this.nodeGroups = new SdkInternalList(nodeGroups);
    }

    public ReplicationGroup withNodeGroups(NodeGroup ... nodeGroups) {
        if (this.nodeGroups == null) {
            this.setNodeGroups((Collection<NodeGroup>)new SdkInternalList(nodeGroups.length));
        }
        for (NodeGroup ele : nodeGroups) {
            this.nodeGroups.add((Object)ele);
        }
        return this;
    }

    public ReplicationGroup withNodeGroups(Collection<NodeGroup> nodeGroups) {
        this.setNodeGroups(nodeGroups);
        return this;
    }

    public void setSnapshottingClusterId(String snapshottingClusterId) {
        this.snapshottingClusterId = snapshottingClusterId;
    }

    public String getSnapshottingClusterId() {
        return this.snapshottingClusterId;
    }

    public ReplicationGroup withSnapshottingClusterId(String snapshottingClusterId) {
        this.setSnapshottingClusterId(snapshottingClusterId);
        return this;
    }

    public void setAutomaticFailover(String automaticFailover) {
        this.automaticFailover = automaticFailover;
    }

    public String getAutomaticFailover() {
        return this.automaticFailover;
    }

    public ReplicationGroup withAutomaticFailover(String automaticFailover) {
        this.setAutomaticFailover(automaticFailover);
        return this;
    }

    public void setAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.automaticFailover = automaticFailover.toString();
    }

    public ReplicationGroup withAutomaticFailover(AutomaticFailoverStatus automaticFailover) {
        this.setAutomaticFailover(automaticFailover);
        return this;
    }

    public void setConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public Endpoint getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    public ReplicationGroup withConfigurationEndpoint(Endpoint configurationEndpoint) {
        this.setConfigurationEndpoint(configurationEndpoint);
        return this;
    }

    public void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.snapshotRetentionLimit = snapshotRetentionLimit;
    }

    public Integer getSnapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public ReplicationGroup withSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
        this.setSnapshotRetentionLimit(snapshotRetentionLimit);
        return this;
    }

    public void setSnapshotWindow(String snapshotWindow) {
        this.snapshotWindow = snapshotWindow;
    }

    public String getSnapshotWindow() {
        return this.snapshotWindow;
    }

    public ReplicationGroup withSnapshotWindow(String snapshotWindow) {
        this.setSnapshotWindow(snapshotWindow);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationGroupId() != null) {
            sb.append("ReplicationGroupId: " + this.getReplicationGroupId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: " + this.getPendingModifiedValues() + ",");
        }
        if (this.getMemberClusters() != null) {
            sb.append("MemberClusters: " + this.getMemberClusters() + ",");
        }
        if (this.getNodeGroups() != null) {
            sb.append("NodeGroups: " + this.getNodeGroups() + ",");
        }
        if (this.getSnapshottingClusterId() != null) {
            sb.append("SnapshottingClusterId: " + this.getSnapshottingClusterId() + ",");
        }
        if (this.getAutomaticFailover() != null) {
            sb.append("AutomaticFailover: " + this.getAutomaticFailover() + ",");
        }
        if (this.getConfigurationEndpoint() != null) {
            sb.append("ConfigurationEndpoint: " + this.getConfigurationEndpoint() + ",");
        }
        if (this.getSnapshotRetentionLimit() != null) {
            sb.append("SnapshotRetentionLimit: " + this.getSnapshotRetentionLimit() + ",");
        }
        if (this.getSnapshotWindow() != null) {
            sb.append("SnapshotWindow: " + this.getSnapshotWindow());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroup)) {
            return false;
        }
        ReplicationGroup other = (ReplicationGroup)obj;
        if (other.getReplicationGroupId() == null ^ this.getReplicationGroupId() == null) {
            return false;
        }
        if (other.getReplicationGroupId() != null && !other.getReplicationGroupId().equals(this.getReplicationGroupId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getMemberClusters() == null ^ this.getMemberClusters() == null) {
            return false;
        }
        if (other.getMemberClusters() != null && !other.getMemberClusters().equals(this.getMemberClusters())) {
            return false;
        }
        if (other.getNodeGroups() == null ^ this.getNodeGroups() == null) {
            return false;
        }
        if (other.getNodeGroups() != null && !other.getNodeGroups().equals(this.getNodeGroups())) {
            return false;
        }
        if (other.getSnapshottingClusterId() == null ^ this.getSnapshottingClusterId() == null) {
            return false;
        }
        if (other.getSnapshottingClusterId() != null && !other.getSnapshottingClusterId().equals(this.getSnapshottingClusterId())) {
            return false;
        }
        if (other.getAutomaticFailover() == null ^ this.getAutomaticFailover() == null) {
            return false;
        }
        if (other.getAutomaticFailover() != null && !other.getAutomaticFailover().equals(this.getAutomaticFailover())) {
            return false;
        }
        if (other.getConfigurationEndpoint() == null ^ this.getConfigurationEndpoint() == null) {
            return false;
        }
        if (other.getConfigurationEndpoint() != null && !other.getConfigurationEndpoint().equals(this.getConfigurationEndpoint())) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() == null ^ this.getSnapshotRetentionLimit() == null) {
            return false;
        }
        if (other.getSnapshotRetentionLimit() != null && !other.getSnapshotRetentionLimit().equals(this.getSnapshotRetentionLimit())) {
            return false;
        }
        if (other.getSnapshotWindow() == null ^ this.getSnapshotWindow() == null) {
            return false;
        }
        return other.getSnapshotWindow() == null || other.getSnapshotWindow().equals(this.getSnapshotWindow());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationGroupId() == null ? 0 : this.getReplicationGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMemberClusters() == null ? 0 : this.getMemberClusters().hashCode());
        hashCode = 31 * hashCode + (this.getNodeGroups() == null ? 0 : this.getNodeGroups().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshottingClusterId() == null ? 0 : this.getSnapshottingClusterId().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticFailover() == null ? 0 : this.getAutomaticFailover().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationEndpoint() == null ? 0 : this.getConfigurationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotRetentionLimit() == null ? 0 : this.getSnapshotRetentionLimit().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotWindow() == null ? 0 : this.getSnapshotWindow().hashCode());
        return hashCode;
    }

    public ReplicationGroup clone() {
        try {
            return (ReplicationGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

