/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.services.elasticache.model.ConfigureShard;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ConfigureShardStaxUnmarshaller
implements Unmarshaller<ConfigureShard, StaxUnmarshallerContext> {
    private static ConfigureShardStaxUnmarshaller instance;

    public ConfigureShard unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConfigureShard configureShard = new ConfigureShard();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return configureShard;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("NodeGroupId", targetDepth)) {
                    configureShard.setNodeGroupId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NewReplicaCount", targetDepth)) {
                    configureShard.setNewReplicaCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PreferredAvailabilityZones", targetDepth)) {
                    configureShard.withPreferredAvailabilityZones(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("PreferredAvailabilityZones/PreferredAvailabilityZone", targetDepth)) continue;
                configureShard.withPreferredAvailabilityZones(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return configureShard;
    }

    public static ConfigureShardStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigureShardStaxUnmarshaller();
        }
        return instance;
    }
}

