/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RebootCacheClusterRequestMarshaller
implements Marshaller<Request<RebootCacheClusterRequest>, RebootCacheClusterRequest> {
    public Request<RebootCacheClusterRequest> marshall(RebootCacheClusterRequest rebootCacheClusterRequest) {
        SdkInternalList cacheNodeIdsToRebootList;
        if (rebootCacheClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootCacheClusterRequest, "AmazonElastiCache");
        request.addParameter("Action", "RebootCacheCluster");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootCacheClusterRequest.getCacheClusterId() != null) {
            request.addParameter("CacheClusterId", StringUtils.fromString((String)rebootCacheClusterRequest.getCacheClusterId()));
        }
        if (!(cacheNodeIdsToRebootList = (SdkInternalList)rebootCacheClusterRequest.getCacheNodeIdsToReboot()).isEmpty() || !cacheNodeIdsToRebootList.isAutoConstruct()) {
            int cacheNodeIdsToRebootListIndex = 1;
            for (String cacheNodeIdsToRebootListValue : cacheNodeIdsToRebootList) {
                if (cacheNodeIdsToRebootListValue != null) {
                    request.addParameter("CacheNodeIdsToReboot.CacheNodeId." + cacheNodeIdsToRebootListIndex, StringUtils.fromString((String)cacheNodeIdsToRebootListValue));
                }
                ++cacheNodeIdsToRebootListIndex;
            }
        }
        return request;
    }
}

